/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.repository;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public abstract class UrlLoader {
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String GZIP = "gzip";
    private final String url;
    private final long expiration;
    private long lastModified;
    private long lastChecked;
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public UrlLoader(String url, long expiration) {
        this.url = url;
        this.expiration = expiration;
    }

    public String getUrl() {
        return this.url;
    }

    protected boolean checkAndLoadCache() {
        long time = System.currentTimeMillis();
        if (this.lastChecked > 0L && (this.expiration < 0L || time - this.lastChecked < this.expiration)) {
            return false;
        }
        try {
            URL u = new URL(this.url);
            URLConnection connection = u.openConnection();
            if (connection instanceof HttpURLConnection) {
                int rc;
                HttpURLConnection con = (HttpURLConnection)connection;
                if (this.lastModified > 0L) {
                    con.setIfModifiedSince(this.lastModified);
                }
                con.setRequestProperty(HEADER_ACCEPT_ENCODING, GZIP);
                if (u.getUserInfo() != null) {
                    String encoded = UrlLoader.base64(u.getUserInfo().getBytes(StandardCharsets.UTF_8));
                    connection.setRequestProperty("Authorization", "Basic " + encoded);
                }
                if ((rc = con.getResponseCode()) == 304) {
                    this.lastChecked = time;
                    return false;
                }
                if (rc != 200) {
                    throw new IOException("Unexpected http response loading " + this.url + " : " + rc + " " + con.getResponseMessage());
                }
            }
            if (this.didNotChange(connection)) {
                this.lastChecked = time;
                return false;
            }
            boolean wasRead = this.read(connection);
            this.lastModified = connection.getLastModified();
            this.lastChecked = time;
            return wasRead;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean didNotChange(URLConnection connection) {
        long lm = connection.getLastModified();
        return lm > 0L && lm <= this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(URLConnection connection) throws IOException {
        try (FilterInputStream is = null;){
            is = new BufferedInputStream(connection.getInputStream());
            if (this.isGzipStream(is)) {
                is = new GZIPInputStream(is);
            }
            boolean bl = this.doRead(is);
            return bl;
        }
    }

    private boolean isGzipStream(InputStream is) throws IOException {
        is.mark(512);
        int b0 = is.read();
        int b1 = is.read();
        is.reset();
        return b0 == 31 && b1 == 139;
    }

    protected abstract boolean doRead(InputStream var1) throws IOException;

    protected static String base64(byte[] in) {
        int mod;
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        int buf = 0;
        int bits = 0;
        int out = 0;
        while (true) {
            int c;
            if (bits >= 6) {
                int v = 0x3F & buf >> (bits -= 6);
                sb.append(alphabet.charAt(v));
                ++out;
                continue;
            }
            int n = c = idx < in.length ? in[idx] : -1;
            if (c < 0) break;
            buf <<= 8;
            buf |= 0xFF & c;
            bits += 8;
        }
        if (bits != 0) {
            sb.append(alphabet.charAt(0x3F & buf << 6 - bits));
            ++out;
        }
        if ((mod = 4 - out % 4) != 4) {
            for (int i = 0; i < mod; ++i) {
                sb.append('=');
            }
        }
        return sb.toString();
    }
}

