/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.media.internal;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioManager;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.handler.BaseModuleHandlerFactory;
import org.openhab.core.automation.handler.ModuleHandler;
import org.openhab.core.automation.handler.ModuleHandlerFactory;
import org.openhab.core.automation.module.media.internal.PlayActionHandler;
import org.openhab.core.automation.module.media.internal.SayActionHandler;
import org.openhab.core.automation.module.media.internal.SynthesizeActionHandler;
import org.openhab.core.voice.VoiceManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(service={ModuleHandlerFactory.class})
public class MediaModuleHandlerFactory
extends BaseModuleHandlerFactory {
    private static final Collection<String> TYPES = List.of("media.SayAction", "media.PlayAction");
    private final VoiceManager voiceManager;
    private final AudioManager audioManager;

    @Activate
    public MediaModuleHandlerFactory(@Reference AudioManager audioManager, @Reference VoiceManager voiceManager) {
        this.audioManager = audioManager;
        this.voiceManager = voiceManager;
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    public Collection<String> getTypes() {
        return TYPES;
    }

    protected @Nullable ModuleHandler internalCreate(Module module, String ruleUID) {
        block13: {
            if (!(module instanceof Action)) break block13;
            Action action = (Action)module;
            switch (module.getTypeUID()) {
                case "media.SayAction": {
                    return new SayActionHandler(action, this.voiceManager);
                }
                case "media.PlayAction": {
                    return new PlayActionHandler(action, this.audioManager);
                }
                case "media.SynthesizeAction": {
                    return new SynthesizeActionHandler(action, this.audioManager);
                }
            }
        }
        return null;
    }
}

