/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.history;

import java.io.File;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.history.user.HistoryUserContext;
import org.apache.guacamole.net.auth.AbstractAuthenticationProvider;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.properties.FileGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;

public class HistoryAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final File DEFAULT_RECORDING_SEARCH_PATH = new File("/var/lib/guacamole/recordings");
    private static final FileGuacamoleProperty RECORDING_SEARCH_PATH = new FileGuacamoleProperty(){

        public String getName() {
            return "recording-search-path";
        }
    };

    public static File getRecordingSearchPath() throws GuacamoleException {
        LocalEnvironment environment = LocalEnvironment.getInstance();
        return (File)environment.getProperty((GuacamoleProperty)RECORDING_SEARCH_PATH, (Object)DEFAULT_RECORDING_SEARCH_PATH);
    }

    public String getIdentifier() {
        return "recording-storage";
    }

    public UserContext decorate(UserContext context, AuthenticatedUser authenticatedUser, Credentials credentials) throws GuacamoleException {
        return new HistoryUserContext(context.self(), context);
    }
}

