'\"
'\" Copyright (c) 2011 Kevin Walzer.
'\" Copyright (c) 2011 Donal K. Fellows.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH tk::mac n 8.6 Tk "Tk Built-In Commands"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
tk::mac \- Access Mac-Specific Functionality on macOS from Tk
.SH SYNOPSIS
.nf
\fB::tk::mac::DoScriptFile\fR
\fB::tk::mac::DoScriptText\fR
\fB::tk::mac::ShowPreferences\fR
\fB::tk::mac::OpenApplication\fR
\fB::tk::mac::ReopenApplication\fR
\fB::tk::mac::OpenDocument \fIfile...\fR
\fB::tk::mac::PrintDocument \fIfile...\fR
\fB::tk::mac::Quit\fR
\fB::tk::mac::OnHide\fR
\fB::tk::mac::OnShow\fR
\fB::tk::mac::ShowHelp\fR
\fB::tk::mac::PerformService\fR
\fB::tk::mac::LaunchURL \fIURL...\fR
\fB::tk::mac::GetAppPath\fR

\fB::tk::mac::standardAboutPanel\fR

\fB::tk::mac::useCompatibilityMetrics \fIboolean\fR
\fB::tk::mac::CGAntialiasLimit \fIlimit\fR
\fB::tk::mac::antialiasedtext \fInumber\fR
\fB::tk::mac::useThemedToplevel \fIboolean\fR

\fB::tk::mac::iconBitmap \fIname width height \-kind value\fR
.fi
.BE
.SH "EVENT HANDLER CALLBACKS"
.PP
The Aqua/macOS application environment defines a number of additional
events that applications should respond to. These events are mapped by Tk to
calls to commands in the \fB::tk::mac\fR namespace; unless otherwise noted, if
the command is absent, no action will be taken.
.\" COMMAND: DoScriptFile
.TP
\fB::tk::mac::DoScriptFile\fR
.
The default Apple Event handler for AEDoScriptHandler. This command
executes a Tcl file when an AppleScript sends a
.QW "do script"
command to Wish with a file path as a parameter.
.\" COMMAND: DoScriptText
.TP
\fB::tk::mac::DoScriptText\fR
.
The default Apple Event handler for AEDoScriptHandler. This command
executes Tcl code when an AppleScript sends a
.QW "do script"
command to Wish with Tcl code or a Tcl procedure as a parameter.
.\" COMMAND: ShowPreferences
.TP
\fB::tk::mac::ShowPreferences\fR
.
The default Apple Event handler for kAEShowPreferences,
.QW pref .
The application menu
.QW "Preferences"
menu item is only enabled when this proc is defined. Typically this command is
used to wrap a specific own preferences command, which pops up a preferences
window. Something like:
.RS
.PP
.CS
proc ::tk::mac::ShowPreferences {} {
    setPref
}
.CE
.RE
.\" COMMAND: OpenApplication
.TP
\fB::tk::mac::OpenApplication\fR
.
If a proc of this name is defined, this proc fill fire when your application
is initially opened. It is the default Apple Event handler for
kAEOpenApplication,
.QW oapp .
.\" COMMAND: ReopenApplication
.TP
\fB::tk::mac::ReopenApplication\fR
.
If a proc of this name is defined it is the default Apple Event handler for
kAEReopenApplication,
.QW rapp ,
the Apple Event sent when your application is opened when it is already
running (e.g. by clicking its icon in the Dock). Here is a sample that raises
a minimized window when the Dock icon is clicked:
.RS
.PP
.CS
proc ::tk::mac::ReopenApplication {} {
    if {[wm state .] eq "withdrawn"} {
        wm state . normal
    } else {
        wm deiconify .
    }
    raise .
}
.CE
.RE
.\" COMMAND: OpenDocument
.TP
\fB::tk::mac::OpenDocument \fIfile...\fR
.
If a proc of this name is defined it is the default Apple Event handler for
kAEOpenDocuments,
.QW odoc ,
the Apple Event sent when your application is asked to open one or more
documents (e.g., by drag & drop onto the app or by opening a document of a
type associated to the app). The proc should take as arguments paths to the
files to be opened, like so:
.RS
.PP
.CS
proc ::tk::mac::OpenDocument {args} {
    foreach f $args {my_open_document $f}
}
.CE
.RE
.\" COMMAND: PrintDocument
.TP
\fB::tk::mac::PrintDocument \fIfile...\fR
.
If a proc of this name is defined it is the default Apple Event handler for
kAEPrintDocuments,
.QW pdoc ,
the Apple Event sent when your application is asked to print a
document.  It takes a single absolute file path as an argument.
.\" COMMAND: Quit
.TP
\fB::tk::mac::Quit\fR
.
If a proc of this name is defined it is the default Apple Event handler for
kAEQuitApplication,
.QW quit ,
the Apple Event sent when your application is asked to be quit, e.g. via the
quit menu item in the application menu, the quit menu item in the Dock menu,
or during a logout/restart/shutdown etc. If this is not defined, \fBexit\fR is
called instead.
.\" COMMAND: OnHide
.TP
\fB::tk::mac::OnHide\fR
.
If defined, this is called when your application receives a kEventAppHidden
event, e.g. via the hide menu item in the application or Dock menus.
.\" COMMAND: OnShow
.TP
\fB::tk::mac::OnShow\fR
.
If defined, this is called when your application receives a kEventAppShown
event, e.g. via the show all menu item in the application menu, or by clicking
the Dock icon of a hidden application.
.\" COMMAND: ShowHelp
.TP
\fB::tk::mac::ShowHelp\fR
.
Customizes behavior of Apple Help menu; if this procedure is not defined, the
platform-specific standard Help menu item
.QW "YourApp Help"
performs the default Cocoa action of showing the Help Book configured in the
application's Info.plist (or displaying an alert if no Help Book is
set).
.\" COMMAND: PerformService
.TP
\fB::tk::mac::PerformService\fR
.
Executes a Tcl procedure called from the macOS
.QW Services
menu in the Application menu item. The
.QW Services
menu item allows for inter-application communication; data from one
application, such as selected text, can be sent to another application
for processing, for example to Safari as a search item for Google, or
to TextEdit to be appended to a file. An example of the proc is below,
and should be rewritten in an application script for customization:
.RS
.PP
.CS
proc ::tk::mac::PerformService {} {
    set data [clipboard get]
    $w insert end $data
}
.CE
.RE
Note that the mechanism for retrieving the data is from the clipboard;
there is no other supported way to obtain the data.  If the Services
process is not desired, the NSServices keys can be deleted from
the application's Info.plist file. The underlying code supporting this
command also allows the text, entry and ttk::entry widgets to access
services from other applications via the Services menu. The NSPortName
key in Wish's Info.plist file is currently set as
.QW "Wish"
; if a developer changes the name of the Wish executable to something
  else, this key should be modified with the same name.
.\" COMMAND: LaunchURL
.TP
\fB::tk::mac::LaunchURL \fIURL...\fR
.
If defined, launches a URL within Tk. This would be used if a Tk
application wants to handle a URL itself, such as displaying data from
an RSS feed, rather than launching a default application to handle the
URL, although it can defined as such. Wish includes a stub URL scheme
of
.QW foo://
in the CFBundleURLSchemes key of its Info.plist file; this should be
customized for the specific URL scheme the developer wants to support.
.TP
\fB::tk::mac::GetAppPath\fR
.
Returns the current applications's file path.
.PP
.SH "ADDITIONAL DIALOGS"
.PP
Aqua/macOS defines additional dialogs that applications should
support.
.\" COMMAND: standardAboutPanel
.TP
\fB::tk::mac::standardAboutPanel\fR
.
Brings the standard Cocoa about panel to the front with information filled in
from the application bundle files. The panel displays the application icon and
the values associated to the info.plist keys named CFBundleName,
CFBundleShortVersionString, NSAboutPanelOptionVersion and
NSHumanReadableCopyright.  If a file named \fICredits.html\fR or
\fICredits.rtf\fR exists in the bundle's Resources directory then its contents
will be displayed in a scrolling text box at the bottom of the dialog. See the
documentation for -[NSApplication orderFrontStandardAboutPanelWithOptions:]
for more details. A hook is also provided for a custom About dialog.  If a Tcl
proc named tkAboutDialog is defined in the main interpreter then that
procedure will be called instead of opening the standardAboutPanel.
.SH "SYSTEM CONFIGURATION"
.PP
There are a number of additional global configuration options that control the
details of how Tk renders by default.
.\" COMMAND: useCompatibilityMetrics
.TP
\fB::tk::mac::useCompatibilityMetrics \fIboolean\fR
.
Preserves compatibility with older Tk/Aqua metrics; set to \fBfalse\fR for
more native spacing.
.\" COMMAND: CGAntialiasLimit
.TP
\fB::tk::mac::CGAntialiasLimit \fIlimit\fR
.
Sets the antialiasing limit; lines thinner that \fIlimit\fR pixels will not be
antialiased. Integer, set to 0 by default, making all lines be antialiased.
.\" COMMAND: antialiasedtext
.TP
\fB::tk::mac::antialiasedtext \fInumber\fR
.
Sets anti-aliased text.  Controls text antialiasing, possible values for
\fInumber\fR are -1 (default, use system default for text AA), 0 (no text AA),
1 (use text AA).
.\" COMMAND: useThemedToplevel
.TP
\fB::tk::mac::useThemedToplevel \fIboolean\fR
.
Sets toplevel windows to draw with the modern grayish/ pinstripe Mac
background. Equivalent to configuring the toplevel with
.QW "\fB\-background systemWindowHeaderBackground\fR" ,
or to using a \fBttk::frame\fR.
.SH "SUPPORT COMMANDS"
.\" COMMAND: iconBitmap
.TP
\fB::tk::mac::iconBitmap \fIname width height \-kind value\fR
.
Renders native icons and bitmaps in Tk applications (including any image file
readable by NSImage). A native bitmap name is interpreted as follows (in
order):
.RS
.IP \(bu 3
predefined builtin 32x32 icon name (\fBstop\fR, \fBcaution\fR, \fBdocument\fR,
etc.)
.IP \(bu 3
\fIname\fR, as defined by \fBtk::mac::iconBitmap\fR
.IP \(bu 3
NSImage named image name
.IP \(bu 3
NSImage url string
.IP \(bu 3
4-char OSType of IconServices icon
.PP
The \fIwidth\fR and \fIheight\fR arguments to \fBtk::mac::iconBitmap\fR define
the dimensions of the image to create, and \fI\-kind\fR must be one of:
.\" OPTION: -file
.TP
\fB\-file\fR
.
icon of file at given path
.\" OPTION: -fileType
.TP
\fB\-fileType\fR
.
icon of given file type
.\" OPTION: -osType
.TP
\fB\-osType\fR
.
icon of given 4-char OSType file type
.\" OPTION: -systemType
.TP
\fB\-systemType\fR
.
icon for given IconServices 4-char OSType
.\" OPTION: -namedImage
.TP
\fB\-namedImage\fR
.
named NSImage for given name
.\" OPTION: -imageFile
.TP
\fB\-imageFile\fR
.
image at given path
.RE
.SH "SEE ALSO"
bind(n), wm(n)
.SH KEYWORDS
about dialog, antialiasing, Apple event, icon, NSImage
'\" Local Variables:
'\" mode: nroff
'\" End:
