/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.TargetAppRunner;
import org.graalvm.visualvm.lib.profiler.NetBeansProfiler;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.ProfilingAwareAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.graalvm.visualvm.lib.profiler.v2.SnapshotsWindow;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public final class HeapDumpAction
extends ProfilingAwareAction {
    private static final String SELECTING_TARGET_CANCELLED = "&*$?CANCELLED?$*&";
    private static final int[] ENABLED_STATES = new int[]{4};
    private static JFileChooser snapshotDirectoryChooser;
    private ChooseHeapdumpTargetPanel heapdumpTargetSelector;

    public static HeapDumpAction getInstance() {
        return Singleton.INSTANCE;
    }

    public HeapDumpAction() {
        this.setIcon(Icons.getIcon((String)"ProfilerIcons.SnapshotHeap"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.SnapshotHeap"));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.HeapDumpAction_ActionName();
    }

    public void dumpToProject() {
        this.takeHeapDump(false);
    }

    public void performAction() {
        this.takeHeapDump(true);
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    private String getCurrentHeapDumpFilename(String targetFolder) {
        try {
            String fileName = ResultsManager.getDefault().getDefaultHeapDumpFileName(System.currentTimeMillis());
            FileObject folder = targetFolder == null ? ProfilerStorage.getProjectFolder((Lookup.Provider)NetBeansProfiler.getDefaultNB().getProfiledProject(), (boolean)true) : FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(targetFolder)));
            return FileUtil.toFile((FileObject)folder).getAbsolutePath() + File.separator + FileUtil.findFreeFileName((FileObject)folder, (String)fileName, (String)"hprof") + "." + "hprof";
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void updateAction() {
        String remoteHost;
        boolean remote = false;
        boolean enabled = this.shouldBeEnabled(Profiler.getDefault());
        if (enabled && (remoteHost = Profiler.getDefault().getTargetAppRunner().getProfilerEngineSettings().getRemoteHost()) != null && !remoteHost.isEmpty()) {
            remote = true;
        }
        this.setEnabled(!remote && enabled);
        this.setToolTipText(remote ? Bundle.HeapDumpAction_ToolTipNoRemote() : Bundle.HeapDumpAction_ToolTip());
    }

    private void setToolTipText(String text) {
        Object oldText = this.getProperty("ShortDescription");
        this.putProperty("ShortDescription", text);
        this.firePropertyChange("ShortDescription", oldText, text);
    }

    private static JFileChooser getSnapshotDirectoryChooser() {
        if (snapshotDirectoryChooser == null) {
            snapshotDirectoryChooser = new JFileChooser();
            snapshotDirectoryChooser.setFileSelectionMode(1);
            snapshotDirectoryChooser.setMultiSelectionEnabled(false);
            snapshotDirectoryChooser.setDialogType(0);
            snapshotDirectoryChooser.setDialogTitle(Bundle.HeapDumpAction_DirectoryDialogCaption());
        }
        return snapshotDirectoryChooser;
    }

    private ChooseHeapdumpTargetPanel getHeapdumpTargetSelector() {
        if (this.heapdumpTargetSelector == null) {
            this.heapdumpTargetSelector = new ChooseHeapdumpTargetPanel();
        }
        return this.heapdumpTargetSelector;
    }

    private String selectTargetDirectory() {
        ChooseHeapdumpTargetPanel targetSelector = this.getHeapdumpTargetSelector();
        targetSelector.updateDefaultLocation(NetBeansProfiler.getDefaultNB().getProfiledProject() != null ? Bundle.HeapDumpAction_LocationProjectString() : Bundle.HeapDumpAction_LocationGlobalString());
        int previousType = targetSelector.getDestinationType();
        String previousDirectory = targetSelector.getCustomDirectory();
        DialogDescriptor desc = new DialogDescriptor((Object)targetSelector, Bundle.HeapDumpAction_DestinationDialogCaption(), true, new Object[]{targetSelector.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        if (!res.equals(targetSelector.getOKButton())) {
            targetSelector.setDestinationType(previousType);
            targetSelector.setCustomDirectory(previousDirectory);
            return SELECTING_TARGET_CANCELLED;
        }
        int destinationType = targetSelector.getDestinationType();
        if (destinationType == 0) {
            targetSelector.setCustomDirectory(previousDirectory);
            return this.getCurrentHeapDumpFilename(null);
        }
        if (destinationType == 1) {
            return this.getCurrentHeapDumpFilename(targetSelector.getCustomDirectory());
        }
        return null;
    }

    private void takeHeapDump(final boolean askForDestination) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TargetAppRunner targetApp = Profiler.getDefault().getTargetAppRunner();
                if (!targetApp.hasSupportedJDKForHeapDump()) {
                    ProfilerDialogs.displayWarning((String)Bundle.HeapDumpAction_RequiredJdkMsg());
                    return;
                }
                if (targetApp.getProfilingSessionStatus().remoteProfiling) {
                    ProfilerDialogs.displayWarning((String)Bundle.HeapDumpAction_RemoteUnsupportedMsg());
                    return;
                }
                try {
                    String dumpFileName;
                    String string = dumpFileName = askForDestination ? HeapDumpAction.this.selectTargetDirectory() : HeapDumpAction.this.getCurrentHeapDumpFilename(null);
                    if (dumpFileName == HeapDumpAction.SELECTING_TARGET_CANCELLED) {
                        return;
                    }
                    if (dumpFileName == null) {
                        ProfilerDialogs.displayError((String)Bundle.HeapDumpAction_WrongDestinationMsg());
                        return;
                    }
                    boolean heapdumpTaken = false;
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandle.createHandle((String)Bundle.HeapDumpAction_DumpingHeapText());
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        heapdumpTaken = targetApp.getProfilerClient().takeHeapDump(dumpFileName);
                    }
                    finally {
                        if (pHandle != null) {
                            pHandle.finish();
                        }
                    }
                    if (heapdumpTaken) {
                        File file = new File(dumpFileName);
                        FileObject folder = FileUtil.toFileObject((File)file.getParentFile());
                        SnapshotsWindow.instance().refreshFolder(folder, true);
                        if (askForDestination) {
                            if (ProfilerDialogs.displayConfirmationDNSA((String)Bundle.HeapDumpAction_SavedDialogText(), (String)Bundle.HeapDumpAction_SavedDialogCaption(), null, (String)"HeapDumpAction.heapdumpSaved", (boolean)false)) {
                                ResultsManager.getDefault().openSnapshot(file);
                            }
                        } else if (ProfilerIDESettings.getInstance().getAutoOpenSnapshot()) {
                            ResultsManager.getDefault().openSnapshot(file);
                        }
                    } else {
                        ProfilerDialogs.displayError((String)Bundle.HeapDumpAction_DumpingFailedMsg());
                    }
                }
                catch (Exception e) {
                    ProfilerDialogs.displayError((String)e.getMessage());
                    ProfilerLogger.log((Exception)e);
                }
            }
        });
    }

    private static class ChooseHeapdumpTargetPanel
    extends JPanel
    implements HelpCtx.Provider {
        private static final String HELP_CTX_KEY = "ChooseHeapdumpTargetPanel.HelpCtx";
        private static final HelpCtx HELP_CTX = new HelpCtx("ChooseHeapdumpTargetPanel.HelpCtx");
        public static final int DESTINATION_DEFAULT = 0;
        public static final int DESTINATION_CUSTOM = 1;
        private JButton customLocationButton;
        private JButton okButton;
        private JLabel chooseDestinationLabel;
        private JRadioButton customLocationRadio;
        private JRadioButton defaultLocationRadio;
        private JTextField customLocationField;

        ChooseHeapdumpTargetPanel() {
            this.initComponents();
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        public String getCustomDirectory() {
            return this.customLocationField.getText();
        }

        public void setCustomDirectory(String directory) {
            this.customLocationField.setText(directory);
        }

        public int getDestinationType() {
            if (this.defaultLocationRadio.isSelected()) {
                return 0;
            }
            return 1;
        }

        public void setDestinationType(int type) {
            this.defaultLocationRadio.setSelected(type == 0);
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public void updateDefaultLocation(String location) {
            this.defaultLocationRadio.setText(location);
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.HeapDumpAction_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            this.chooseDestinationLabel = new JLabel(Bundle.HeapDumpAction_DestinationLabelText());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 10, 8, 5);
            this.add((Component)this.chooseDestinationLabel, c);
            this.defaultLocationRadio = new JRadioButton(Bundle.HeapDumpAction_DefaultLocationRadioText());
            group.add(this.defaultLocationRadio);
            this.defaultLocationRadio.setSelected(true);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.defaultLocationRadio, c);
            this.customLocationRadio = new JRadioButton(Bundle.HeapDumpAction_CustomLocationRadioText());
            group.add(this.customLocationRadio);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 5);
            this.add((Component)this.customLocationRadio, c);
            String tempDir = System.getProperty("java.io.tmpdir");
            if (tempDir.endsWith(File.separator)) {
                tempDir = tempDir.substring(0, tempDir.length() - File.separator.length());
            }
            this.customLocationField = new JTextField();
            this.customLocationField.setText(tempDir);
            this.customLocationField.setPreferredSize(new Dimension(210, this.customLocationField.getPreferredSize().height));
            this.customLocationField.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.customLocationField, c);
            this.customLocationButton = new JButton(Bundle.HeapDumpAction_BrowseButtonText());
            this.customLocationButton.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 3;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.customLocationButton, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 0;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), c);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateOKButton();
                }
            };
            this.customLocationField.getDocument().addDocumentListener(documentListener);
            this.defaultLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    this.updateOKButton();
                }
            });
            this.customLocationRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    customLocationField.setEnabled(customLocationRadio.isSelected());
                    customLocationButton.setEnabled(customLocationRadio.isSelected());
                    this.updateOKButton();
                }
            });
            this.customLocationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser directoryChooser = HeapDumpAction.getSnapshotDirectoryChooser();
                    directoryChooser.setCurrentDirectory(new File(this.getCustomDirectory()));
                    if (directoryChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = directoryChooser.getSelectedFile()) != null) {
                        customLocationField.setText(directoryChooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.defaultLocationRadio.isSelected()) {
                this.okButton.setEnabled(true);
            } else if (this.customLocationRadio.isSelected()) {
                File file = new File(this.getCustomDirectory());
                this.okButton.setEnabled(file.exists() && file.isDirectory());
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private static final class Singleton {
        private static final HeapDumpAction INSTANCE = new HeapDumpAction();

        private Singleton() {
        }
    }
}

