/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.file.PathUtils;

public final class DiskFileItemFactory
implements FileItemFactory<DiskFileItem> {
    public static final int DEFAULT_THRESHOLD = 10240;
    private final Path repository;
    private final int threshold;
    private final FileCleaningTracker fileCleaningTracker;
    private final Charset charsetDefault;

    public static Builder builder() {
        return new Builder();
    }

    private DiskFileItemFactory(Path repository, int threshold, Charset charsetDefault, FileCleaningTracker fileCleaningTracker) {
        this.threshold = threshold;
        this.repository = repository;
        this.charsetDefault = charsetDefault;
        this.fileCleaningTracker = fileCleaningTracker;
    }

    public DiskFileItem.Builder fileItemBuilder() {
        return (DiskFileItem.Builder)((DiskFileItem.Builder)((DiskFileItem.Builder)((DiskFileItem.Builder)DiskFileItem.builder().setBufferSize(this.threshold)).setCharset(this.charsetDefault)).setFileCleaningTracker(this.fileCleaningTracker)).setPath(this.repository);
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    public Path getRepository() {
        return this.repository;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public static class Builder
    extends AbstractStreamBuilder<DiskFileItemFactory, Builder> {
        private FileCleaningTracker fileCleaningTracker;

        public Builder() {
            this.setBufferSize(10240);
            this.setPath(PathUtils.getTempDirectory());
            this.setCharset(DiskFileItem.DEFAULT_CHARSET);
            this.setCharsetDefault(DiskFileItem.DEFAULT_CHARSET);
        }

        @Override
        public DiskFileItemFactory get() {
            return new DiskFileItemFactory(this.getPath(), this.getBufferSize(), this.getCharset(), this.fileCleaningTracker);
        }

        public Builder setFileCleaningTracker(FileCleaningTracker fileCleaningTracker) {
            this.fileCleaningTracker = fileCleaningTracker;
            return this;
        }
    }
}

