/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output.lf5;

import java.util.Arrays;
import java.util.List;
import org.apache.log.ContextMap;
import org.apache.log.LogEvent;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.util.StackIntrospector;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;

public class LogKitLogRecord
extends LogRecord {
    private boolean m_severe;
    public static final List LOGKIT_LOGLEVELS = Arrays.asList(LogLevel.FATAL, LogLevel.ERROR, LogLevel.WARN, LogLevel.INFO, LogLevel.DEBUG);
    static /* synthetic */ Class class$org$apache$log$Logger;

    public LogKitLogRecord(LogEvent event, Formatter fmt) {
        Object contextObject;
        ContextMap contextMap = event.getContextMap();
        this.setCategory(event.getCategory());
        this.setLevel(this.toLogLevel(event.getPriority()));
        this.m_severe = event.getPriority().isGreater(Priority.INFO);
        if (null != contextMap && null != (contextObject = contextMap.get("method"))) {
            this.setLocation(contextObject.toString());
        } else {
            this.setLocation(StackIntrospector.getCallerMethod(class$org$apache$log$Logger == null ? (class$org$apache$log$Logger = LogKitLogRecord.class$("org.apache.log.Logger")) : class$org$apache$log$Logger));
        }
        this.setMessage(event.getMessage());
        this.setMillis(event.getTime());
        this.setNDC(fmt.format(event));
        if (null != contextMap && null != (contextObject = contextMap.get("thread"))) {
            this.setThreadDescription(contextObject.toString());
        } else {
            this.setThreadDescription(Thread.currentThread().getName());
        }
        this.setThrown(event.getThrowable());
    }

    public boolean isSevereLevel() {
        return this.m_severe;
    }

    public LogLevel toLogLevel(Priority priority) {
        if (Priority.DEBUG == priority) {
            return LogLevel.DEBUG;
        }
        if (Priority.INFO == priority) {
            return LogLevel.INFO;
        }
        if (Priority.WARN == priority) {
            return LogLevel.WARN;
        }
        if (Priority.ERROR == priority) {
            return LogLevel.ERROR;
        }
        if (Priority.FATAL_ERROR == priority) {
            return LogLevel.FATAL;
        }
        return new LogLevel(priority.getName(), priority.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

