/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class CompositeFigure
extends AbstractFigure
implements FigureChangeListener {
    protected Vector fFigures = new Vector();
    private static final long serialVersionUID = 7408153435700021866L;
    private int compositeFigureSerializedDataVersion = 1;

    protected CompositeFigure() {
    }

    public Figure add(Figure figure) {
        if (!this.fFigures.contains(figure)) {
            this.fFigures.addElement(figure);
            figure.addToContainer(this);
        }
        return figure;
    }

    public void addAll(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.add((Figure)enumeration.nextElement());
        }
    }

    public Figure remove(Figure figure) {
        if (this.fFigures.contains(figure)) {
            figure.removeFromContainer(this);
            this.fFigures.removeElement(figure);
        }
        return figure;
    }

    public void removeAll(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.remove((Figure)enumeration.nextElement());
        }
    }

    public void removeAll() {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.removeFromContainer(this);
        }
        this.fFigures.removeAllElements();
    }

    public synchronized Figure orphan(Figure figure) {
        this.fFigures.removeElement(figure);
        return figure;
    }

    public void orphanAll(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.orphan((Figure)enumeration.nextElement());
        }
    }

    public synchronized void replace(Figure figure, Figure figure2) {
        int n = this.fFigures.indexOf(figure);
        if (n != -1) {
            figure2.addToContainer(this);
            figure.changed();
            this.fFigures.setElementAt(figure2, n);
        }
    }

    public synchronized void sendToBack(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.insertElementAt(figure, 0);
            figure.changed();
        }
    }

    public synchronized void bringToFront(Figure figure) {
        if (this.fFigures.contains(figure)) {
            this.fFigures.removeElement(figure);
            this.fFigures.addElement(figure);
            figure.changed();
        }
    }

    public void draw(Graphics graphics, boolean bl) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            figureEnumeration.nextFigure().draw(graphics, bl);
        }
    }

    public Figure figureAt(int n) {
        return (Figure)this.fFigures.elementAt(n);
    }

    public final FigureEnumeration figures() {
        return new FigureEnumerator(this.fFigures);
    }

    public int figureCount() {
        return this.fFigures.size();
    }

    public final FigureEnumeration figuresReverse() {
        return new ReverseFigureEnumerator(this.fFigures);
    }

    public Figure findFigure(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!figure.containsPoint(n, n2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure.displayBox();
            if (!rectangle.intersects(rectangle2)) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureWithout(int n, int n2, Figure figure) {
        if (figure == null) {
            return this.findFigure(n, n2);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.containsPoint(n, n2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    public Figure findFigure(Rectangle rectangle, Figure figure) {
        if (figure == null) {
            return this.findFigure(rectangle);
        }
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            Rectangle rectangle2 = figure2.displayBox();
            if (!rectangle.intersects(rectangle2) || figure2.includes(figure)) continue;
            return figure2;
        }
        return null;
    }

    public Figure findFigureInside(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure().findFigureInside(n, n2);
            if (figure == null) continue;
            return figure;
        }
        return null;
    }

    public Figure findFigureInsideWithout(int n, int n2, Figure figure) {
        FigureEnumeration figureEnumeration = this.figuresReverse();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2;
            Figure figure3 = figureEnumeration.nextFigure();
            if (figure3 == figure || (figure2 = figure3.findFigureInside(n, n2)) == null) continue;
            return figure2;
        }
        return null;
    }

    public boolean includes(Figure figure) {
        if (super.includes(figure)) {
            return true;
        }
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure2 = figureEnumeration.nextFigure();
            if (!figure2.includes(figure)) continue;
            return true;
        }
        return false;
    }

    protected void basicMoveBy(int n, int n2) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            Figure figure2 = (Figure)figure.getAttribute("observed.figure");
            if (figure2 != null && this.includes(figure2)) continue;
            figure.moveBy(n, n2);
        }
    }

    public void release() {
        super.release();
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.release();
        }
    }

    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureInvalidated(figureChangeEvent);
        }
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestRemove(new FigureChangeEvent(this));
        }
    }

    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.listener() != null) {
            this.listener().figureRequestUpdate(figureChangeEvent);
        }
    }

    public void figureChanged(FigureChangeEvent figureChangeEvent) {
    }

    public void figureRemoved(FigureChangeEvent figureChangeEvent) {
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fFigures.size());
        Enumeration enumeration = this.fFigures.elements();
        while (enumeration.hasMoreElements()) {
            storableOutput.writeStorable((Storable)enumeration.nextElement());
        }
    }

    public String getMap() {
        String string = "";
        Enumeration enumeration = this.fFigures.elements();
        while (enumeration.hasMoreElements()) {
            string = ((Storable)enumeration.nextElement()).getMap() + string;
        }
        return string;
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        this.fFigures = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.add((Figure)storableInput.readStorable());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            figure.addToContainer(this);
        }
    }
}

