<?php

if ($device['os'] === 'terra') {
    $query = [
        ['sti410C', '.1.3.6.1.4.1.30631.1.9.1.1.4.0'],
        ['sti440',  '.1.3.6.1.4.1.30631.1.18.1.326.4.0'],
    ];

    foreach ($query as $row) {
        if (str_contains((string) $device['sysDescr'], $row[0])) {
            $temperature = snmp_get($device, $row[1], '-Oqv');
            if (is_numeric($temperature)) {
                discover_sensor(null, 'temperature', $device, $row[1], '0', $row[0], 'Internal Temperature', 1, 1, null, null, null, null, $temperature);
            }
        }
    }

    unset($query);
}
