/*
 * SPDX-License-Identifier: MPL-2.0
 * SPDX-FileCopyrightText: Copyright 2025 Siemens
 */

import { ssoLog } from "./utils.js";

export class Platform {
    static SSO_URL = "https://login.microsoftonline.com";

    browser;

    host_versions = {
        native: null,
        broker: null,
    };

    /* references needed for PRT injection */
    account = null;
    well_known_app_filters = [];
    sso_url_permitted = true;

    constructor() {
        /*
         * The WebRequest API operates on allowed URLs only.
         * To intercept a sub-resource request (e.g. from an iframe), the extension
         * must have access to both the requested URL and its initiator.
         */
        this.well_known_app_filters = [Platform.SSO_URL + "/*"];
    }

    /**
     * Load platform information from backend.
     */
    async setup(broker) {
        try {
            this.host_versions = await broker.getVersion();
        } catch (error) {
            ssoLog(error);
        }
    }

    setIconDisabled() {
        chrome.action.setIcon({
            path: {
                48: "/icons/linux-entra-sso_48.png",
                128: "/icons/linux-entra-sso_128.png",
            },
        });
    }

    /**
     * Can be overwritten to shorten the title on platforms that print the
     * title next to the icon (instead of in a tooltip).
     */
    transform_ui_title(title) {
        return title;
    }

    getSsoUrl() {
        return Platform.SSO_URL;
    }

    update_request_handlers(enabled, account, broker) {
        this.account = account;
    }

    async update_host_permissions() {
        const currentPermissions = await chrome.permissions.getAll();
        this.well_known_app_filters = currentPermissions.origins;

        // check if we have access to the SSO url
        const permissionsToCheck = {
            origins: [Platform.SSO_URL + "/*"],
        };
        const result = await chrome.permissions.contains(permissionsToCheck);
        this.sso_url_permitted = result;
    }
}
