#!/usr/bin/python3

# SPDX-FileCopyrightText: 2020-2023 Osimis S.A., 2024-2025 Orthanc Team SRL, 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain
# SPDX-License-Identifier: AGPL-3.0-or-later

##
## Python plugin for Orthanc
## Copyright (C) 2020-2023 Osimis S.A., Belgium
## Copyright (C) 2024-2025 Orthanc Team SRL, Belgium
## Copyright (C) 2021-2025 Sebastien Jodogne, ICTEAM UCLouvain, Belgium
##
## This program is free software: you can redistribute it and/or
## modify it under the terms of the GNU Affero General Public License
## as published by the Free Software Foundation, either version 3 of
## the License, or (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## Affero General Public License for more details.
##
## You should have received a copy of the GNU Affero General Public License
## along with this program. If not, see <http://www.gnu.org/licenses/>.
##


#
# This maintenance script updates the content of the "Orthanc" folder
# to match the latest version of the Orthanc source code.
#

import multiprocessing
import os
import re
import stat
import subprocess
import urllib.request

TARGET = os.path.join(os.path.dirname(__file__), 'Orthanc')
REPOSITORY = 'https://orthanc.uclouvain.be/hg/orthanc/raw-file'
PLUGIN_SDK_VERSIONS = [ '1.7.2', '1.10.0', '1.12.6', '1.12.9' ]


FILES = [
    ('OrthancFramework/Resources/CMake/AutoGeneratedCode.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/Compiler.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadOrthancFramework.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/DownloadPackage.cmake', 'CMake'),
    ('OrthancFramework/Resources/CMake/GoogleTestConfiguration.cmake', 'CMake'),
    ('OrthancFramework/Resources/EmbedResources.py', 'CMake'),
    ('OrthancFramework/Resources/Toolchains/LinuxStandardBaseToolchain.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain32.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain64.cmake', 'Toolchains'),
    ('OrthancFramework/Resources/Toolchains/MinGWToolchain.cmake', 'Toolchains'),
    ('OrthancServer/Plugins/Include/orthanc/OrthancPluginCodeModel.json', '.'),
    ('OrthancServer/Plugins/Samples/Common/ExportedSymbolsPlugins.list', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.cpp', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginException.h', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/OrthancPluginsExports.cmake', 'Plugins'),
    ('OrthancServer/Plugins/Samples/Common/VersionScriptPlugins.map', 'Plugins'),
]

SDK = [
    'orthanc/OrthancCPlugin.h',
]


def Download(x):
    branch = x[0]
    source = x[1]
    target = os.path.join(TARGET, x[2])
    print(target)

    try:
        os.makedirs(os.path.dirname(target))
    except:
        pass

    url = '%s/%s/%s' % (REPOSITORY, branch, source)

    with open(target, 'wb') as f:
        try:
            f.write(urllib.request.urlopen(url).read())
        except:
            print('ERROR %s' % url)
            raise


commands = []

for f in FILES:
    commands.append([
        'default',
        f[0],
        os.path.join(f[1], os.path.basename(f[0]))
    ])

for f in SDK:
    for version in PLUGIN_SDK_VERSIONS:
        commands.append([
            'Orthanc-%s' % version,
            'OrthancServer/Plugins/Include/%s' % f,
            'Sdk-%s/%s' % (version, f)
        ])


pool = multiprocessing.Pool(10)  # simultaneous downloads
pool.map(Download, commands)
