# -*- python -*-
# -*- coding: utf-8 -*-
#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2011-2016       Serge Noiraud
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, see <https://www.gnu.org/licenses/>.
#

# -------------------------------------------------------------------------
#
# Python modules
#
# -------------------------------------------------------------------------
import logging

# -------------------------------------------------------------------------
#
# Gramps Modules
#
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
#
# osmGpsMap
#
# -------------------------------------------------------------------------
from gi.repository import GObject

try:
    import gi

    gi.require_version("OsmGpsMap", "1.0")
    from gi.repository import OsmGpsMap as osmgpsmap
except:
    raise

# ------------------------------------------------------------------------
#
# Set up logging
#
# ------------------------------------------------------------------------
_LOG = logging.getLogger("maps.dummylayer")


class DummyLayer(GObject.GObject, osmgpsmap.MapLayer):
    """
    This is the class for the Dummy layer.
    """

    def __init__(self):
        """
        Initialize the dummy layer
        """
        GObject.GObject.__init__(self)

    def do_draw(self, gpsmap, gdkdrawable):
        """
        Draw the layer
        """
        pass

    def do_render(self, gpsmap):
        """
        Render the layer
        """
        pass

    def do_busy(self):
        """
        The layer is busy
        """
        return False

    def do_button_press(self, gpsmap, gdkeventbutton):
        """
        Someone press a button
        """
        dummy_map = gpsmap
        dummy_evt = gdkeventbutton
        return False


GObject.type_register(DummyLayer)
