// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::ffi;
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "GDesktopAppInfo")]
    pub struct DesktopAppInfo(Object<ffi::GDesktopAppInfo, ffi::GDesktopAppInfoClass>) @implements gio::AppInfo;

    match fn {
        type_ => || ffi::g_desktop_app_info_get_type(),
    }
}

impl DesktopAppInfo {
    #[doc(alias = "g_desktop_app_info_new")]
    pub fn new(desktop_id: &str) -> Option<DesktopAppInfo> {
        unsafe { from_glib_full(ffi::g_desktop_app_info_new(desktop_id.to_glib_none().0)) }
    }

    #[doc(alias = "g_desktop_app_info_new_from_filename")]
    #[doc(alias = "new_from_filename")]
    pub fn from_filename(filename: impl AsRef<std::path::Path>) -> Option<DesktopAppInfo> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_new_from_filename(
                filename.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_new_from_keyfile")]
    #[doc(alias = "new_from_keyfile")]
    pub fn from_keyfile(key_file: &glib::KeyFile) -> Option<DesktopAppInfo> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_new_from_keyfile(
                key_file.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_action_name")]
    #[doc(alias = "get_action_name")]
    pub fn action_name(&self, action_name: &str) -> glib::GString {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_action_name(
                self.to_glib_none().0,
                action_name.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_boolean")]
    #[doc(alias = "get_boolean")]
    pub fn boolean(&self, key: &str) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_boolean(
                self.to_glib_none().0,
                key.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_categories")]
    #[doc(alias = "get_categories")]
    pub fn categories(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_categories(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_filename")]
    #[doc(alias = "get_filename")]
    pub fn filename(&self) -> Option<std::path::PathBuf> {
        unsafe { from_glib_none(ffi::g_desktop_app_info_get_filename(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_desktop_app_info_get_generic_name")]
    #[doc(alias = "get_generic_name")]
    pub fn generic_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_generic_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_is_hidden")]
    #[doc(alias = "get_is_hidden")]
    pub fn is_hidden(&self) -> bool {
        unsafe { from_glib(ffi::g_desktop_app_info_get_is_hidden(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_desktop_app_info_get_keywords")]
    #[doc(alias = "get_keywords")]
    pub fn keywords(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_desktop_app_info_get_keywords(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_locale_string")]
    #[doc(alias = "get_locale_string")]
    pub fn locale_string(&self, key: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_locale_string(
                self.to_glib_none().0,
                key.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_nodisplay")]
    #[doc(alias = "get_nodisplay")]
    pub fn is_nodisplay(&self) -> bool {
        unsafe { from_glib(ffi::g_desktop_app_info_get_nodisplay(self.to_glib_none().0)) }
    }

    #[doc(alias = "g_desktop_app_info_get_show_in")]
    #[doc(alias = "get_show_in")]
    pub fn shows_in(&self, desktop_env: Option<&str>) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_get_show_in(
                self.to_glib_none().0,
                desktop_env.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_startup_wm_class")]
    #[doc(alias = "get_startup_wm_class")]
    pub fn startup_wm_class(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::g_desktop_app_info_get_startup_wm_class(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_string")]
    #[doc(alias = "get_string")]
    pub fn string(&self, key: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::g_desktop_app_info_get_string(
                self.to_glib_none().0,
                key.to_glib_none().0,
            ))
        }
    }

    #[cfg(feature = "v2_60")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v2_60")))]
    #[doc(alias = "g_desktop_app_info_get_string_list")]
    #[doc(alias = "get_string_list")]
    pub fn string_list(&self, key: &str) -> Vec<glib::GString> {
        unsafe {
            let mut length = std::mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_full_num(
                ffi::g_desktop_app_info_get_string_list(
                    self.to_glib_none().0,
                    key.to_glib_none().0,
                    length.as_mut_ptr(),
                ),
                length.assume_init() as _,
            );
            ret
        }
    }

    #[doc(alias = "g_desktop_app_info_has_key")]
    pub fn has_key(&self, key: &str) -> bool {
        unsafe {
            from_glib(ffi::g_desktop_app_info_has_key(
                self.to_glib_none().0,
                key.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_launch_action")]
    pub fn launch_action(
        &self,
        action_name: &str,
        launch_context: Option<&impl IsA<gio::AppLaunchContext>>,
    ) {
        unsafe {
            ffi::g_desktop_app_info_launch_action(
                self.to_glib_none().0,
                action_name.to_glib_none().0,
                launch_context.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    //#[doc(alias = "g_desktop_app_info_launch_uris_as_manager")]
    //pub fn launch_uris_as_manager(&self, uris: &[&str], launch_context: Option<&impl IsA<gio::AppLaunchContext>>, spawn_flags: glib::SpawnFlags, user_setup: Option<Box_<dyn FnOnce() + 'static>>, pid_callback: /*Unimplemented*/FnMut(&DesktopAppInfo, /*Ignored*/glib::Pid), pid_callback_data: /*Unimplemented*/Option<Basic: Pointer>) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:g_desktop_app_info_launch_uris_as_manager() }
    //}

    #[doc(alias = "g_desktop_app_info_list_actions")]
    pub fn list_actions(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::g_desktop_app_info_list_actions(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_desktop_app_info_get_implementations")]
    #[doc(alias = "get_implementations")]
    pub fn implementations(interface: &str) -> Vec<DesktopAppInfo> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::g_desktop_app_info_get_implementations(
                interface.to_glib_none().0,
            ))
        }
    }
}
