#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Superliminal
# send your bug reports to contact@dotslashplay.it
###

script_version=20240930.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='superliminal'
GAME_NAME='Superliminal'

ARCHIVE_BASE_1_NAME='superliminal_1_3_53848.sh'
ARCHIVE_BASE_1_MD5='b22c23f799a18f97f4dad185d713a556'
ARCHIVE_BASE_1_SIZE='16000000'
## Yes, previous version of the game was 1.15. And the current one is 1.3.
## You can blame Pillow Castle developers for not being able to count up to 20.
ARCHIVE_BASE_1_VERSION='1.3-gog53848'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/superliminal'

ARCHIVE_BASE_0_NAME='superliminal_1_15_46618.sh'
ARCHIVE_BASE_0_MD5='e2a90cc5c087b5e2e779e07f7524f089'
ARCHIVE_BASE_0_SIZE='12000000'
ARCHIVE_BASE_0_VERSION='1.15-gog46618'

UNITY3D_NAME='SuperliminalGOG'
UNITY3D_PLUGINS='
libfmodsuper.so
libgvraudio.so
libopenvr_api.so
libresonanceaudio.so
libStandaloneFileBrowser.so
libvhacd.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_DATA_ASSETS_1_FILES="
${UNITY3D_NAME}_Data/sharedassets0.*
${UNITY3D_NAME}_Data/sharedassets1.*
${UNITY3D_NAME}_Data/sharedassets2.*
${UNITY3D_NAME}_Data/sharedassets3.*
${UNITY3D_NAME}_Data/sharedassets4.*
${UNITY3D_NAME}_Data/sharedassets5.*"
CONTENT_GAME_DATA_ASSETS_2_FILES="
${UNITY3D_NAME}_Data/sharedassets*"

## The game crashes on launch when the Wayland backend of SDL is used,
## even when forcing the use of system SDL.
APP_MAIN_PRERUN='
# The game crashes on launch when the Wayland backend of SDL is used
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_ASSETS_1
PKG_DATA_ASSETS_2
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-3.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
PKG_DATA_DEPENDENCIES_SIBLINGS='
PKG_DATA_ASSETS_1
PKG_DATA_ASSETS_2'

PKG_DATA_ASSETS_ID="${PKG_DATA_ID}-assets"
PKG_DATA_ASSETS_1_ID="${PKG_DATA_ASSETS_ID}-1"
PKG_DATA_ASSETS_2_ID="${PKG_DATA_ASSETS_ID}-2"
PKG_DATA_ASSETS_DESCRIPTION="$PKG_DATA_DESCRIPTION - assets"
PKG_DATA_ASSETS_1_DESCRIPTION="$PKG_DATA_ASSETS_DESCRIPTION - 1"
PKG_DATA_ASSETS_2_DESCRIPTION="$PKG_DATA_ASSETS_DESCRIPTION - 2"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Work around Unity3D regressions
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Work around Unity3D regressions, comments are from the original game launcher

## Another Unity regression! WHO WOULD HAVE THOUGHT
: "${SDL_MOUSE_RELATIVE_SPEED_SCALE:=4.0f}"
export SDL_MOUSE_RELATIVE_SPEED_SCALE

## Unity _seriously_ dropped the ball here.
## 2019.3 adds -rdynamic which means all Linux games will fail to load FMOD
## properly, and while FMOD can be compiled monolithically we still run into
## symbol override issues. Why Unity didnʼt say anything about possibly the
## worldʼs most popular middleware I have absolutely no clue.
##
## So, we do both the monolithic build (thanks FMOD support!) and the preload, to
## ensure that our stupid hack is "safe". Unityʼs Linux team is fired. -flibit
export LD_PRELOAD="${LD_PRELOAD:-}:'"$(path_libraries)"'/libfmodsuper.so"
'

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
