#!/usr/bin/perl
# Read original include file, and generate function calls

# FIXME: replace gl*() by nfgl*()

$file = @ARGV[0];

if ( ! defined(open(FILE, $file)) ) {
	warn "Couldn't open $file: $!\n";
	exit;
}

print "/* Generated by proto-gen.pl from $file */\n\n";

$linecount=0;
while ($ligne = <FILE>) {
	if ($ligne =~ /^GLAPI/ ) {
		while (! ($ligne =~ /\);/)) {
			chomp($ligne);
			$ligne .= " " . <FILE>;
		}
		$ligne =~ s/\t//g;
		$ligne =~ s/\n//g;
		$ligne =~ s/ +/ /g;

#		print "/* $ligne */\n";

		if ($ligne =~ /^GLAPI *(\w+).* (GL)*APIENTRY *(\w+) *\(.*/) {
			$return_type = $1 ;
			$function_name = $3 ;
		} else {
			$return_type = "" ;
			$function_name = "" ;
		}

		$ligne =~ s/GLAPI//;
		$ligne =~ s/(GL)*APIENTRY//;
		$ligne =~ s/ +/ /;

		# Add missing parameters (for glext.h)
		$lettre = 'a';
		while ($ligne =~ /[,\( ] *GL\w+\** *\**,/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *\**),/$1 $lettre,/;
			$lettre++;
		}
		while ($ligne =~ /[,\( ] *GL\w+\** *\**\)/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *\**)\)/$1 $lettre\)/;
			$lettre++;
		}
		while ($ligne =~ /[,\( ] *GL\w+\** *const *\*,/ ) {
			$ligne =~ s/([,\( ] *GL\w+\** *const *\*),/$1 $lettre,/;
			$lettre++;
		}

		print "\t$ligne\n";

		$linecount++;
	}
}
close(FILE);
print "/* Functions generated: $linecount */\n";
