#!/usr/bin/perl
# Read pointers*.h to generate unload*.h

$file = @ARGV[0];

if ( ! defined(open(FILE, $file)) ) {
	warn "Couldn't open $file: $!\n";
	exit;
}

print "/* Generated by unload-gen.pl from $file */\n\n";

$linecount=0;
while ($ligne = <FILE>) {
	# Ignore commented commands
	if ($ligne =~ m=.*/\*.*=) {
		while ($ligne !~ m=.*\*/.*=) {
			$ligne = <FILE>;
		}
		$ligne = <FILE>;
	}

	if ($ligne =~ /\)\;$/ ) {
		# Remove start tabulation and return type
		$ligne =~ s/\t//;
		$ligne =~ s/\n//;
		$ligne =~ s/\;//;
		# Read function name
		$function_name = $ligne;
		$function_name =~ s/.*(gl\w+).*/$1/;
		$function_type = $ligne;
		$function_type =~ s/$function_name//;

		print "\tfn.$function_name =\n";
		print "\t\t($function_type)\n";
		print "\t\tNULL;\n";
		$linecount++;
	}
}
close(FILE);
print "/* Functions generated : $linecount */\n";
