subroutine zbinte(rho, rhomin, rhomax, rhoexm, rhoexp)
!
! ======================================================================
! COPYRIGHT (C) 1991 - 2009  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!   1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: mickael.abbas at edf.fr
!
    implicit none
    real(kind=8) :: rho
    real(kind=8) :: rhomin, rhomax, rhoexm, rhoexp
!
! ----------------------------------------------------------------------
!
! ROUTINE MECA_NON_LINE (RECH. LINE. - UTILITAIRE)
!
! GESTION DES BORNES POUR LE RHO
!
! ----------------------------------------------------------------------
!
! I/O RHO    : RHO AVEC RESPECT DES BORNES
! IN  RHOMIN : BORNE INFERIEURE DE RECHERCHE
! IN  RHOMAX : BORNE SUPERIEURE DE RECHERCHE
! IN  RHOEXM : INTERVALLE [RHOEXM,RHOEXP] POUR EXCLUSION
! IN  RHOEXP : INTERVALLE [RHOEXM,RHOEXP] POUR EXCLUSION
!
! ----------------------------------------------------------------------
!
    real(kind=8) :: rhotmp
!
!-----------------------------------------------------------------------
!
    rhotmp = rho
    if (rhotmp .lt. rhomin) rho = rhomin
    if (rhotmp .gt. rhomax) rho = rhomax
    if (rhotmp .lt. 0.d0 .and. rhotmp .ge. rhoexm) rho = rhoexm
    if (rhotmp .ge. 0.d0 .and. rhotmp .le. rhoexp) rho = rhoexp
!
end subroutine
