/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
 *  \file evaluationmanager.h
 *
 *  \brief Evaluation Manager interface definition.
 *
 *  The function listed in here are accessible to anyone. This is the
 *  way to communicate with the evaluation manager. The evaluation
 *  manager deligates the becessary work to the Policy Language
 *  Description module (PDL).
 *
 *
 *  \author  G.M. Venekamp  (venekamp@nikhef.nl)
 *  \version $Revision: 14868 $
 *  \date    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
 *
 */


#ifndef _EVALUATIONMANAGER_H
#define _EVALUATIONMANAGER_H

#include "lcmaps_db_read.h"
#include "pdl.h"
#include "pdl_policy.h"

extern int lcmaps_startEvaluationManager(const char* name, int argc, char*argv[]);
extern int lcmaps_getPluginNameAndArgs(lcmaps_db_entry_t** plugin);
extern int lcmaps_runEvaluationManager(int argc, char *argv[]);
extern int lcmaps_stopEvaluationManager(void);

#endif
