! Molecular Orbital PACkage (MOPAC)
! Copyright (C) 2021, Virginia Polytechnic Institute and State University
!
! MOPAC is free software: you can redistribute it and/or modify it under
! the terms of the GNU Lesser General Public License as published by
! the Free Software Foundation, either version 3 of the License, or
! (at your option) any later version.
!
! MOPAC is distributed in the hope that it will be useful,
! but WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! GNU Lesser General Public License for more details.
!
! You should have received a copy of the GNU Lesser General Public License
! along with this program.  If not, see <https://www.gnu.org/licenses/>.

  subroutine alpb_and_xfac_mndo
    use parameters_C, only : xfac, alpb
    xfac = 0.d0
    alpb = 0.d0
    alpb( 3, 1) =   1.574938d0 !     Lithium -     Hydrogen
    xfac( 3, 1) =   1.267656d0 !     Lithium -     Hydrogen
    alpb( 3, 3) =   1.116981d0 !     Lithium -      Lithium
    xfac( 3, 3) =   1.867382d0 !     Lithium -      Lithium
    !
    alpb( 6, 3) =   1.331736d0 !      Carbon -      Lithium
    xfac( 6, 3) =   0.924766d0 !      Carbon -      Lithium
    !
    alpb( 7, 3) =   1.539010d0 !    Nitrogen -      Lithium
    xfac( 7, 3) =   0.917994d0 !    Nitrogen -      Lithium
    !
    alpb( 8, 3) =   1.246611d0 !      Oxygen -      Lithium
    xfac( 8, 3) =   0.532906d0 !      Oxygen -      Lithium
    !
    alpb( 9, 3) =   1.100244d0 !    Fluorine -      Lithium
    xfac( 9, 3) =   0.439938d0 !    Fluorine -      Lithium
    !
    alpb(11, 1) =   2.509533d0 !      Sodium -     Hydrogen
    xfac(11, 1) =  10.000001d0 !      Sodium -     Hydrogen
    alpb(11, 6) =   1.600907d0 !      Sodium -       Carbon
    xfac(11, 6) =   1.968197d0 !      Sodium -       Carbon
    alpb(11, 7) =   2.137374d0 !      Sodium -     Nitrogen
    xfac(11, 7) =   7.127566d0 !      Sodium -     Nitrogen
    alpb(11, 8) =   1.645246d0 !      Sodium -       Oxygen
    xfac(11, 8) =   1.815137d0 !      Sodium -       Oxygen
    alpb(11, 9) =   1.454308d0 !      Sodium -     Fluorine
    xfac(11, 9) =   1.176276d0 !      Sodium -     Fluorine
    alpb(11,11) =   1.237658d0 !      Sodium -       Sodium
    xfac(11,11) =   4.403848d0 !      Sodium -       Sodium
    !
    alpb(12, 1) =   2.225309d0 !   Magnesium -     Hydrogen
    xfac(12, 1) =   3.720059d0 !   Magnesium -     Hydrogen
    alpb(12, 6) =   2.261280d0 !   Magnesium -       Carbon
    xfac(12, 6) =   4.077811d0 !   Magnesium -       Carbon
    alpb(12, 7) =   2.235036d0 !   Magnesium -     Nitrogen
    xfac(12, 7) =   2.449707d0 !   Magnesium -     Nitrogen
    alpb(12, 8) =   1.861494d0 !   Magnesium -       Oxygen
    xfac(12, 8) =   1.028465d0 !   Magnesium -       Oxygen
    alpb(12, 9) =   2.020390d0 !   Magnesium -     Fluorine
    xfac(12, 9) =   1.351638d0 !   Magnesium -     Fluorine
    alpb(12,12) =   1.836049d0 !   Magnesium -    Magnesium
    xfac(12,12) =  10.000011d0 !   Magnesium -    Magnesium
    !
    alpb(16, 3) =   3.607514d0 !      Sulfur -      Lithium
    xfac(16, 3) =   1.246952d0 !      Sulfur -      Lithium
    alpb(16,11) =   3.292794d0 !      Sulfur -       Sodium
    xfac(16,11) =   2.813852d0 !      Sulfur -       Sodium
    alpb(16,12) =   2.042320d0 !      Sulfur -    Magnesium
    xfac(16,12) =   2.144097d0 !      Sulfur -    Magnesium
    !
    alpb(17, 3) =   1.697747d0 !    Chlorine -      Lithium
    xfac(17, 3) =   1.268099d0 !    Chlorine -      Lithium
    alpb(17,11) =   1.808032d0 !    Chlorine -       Sodium
    xfac(17,11) =   2.574233d0 !    Chlorine -       Sodium
    alpb(17,12) =   1.827473d0 !    Chlorine -    Magnesium
    xfac(17,12) =   1.305523d0 !    Chlorine -    Magnesium
    !
    alpb(19, 1) =   1.320313d0 !   Potassium -     Hydrogen
    xfac(19, 1) =   4.298548d0 !   Potassium -     Hydrogen
    alpb(19, 6) =   0.999445d0 !   Potassium -       Carbon
    xfac(19, 6) =   0.849075d0 !   Potassium -       Carbon
    alpb(19, 7) =   2.161504d0 !   Potassium -     Nitrogen
    xfac(19, 7) =   6.502600d0 !   Potassium -     Nitrogen
    alpb(19, 8) =   2.008450d0 !   Potassium -       Oxygen
    xfac(19, 8) =   2.658504d0 !   Potassium -       Oxygen
    alpb(19, 9) =   0.999684d0 !   Potassium -     Fluorine
    xfac(19, 9) =   0.489361d0 !   Potassium -     Fluorine
    alpb(19,16) =   3.669853d0 !   Potassium -       Sulfur
    xfac(19,16) =   8.085841d0 !   Potassium -       Sulfur
    alpb(19,17) =   1.873677d0 !   Potassium -     Chlorine
    xfac(19,17) =   5.877136d0 !   Potassium -     Chlorine
    alpb(19,19) =   1.428561d0 !   Potassium -    Potassium
    xfac(19,19) =   8.818535d0 !   Potassium -    Potassium
    !
    alpb(20, 1) =   1.232916d0 !     Calcium -     Hydrogen
    xfac(20, 1) =   2.523722d0 !     Calcium -     Hydrogen
    alpb(20, 6) =   0.999988d0 !     Calcium -       Carbon
    xfac(20, 6) =   0.719460d0 !     Calcium -       Carbon
    alpb(20, 7) =   0.999988d0 !     Calcium -     Nitrogen
    xfac(20, 7) =   0.478031d0 !     Calcium -     Nitrogen
    alpb(20, 8) =   1.971239d0 !     Calcium -       Oxygen
    xfac(20, 8) =   1.362643d0 !     Calcium -       Oxygen
    alpb(20, 9) =   1.519589d0 !     Calcium -     Fluorine
    xfac(20, 9) =   0.714119d0 !     Calcium -     Fluorine
    alpb(20,16) =   0.999943d0 !     Calcium -       Sulfur
    xfac(20,16) =   0.473306d0 !     Calcium -       Sulfur
    alpb(20,17) =   1.106581d0 !     Calcium -     Chlorine
    xfac(20,17) =   0.445562d0 !     Calcium -     Chlorine
    alpb(20,20) =   0.999160d0 !     Calcium -      Calcium
    xfac(20,20) =   9.359604d0 !     Calcium -      Calcium
    !
    alpb(21, 1) =   1.676255d0 !    Scandium -     Hydrogen
    xfac(21, 1) =   0.100038d0 !    Scandium -     Hydrogen
    alpb(21, 6) =   1.432818d0 !    Scandium -       Carbon
    xfac(21, 6) =   0.520317d0 !    Scandium -       Carbon
    alpb(21, 7) =   1.000663d0 !    Scandium -     Nitrogen
    xfac(21, 7) =   0.235793d0 !    Scandium -     Nitrogen
    alpb(21, 8) =   2.142980d0 !    Scandium -       Oxygen
    xfac(21, 8) =   0.958225d0 !    Scandium -       Oxygen
    alpb(21, 9) =   1.060263d0 !    Scandium -     Fluorine
    xfac(21, 9) =   0.209576d0 !    Scandium -     Fluorine
    alpb(21,13) =   1.000109d0 !    Scandium -    Aluminium
    xfac(21,13) =   0.100109d0 !    Scandium -    Aluminium
    alpb(21,15) =   1.000121d0 !    Scandium -   Phosphorus
    xfac(21,15) =   0.253782d0 !    Scandium -   Phosphorus
    alpb(21,16) =   1.000706d0 !    Scandium -       Sulfur
    xfac(21,16) =   0.234873d0 !    Scandium -       Sulfur
    alpb(21,17) =   1.849424d0 !    Scandium -     Chlorine
    xfac(21,17) =   0.778710d0 !    Scandium -     Chlorine
    alpb(21,21) =   1.000275d0 !    Scandium -     Scandium
    xfac(21,21) =   0.100274d0 !    Scandium -     Scandium
    !
    alpb(22, 1) =   1.021853d0 !    Titanium -     Hydrogen
    xfac(22, 1) =   0.246319d0 !    Titanium -     Hydrogen
    alpb(22, 6) =   1.346533d0 !    Titanium -       Carbon
    xfac(22, 6) =   0.552633d0 !    Titanium -       Carbon
    alpb(22, 7) =   1.637988d0 !    Titanium -     Nitrogen
    xfac(22, 7) =   0.663632d0 !    Titanium -     Nitrogen
    alpb(22, 8) =   2.121591d0 !    Titanium -       Oxygen
    xfac(22, 8) =   1.244152d0 !    Titanium -       Oxygen
    alpb(22, 9) =   1.691383d0 !    Titanium -     Fluorine
    xfac(22, 9) =   0.557018d0 !    Titanium -     Fluorine
    alpb(22,13) =   1.010468d0 !    Titanium -    Aluminium
    xfac(22,13) =   0.099946d0 !    Titanium -    Aluminium
    alpb(22,15) =   1.000705d0 !    Titanium -   Phosphorus
    xfac(22,15) =   0.332715d0 !    Titanium -   Phosphorus
    alpb(22,16) =   1.101330d0 !    Titanium -       Sulfur
    xfac(22,16) =   0.263489d0 !    Titanium -       Sulfur
    alpb(22,17) =   1.442739d0 !    Titanium -     Chlorine
    xfac(22,17) =   0.394445d0 !    Titanium -     Chlorine
    alpb(22,22) =   0.999929d0 !    Titanium -     Titanium
    xfac(22,22) =   0.465550d0 !    Titanium -     Titanium
    !
    alpb(23, 1) =   2.099912d0 !    Vanadium -     Hydrogen
    xfac(23, 1) =   0.539076d0 !    Vanadium -     Hydrogen
    alpb(23, 6) =   2.111663d0 !    Vanadium -       Carbon
    xfac(23, 6) =   0.928294d0 !    Vanadium -       Carbon
    alpb(23, 7) =   2.985690d0 !    Vanadium -     Nitrogen
    xfac(23, 7) =   2.492636d0 !    Vanadium -     Nitrogen
    alpb(23, 8) =   2.706614d0 !    Vanadium -       Oxygen
    xfac(23, 8) =   1.949912d0 !    Vanadium -       Oxygen
    alpb(23, 9) =   1.953405d0 !    Vanadium -     Fluorine
    xfac(23, 9) =   0.624110d0 !    Vanadium -     Fluorine
    alpb(23,15) =   2.220280d0 !    Vanadium -   Phosphorus
    xfac(23,15) =   1.568020d0 !    Vanadium -   Phosphorus
    alpb(23,16) =   2.349793d0 !    Vanadium -       Sulfur
    xfac(23,16) =   1.712026d0 !    Vanadium -       Sulfur
    alpb(23,17) =   3.099188d0 !    Vanadium -     Chlorine
    xfac(23,17) =   3.851130d0 !    Vanadium -     Chlorine
    alpb(23,23) =   3.339987d0 !    Vanadium -     Vanadium
    xfac(23,23) =   1.934781d0 !    Vanadium -     Vanadium
    !
    alpb(24, 1) =   3.693279d0 !    Chromium -     Hydrogen
    xfac(24, 1) =   9.412996d0 !    Chromium -     Hydrogen
    alpb(24, 6) =   2.545791d0 !    Chromium -       Carbon
    xfac(24, 6) =   2.590834d0 !    Chromium -       Carbon
    alpb(24, 7) =   1.856777d0 !    Chromium -     Nitrogen
    xfac(24, 7) =   0.445433d0 !    Chromium -     Nitrogen
    alpb(24, 8) =   2.761764d0 !    Chromium -       Oxygen
    xfac(24, 8) =   2.181701d0 !    Chromium -       Oxygen
    alpb(24, 9) =   2.018260d0 !    Chromium -     Fluorine
    xfac(24, 9) =   0.588431d0 !    Chromium -     Fluorine
    alpb(24,11) =   1.259973d0 !    Chromium -       Sodium
    xfac(24,11) =   0.489256d0 !    Chromium -       Sodium
    alpb(24,15) =   3.705498d0 !    Chromium -   Phosphorus
    xfac(24,15) =   5.795478d0 !    Chromium -   Phosphorus
    alpb(24,16) =   1.294459d0 !    Chromium -       Sulfur
    xfac(24,16) =   0.291800d0 !    Chromium -       Sulfur
    alpb(24,17) =   2.376352d0 !    Chromium -     Chlorine
    xfac(24,17) =   1.398679d0 !    Chromium -     Chlorine
    alpb(24,19) =   1.000000d0 !    Chromium -    Potassium
    xfac(24,19) =   1.033088d0 !    Chromium -    Potassium
    alpb(24,24) =   1.411352d0 !    Chromium -     Chromium
    xfac(24,24) =   0.555820d0 !    Chromium -     Chromium
    !
    alpb(26, 1) =   4.086290d0 !        Iron -     Hydrogen
    xfac(26, 1) =   9.514035d0 !        Iron -     Hydrogen
    alpb(26, 6) =   2.065348d0 !        Iron -       Carbon
    xfac(26, 6) =   0.462249d0 !        Iron -       Carbon
    alpb(26, 7) =   2.153388d0 !        Iron -     Nitrogen
    xfac(26, 7) =   0.512937d0 !        Iron -     Nitrogen
    alpb(26, 8) =   2.196403d0 !        Iron -       Oxygen
    xfac(26, 8) =   0.482389d0 !        Iron -       Oxygen
    alpb(26, 9) =   2.806610d0 !        Iron -     Fluorine
    xfac(26, 9) =   1.252944d0 !        Iron -     Fluorine
    alpb(26,16) =   2.644622d0 !        Iron -       Sulfur
    xfac(26,16) =   1.376080d0 !        Iron -       Sulfur
    alpb(26,17) =   2.950885d0 !        Iron -     Chlorine
    xfac(26,17) =   1.689985d0 !        Iron -     Chlorine
    alpb(26,26) =   2.941730d0 !        Iron -         Iron
    xfac(26,26) =   1.107774d0 !        Iron -         Iron
    !
    alpb(27, 1) =   4.091550d0 !      Cobalt -     Hydrogen
    xfac(27, 1) =   2.317736d0 !      Cobalt -     Hydrogen
    alpb(27, 6) =   2.028624d0 !      Cobalt -       Carbon
    xfac(27, 6) =   0.296687d0 !      Cobalt -       Carbon
    alpb(27, 7) =   2.864252d0 !      Cobalt -     Nitrogen
    xfac(27, 7) =   1.105497d0 !      Cobalt -     Nitrogen
    alpb(27, 8) =   3.401118d0 !      Cobalt -       Oxygen
    xfac(27, 8) =   1.954967d0 !      Cobalt -       Oxygen
    alpb(27, 9) =   1.806946d0 !      Cobalt -     Fluorine
    xfac(27, 9) =   0.149166d0 !      Cobalt -     Fluorine
    alpb(27,15) =   4.244101d0 !      Cobalt -   Phosphorus
    xfac(27,15) =   1.244784d0 !      Cobalt -   Phosphorus
    alpb(27,16) =   2.293154d0 !      Cobalt -       Sulfur
    xfac(27,16) =   0.224918d0 !      Cobalt -       Sulfur
    alpb(27,17) =   1.696901d0 !      Cobalt -     Chlorine
    xfac(27,17) =   0.098378d0 !      Cobalt -     Chlorine
    alpb(27,27) =   1.390891d0 !      Cobalt -       Cobalt
    xfac(27,27) =   0.611200d0 !      Cobalt -       Cobalt
    !
    alpb(28, 6) =   2.047692d0 !      Nickel -       Carbon
    xfac(28, 6) =   0.594612d0 !      Nickel -       Carbon
    alpb(28, 7) =   3.197290d0 !      Nickel -     Nitrogen
    xfac(28, 7) =   2.825048d0 !      Nickel -     Nitrogen
    alpb(28, 8) =   3.650551d0 !      Nickel -       Oxygen
    xfac(28, 8) =   2.220774d0 !      Nickel -       Oxygen
    alpb(28, 9) =   4.138390d0 !      Nickel -     Fluorine
    xfac(28, 9) =   3.183738d0 !      Nickel -     Fluorine
    alpb(28,15) =   5.804675d0 !      Nickel -   Phosphorus
    xfac(28,15) =   2.450729d0 !      Nickel -   Phosphorus
    alpb(28,16) =   3.109609d0 !      Nickel -       Sulfur
    xfac(28,16) =   2.512540d0 !      Nickel -       Sulfur
    alpb(28,17) =   3.420216d0 !      Nickel -     Chlorine
    xfac(28,17) =   2.431295d0 !      Nickel -     Chlorine
    !
    alpb(29, 1) =   2.679471d0 !      Copper -     Hydrogen
    xfac(29, 1) =   0.812933d0 !      Copper -     Hydrogen
    alpb(29, 6) =   2.428147d0 !      Copper -       Carbon
    xfac(29, 6) =   0.629043d0 !      Copper -       Carbon
    alpb(29, 7) =   1.513341d0 !      Copper -     Nitrogen
    xfac(29, 7) =   0.126664d0 !      Copper -     Nitrogen
    alpb(29, 8) =   2.615641d0 !      Copper -       Oxygen
    xfac(29, 8) =   0.574106d0 !      Copper -       Oxygen
    alpb(29, 9) =   2.439234d0 !      Copper -     Fluorine
    xfac(29, 9) =   0.431529d0 !      Copper -     Fluorine
    alpb(29,15) =   2.006445d0 !      Copper -   Phosphorus
    xfac(29,15) =   0.318485d0 !      Copper -   Phosphorus
    alpb(29,16) =   1.484117d0 !      Copper -       Sulfur
    xfac(29,16) =   0.122708d0 !      Copper -       Sulfur
    alpb(29,17) =   1.621943d0 !      Copper -     Chlorine
    xfac(29,17) =   0.147900d0 !      Copper -     Chlorine
    alpb(29,29) =   2.056349d0 !      Copper -       Copper
    xfac(29,29) =   0.129793d0 !      Copper -       Copper
    !
    alpb(33,27) =   3.368144d0 !     Arsenic -       Cobalt
    xfac(33,27) =   1.675239d0 !     Arsenic -       Cobalt
    !
    alpb(35, 3) =   2.267688d0 !     Bromine -      Lithium
    xfac(35, 3) =   4.129581d0 !     Bromine -      Lithium
    alpb(35,11) =   2.403632d0 !     Bromine -       Sodium
    xfac(35,11) =  10.000006d0 !     Bromine -       Sodium
    alpb(35,12) =   2.275335d0 !     Bromine -    Magnesium
    xfac(35,12) =   3.649579d0 !     Bromine -    Magnesium
    alpb(35,19) =   2.029580d0 !     Bromine -    Potassium
    xfac(35,19) =   8.686070d0 !     Bromine -    Potassium
    alpb(35,20) =   1.217321d0 !     Bromine -      Calcium
    xfac(35,20) =   0.622015d0 !     Bromine -      Calcium
    alpb(35,21) =   1.752557d0 !     Bromine -     Scandium
    xfac(35,21) =   0.692157d0 !     Bromine -     Scandium
    alpb(35,22) =   1.220144d0 !     Bromine -     Titanium
    xfac(35,22) =   0.256820d0 !     Bromine -     Titanium
    alpb(35,23) =   3.776685d0 !     Bromine -     Vanadium
    xfac(35,23) =   8.941343d0 !     Bromine -     Vanadium
    alpb(35,24) =   1.450054d0 !     Bromine -     Chromium
    xfac(35,24) =   0.336528d0 !     Bromine -     Chromium
    alpb(35,26) =   3.501908d0 !     Bromine -         Iron
    xfac(35,26) =   6.338691d0 !     Bromine -         Iron
    alpb(35,27) =   4.000589d0 !     Bromine -       Cobalt
    xfac(35,27) =   3.634965d0 !     Bromine -       Cobalt
    alpb(35,28) =   3.117064d0 !     Bromine -       Nickel
    xfac(35,28) =   1.904637d0 !     Bromine -       Nickel
    alpb(35,29) =   1.825733d0 !     Bromine -       Copper
    xfac(35,29) =   0.203501d0 !     Bromine -       Copper
    !
    alpb(37, 1) =   2.163911d0 !    Rubidium -     Hydrogen
    xfac(37, 1) =   7.659030d0 !    Rubidium -     Hydrogen
    alpb(37, 8) =   3.605597d0 !    Rubidium -       Oxygen
    xfac(37, 8) =   6.635511d0 !    Rubidium -       Oxygen
    alpb(37, 9) =   2.940757d0 !    Rubidium -     Fluorine
    xfac(37, 9) =   6.559839d0 !    Rubidium -     Fluorine
    alpb(37,17) =   2.006252d0 !    Rubidium -     Chlorine
    xfac(37,17) =   3.308870d0 !    Rubidium -     Chlorine
    alpb(37,35) =   2.135073d0 !    Rubidium -      Bromine
    xfac(37,35) =   5.523206d0 !    Rubidium -      Bromine
    alpb(37,37) =   2.329519d0 !    Rubidium -     Rubidium
    xfac(37,37) =   7.321125d0 !    Rubidium -     Rubidium
    !
    alpb(38, 1) =   0.999390d0 !   Strontium -     Hydrogen
    xfac(38, 1) =   3.279894d0 !   Strontium -     Hydrogen
    alpb(38, 6) =   1.006168d0 !   Strontium -       Carbon
    xfac(38, 6) =   0.104550d0 !   Strontium -       Carbon
    alpb(38, 7) =   1.003353d0 !   Strontium -     Nitrogen
    xfac(38, 7) =   0.104635d0 !   Strontium -     Nitrogen
    alpb(38, 8) =   2.523434d0 !   Strontium -       Oxygen
    xfac(38, 8) =   1.384826d0 !   Strontium -       Oxygen
    alpb(38, 9) =   1.779157d0 !   Strontium -     Fluorine
    xfac(38, 9) =   1.149661d0 !   Strontium -     Fluorine
    alpb(38,16) =   1.014322d0 !   Strontium -       Sulfur
    xfac(38,16) =   0.562327d0 !   Strontium -       Sulfur
    alpb(38,17) =   1.101161d0 !   Strontium -     Chlorine
    xfac(38,17) =   0.419825d0 !   Strontium -     Chlorine
    alpb(38,35) =   0.999859d0 !   Strontium -      Bromine
    xfac(38,35) =   0.394830d0 !   Strontium -      Bromine
    alpb(38,38) =   1.004898d0 !   Strontium -    Strontium
    xfac(38,38) =   0.103370d0 !   Strontium -    Strontium
    !
    alpb(40, 1) =   1.191679d0 !   Zirconium -     Hydrogen
    xfac(40, 1) =   0.611472d0 !   Zirconium -     Hydrogen
    alpb(40, 6) =   1.448378d0 !   Zirconium -       Carbon
    xfac(40, 6) =   0.908774d0 !   Zirconium -       Carbon
    alpb(40, 7) =   1.794086d0 !   Zirconium -     Nitrogen
    xfac(40, 7) =   1.218702d0 !   Zirconium -     Nitrogen
    alpb(40, 8) =   2.520699d0 !   Zirconium -       Oxygen
    xfac(40, 8) =   3.776252d0 !   Zirconium -       Oxygen
    alpb(40, 9) =   2.023366d0 !   Zirconium -     Fluorine
    xfac(40, 9) =   1.545337d0 !   Zirconium -     Fluorine
    alpb(40,13) =   1.270618d0 !   Zirconium -    Aluminium
    xfac(40,13) =   0.874059d0 !   Zirconium -    Aluminium
    alpb(40,15) =   1.168915d0 !   Zirconium -   Phosphorus
    xfac(40,15) =   0.841496d0 !   Zirconium -   Phosphorus
    alpb(40,16) =   1.187588d0 !   Zirconium -       Sulfur
    xfac(40,16) =   0.890952d0 !   Zirconium -       Sulfur
    alpb(40,17) =   1.477001d0 !   Zirconium -     Chlorine
    xfac(40,17) =   0.727384d0 !   Zirconium -     Chlorine
    alpb(40,35) =   1.431258d0 !   Zirconium -      Bromine
    xfac(40,35) =   0.725137d0 !   Zirconium -      Bromine
    alpb(40,40) =   1.237025d0 !   Zirconium -    Zirconium
    xfac(40,40) =   0.864360d0 !   Zirconium -    Zirconium
    !
    alpb(42, 1) =   2.378986d0 !  Molybdenum -     Hydrogen
    xfac(42, 1) =   1.706974d0 !  Molybdenum -     Hydrogen
    alpb(42, 6) =   2.455593d0 !  Molybdenum -       Carbon
    xfac(42, 6) =   2.899166d0 !  Molybdenum -       Carbon
    alpb(42, 7) =   2.150309d0 !  Molybdenum -     Nitrogen
    xfac(42, 7) =   1.420214d0 !  Molybdenum -     Nitrogen
    alpb(42, 8) =   2.318219d0 !  Molybdenum -       Oxygen
    xfac(42, 8) =   1.424165d0 !  Molybdenum -       Oxygen
    alpb(42, 9) =   2.069297d0 !  Molybdenum -     Fluorine
    xfac(42, 9) =   0.884100d0 !  Molybdenum -     Fluorine
    alpb(42,15) =   1.927339d0 !  Molybdenum -   Phosphorus
    xfac(42,15) =   1.466154d0 !  Molybdenum -   Phosphorus
    alpb(42,16) =   2.629697d0 !  Molybdenum -       Sulfur
    xfac(42,16) =   4.103434d0 !  Molybdenum -       Sulfur
    alpb(42,17) =   2.088120d0 !  Molybdenum -     Chlorine
    xfac(42,17) =   1.135150d0 !  Molybdenum -     Chlorine
    alpb(42,24) =   1.678626d0 !  Molybdenum -     Chromium
    xfac(42,24) =   1.595571d0 !  Molybdenum -     Chromium
    alpb(42,35) =   2.097119d0 !  Molybdenum -      Bromine
    xfac(42,35) =   1.186756d0 !  Molybdenum -      Bromine
    alpb(42,42) =   2.281182d0 !  Molybdenum -   Molybdenum
    xfac(42,42) =   4.583438d0 !  Molybdenum -   Molybdenum
    !
    alpb(46, 1) =   2.041243d0 !   Palladium -     Hydrogen
    xfac(46, 1) =   0.430625d0 !   Palladium -     Hydrogen
    alpb(46, 6) =   3.442816d0 !   Palladium -       Carbon
    xfac(46, 6) =   3.400458d0 !   Palladium -       Carbon
    alpb(46, 7) =   3.867100d0 !   Palladium -     Nitrogen
    xfac(46, 7) =   5.510125d0 !   Palladium -     Nitrogen
    alpb(46, 8) =   2.826616d0 !   Palladium -       Oxygen
    xfac(46, 8) =   0.932468d0 !   Palladium -       Oxygen
    alpb(46, 9) =   3.785998d0 !   Palladium -     Fluorine
    xfac(46, 9) =   5.469458d0 !   Palladium -     Fluorine
    alpb(46,14) =   3.248566d0 !   Palladium -      Silicon
    xfac(46,14) =   5.267683d0 !   Palladium -      Silicon
    alpb(46,15) =   3.995342d0 !   Palladium -   Phosphorus
    xfac(46,15) =   4.829767d0 !   Palladium -   Phosphorus
    alpb(46,16) =   5.657215d0 !   Palladium -       Sulfur
    xfac(46,16) =   5.280869d0 !   Palladium -       Sulfur
    alpb(46,17) =   3.340418d0 !   Palladium -     Chlorine
    xfac(46,17) =   3.257806d0 !   Palladium -     Chlorine
    alpb(46,35) =   3.824737d0 !   Palladium -      Bromine
    xfac(46,35) =   5.152525d0 !   Palladium -      Bromine
    alpb(46,46) =   3.749207d0 !   Palladium -    Palladium
    xfac(46,46) =   5.524179d0 !   Palladium -    Palladium
    !
    alpb(47, 1) =   1.906028d0 !      Silver -     Hydrogen
    xfac(47, 1) =   0.598879d0 !      Silver -     Hydrogen
    alpb(47, 6) =   2.383592d0 !      Silver -       Carbon
    xfac(47, 6) =   1.351594d0 !      Silver -       Carbon
    alpb(47, 7) =   2.523534d0 !      Silver -     Nitrogen
    xfac(47, 7) =   1.217347d0 !      Silver -     Nitrogen
    alpb(47, 8) =   2.461500d0 !      Silver -       Oxygen
    xfac(47, 8) =   0.941833d0 !      Silver -       Oxygen
    alpb(47, 9) =   2.390898d0 !      Silver -     Fluorine
    xfac(47, 9) =   0.701901d0 !      Silver -     Fluorine
    alpb(47,15) =   1.083516d0 !      Silver -   Phosphorus
    xfac(47,15) =   0.120610d0 !      Silver -   Phosphorus
    alpb(47,16) =   2.508196d0 !      Silver -       Sulfur
    xfac(47,16) =   2.395844d0 !      Silver -       Sulfur
    alpb(47,17) =   1.916406d0 !      Silver -     Chlorine
    xfac(47,17) =   0.396164d0 !      Silver -     Chlorine
    alpb(47,35) =   2.436224d0 !      Silver -      Bromine
    xfac(47,35) =   1.260972d0 !      Silver -      Bromine
    alpb(47,47) =   3.137432d0 !      Silver -       Silver
    xfac(47,47) =   1.873430d0 !      Silver -       Silver
    !
    alpb(53, 3) =   2.430052d0 !      Iodine -      Lithium
    xfac(53, 3) =   9.738383d0 !      Iodine -      Lithium
    alpb(53,11) =   2.138290d0 !      Iodine -       Sodium
    xfac(53,11) =  10.000025d0 !      Iodine -       Sodium
    alpb(53,12) =   2.563705d0 !      Iodine -    Magnesium
    xfac(53,12) =  10.000011d0 !      Iodine -    Magnesium
    alpb(53,19) =   1.848045d0 !      Iodine -    Potassium
    xfac(53,19) =   8.419048d0 !      Iodine -    Potassium
    alpb(53,20) =   1.233027d0 !      Iodine -      Calcium
    xfac(53,20) =   1.073378d0 !      Iodine -      Calcium
    alpb(53,21) =   1.107792d0 !      Iodine -     Scandium
    xfac(53,21) =   0.145416d0 !      Iodine -     Scandium
    alpb(53,22) =   1.085513d0 !      Iodine -     Titanium
    xfac(53,22) =   0.335123d0 !      Iodine -     Titanium
    alpb(53,23) =   3.779472d0 !      Iodine -     Vanadium
    xfac(53,23) =   9.205430d0 !      Iodine -     Vanadium
    alpb(53,24) =   1.309520d0 !      Iodine -     Chromium
    xfac(53,24) =   0.309901d0 !      Iodine -     Chromium
    alpb(53,26) =   3.254087d0 !      Iodine -         Iron
    xfac(53,26) =   2.239898d0 !      Iodine -         Iron
    alpb(53,27) =   4.356713d0 !      Iodine -       Cobalt
    xfac(53,27) =   1.104424d0 !      Iodine -       Cobalt
    alpb(53,28) =   4.686287d0 !      Iodine -       Nickel
    xfac(53,28) =   1.274164d0 !      Iodine -       Nickel
    alpb(53,29) =   1.647705d0 !      Iodine -       Copper
    xfac(53,29) =   0.157448d0 !      Iodine -       Copper
    alpb(53,38) =   0.999837d0 !      Iodine -    Strontium
    xfac(53,38) =   0.819781d0 !      Iodine -    Strontium
    alpb(53,40) =   1.027422d0 !      Iodine -    Zirconium
    xfac(53,40) =   0.428563d0 !      Iodine -    Zirconium
    alpb(53,42) =   2.248014d0 !      Iodine -   Molybdenum
    xfac(53,42) =   2.117515d0 !      Iodine -   Molybdenum
    alpb(53,46) =   5.705495d0 !      Iodine -    Palladium
    xfac(53,46) =   5.229526d0 !      Iodine -    Palladium
    alpb(53,47) =   2.078961d0 !      Iodine -       Silver
    xfac(53,47) =   0.900167d0 !      Iodine -       Silver
    !
    alpb(55, 1) =   1.332561d0 !      Cesium -     Hydrogen
    xfac(55, 1) =   8.705312d0 !      Cesium -     Hydrogen
    alpb(55, 6) =   1.090683d0 !      Cesium -       Carbon
    xfac(55, 6) =   4.897821d0 !      Cesium -       Carbon
    alpb(55, 7) =   0.999646d0 !      Cesium -     Nitrogen
    xfac(55, 7) =   0.099792d0 !      Cesium -     Nitrogen
    alpb(55, 8) =   3.528675d0 !      Cesium -       Oxygen
    xfac(55, 8) =   4.390620d0 !      Cesium -       Oxygen
    alpb(55, 9) =   2.999365d0 !      Cesium -     Fluorine
    xfac(55, 9) =   4.453994d0 !      Cesium -     Fluorine
    alpb(55,15) =   2.593617d0 !      Cesium -   Phosphorus
    xfac(55,15) =   0.190509d0 !      Cesium -   Phosphorus
    alpb(55,16) =   4.000021d0 !      Cesium -       Sulfur
    xfac(55,16) =   4.423858d0 !      Cesium -       Sulfur
    alpb(55,17) =   1.969222d0 !      Cesium -     Chlorine
    xfac(55,17) =   3.000681d0 !      Cesium -     Chlorine
    alpb(55,35) =   2.046451d0 !      Cesium -      Bromine
    xfac(55,35) =   4.694115d0 !      Cesium -      Bromine
    alpb(55,53) =   1.847641d0 !      Cesium -       Iodine
    xfac(55,53) =   3.998888d0 !      Cesium -       Iodine
    alpb(55,55) =   0.996356d0 !      Cesium -       Cesium
    xfac(55,55) =   4.999747d0 !      Cesium -       Cesium
    !
    alpb(56, 1) =   1.171257d0 !      Barium -     Hydrogen
    xfac(56, 1) =   0.099982d0 !      Barium -     Hydrogen
    alpb(56, 6) =   1.047588d0 !      Barium -       Carbon
    xfac(56, 6) =   0.099981d0 !      Barium -       Carbon
    alpb(56, 7) =   1.000237d0 !      Barium -     Nitrogen
    xfac(56, 7) =   0.099981d0 !      Barium -     Nitrogen
    alpb(56, 8) =   1.422688d0 !      Barium -       Oxygen
    xfac(56, 8) =   0.383114d0 !      Barium -       Oxygen
    alpb(56, 9) =   1.730509d0 !      Barium -     Fluorine
    xfac(56, 9) =   1.127771d0 !      Barium -     Fluorine
    alpb(56,16) =   1.505311d0 !      Barium -       Sulfur
    xfac(56,16) =   1.957151d0 !      Barium -       Sulfur
    alpb(56,17) =   1.129944d0 !      Barium -     Chlorine
    xfac(56,17) =   0.557748d0 !      Barium -     Chlorine
    alpb(56,35) =   1.585564d0 !      Barium -      Bromine
    xfac(56,35) =   2.326451d0 !      Barium -      Bromine
    alpb(56,53) =   1.271836d0 !      Barium -       Iodine
    xfac(56,53) =   1.714690d0 !      Barium -       Iodine
    alpb(56,56) =   1.000402d0 !      Barium -       Barium
    xfac(56,56) =   0.136939d0 !      Barium -       Barium
    !
    alpb(78, 1) =   2.287480d0 !    Platinum -     Hydrogen
    xfac(78, 1) =   0.419211d0 !    Platinum -     Hydrogen
    alpb(78, 6) =   2.401063d0 !    Platinum -       Carbon
    xfac(78, 6) =   0.773872d0 !    Platinum -       Carbon
    alpb(78, 7) =   2.277268d0 !    Platinum -     Nitrogen
    xfac(78, 7) =   0.476560d0 !    Platinum -     Nitrogen
    alpb(78, 8) =   2.298204d0 !    Platinum -       Oxygen
    xfac(78, 8) =   0.587388d0 !    Platinum -       Oxygen
    alpb(78, 9) =   1.114424d0 !    Platinum -     Fluorine
    xfac(78, 9) =   0.119676d0 !    Platinum -     Fluorine
    alpb(78,14) =   0.999989d0 !    Platinum -      Silicon
    xfac(78,14) =   0.099989d0 !    Platinum -      Silicon
    alpb(78,15) =   2.131889d0 !    Platinum -   Phosphorus
    xfac(78,15) =   0.099936d0 !    Platinum -   Phosphorus
    alpb(78,16) =   1.671855d0 !    Platinum -       Sulfur
    xfac(78,16) =   0.125941d0 !    Platinum -       Sulfur
    alpb(78,17) =   1.569223d0 !    Platinum -     Chlorine
    xfac(78,17) =   0.099612d0 !    Platinum -     Chlorine
    alpb(78,35) =   1.571111d0 !    Platinum -      Bromine
    xfac(78,35) =   0.099993d0 !    Platinum -      Bromine
    alpb(78,53) =   2.085603d0 !    Platinum -       Iodine
    xfac(78,53) =   0.290991d0 !    Platinum -       Iodine
    alpb(78,78) =   0.999988d0 !    Platinum -     Platinum
    xfac(78,78) =   0.099990d0 !    Platinum -     Platinum
    !
  end subroutine alpb_and_xfac_mndo
