% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calendar.R
\name{stri_datetime_now}
\alias{stri_datetime_now}
\title{Get Current Date and Time}
\usage{
stri_datetime_now()
}
\value{
Returns an object of class \code{\link{POSIXct}}.
}
\description{
Returns the current date and time.
}
\details{
The current date and time in \pkg{stringi} is represented as the (signed)
number of seconds since 1970-01-01 00:00:00 UTC.
UTC leap seconds are ignored.
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Gagolewski M., \pkg{stringi}: Fast and portable character string processing in R, \emph{Journal of Statistical Software} 103(2), 2022, 1-59, \doi{10.18637/jss.v103.i02}

Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
