#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Crypt of the NecroDancer expansions:
# - Amplified
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250722.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='crypt-of-the-necrodancer'
GAME_NAME='Crypt of the NecroDancer'

EXPANSION_ID_AMPLIFIED='amplified'
EXPANSION_NAME_AMPLIFIED='Amplified'

ARCHIVE_BASE_AMPLIFIED_5_NAME='crypt_of_the_necrodancer_amplified_4_1_1_b5421_75773.sh'
ARCHIVE_BASE_AMPLIFIED_5_MD5='7781e21a31338b55478e85ac9e275d6f'
ARCHIVE_BASE_AMPLIFIED_5_SIZE='786163'
ARCHIVE_BASE_AMPLIFIED_5_VERSION='4.1.1-gog75773'
ARCHIVE_BASE_AMPLIFIED_5_URL='https://www.gog.com/game/crypt_of_the_necrodancer_amplified'

ARCHIVE_BASE_AMPLIFIED_4_NAME='crypt_of_the_necrodancer_amplified_4_0_0_b5095_71873.sh'
ARCHIVE_BASE_AMPLIFIED_4_MD5='f102e0705e1333dd622cb23464c76555'
ARCHIVE_BASE_AMPLIFIED_4_SIZE='786163'
ARCHIVE_BASE_AMPLIFIED_4_VERSION='4.0.0-gog71873'

ARCHIVE_BASE_AMPLIFIED_3_NAME='crypt_of_the_necrodancer_amplified_3_7_5_b4897_68999.sh'
ARCHIVE_BASE_AMPLIFIED_3_MD5='afbe68f105b71e8d918a4768498d8c24'
ARCHIVE_BASE_AMPLIFIED_3_SIZE='786163'
ARCHIVE_BASE_AMPLIFIED_3_VERSION='3.7.5-gog68999'

ARCHIVE_BASE_AMPLIFIED_2_NAME='crypt_of_the_necrodancer_amplified_3_7_4_b4860_68330.sh'
ARCHIVE_BASE_AMPLIFIED_2_MD5='e56eb1c2e7595ced5b67075dc08d65c9'
ARCHIVE_BASE_AMPLIFIED_2_SIZE='794448'
ARCHIVE_BASE_AMPLIFIED_2_VERSION='3.7.4-gog68330'

ARCHIVE_BASE_AMPLIFIED_1_NAME='crypt_of_the_necrodancer_amplified_3_4_0_b3655_61079.sh'
ARCHIVE_BASE_AMPLIFIED_1_MD5='410df53bd1efe43dfc6fd41cb9cdf694'
ARCHIVE_BASE_AMPLIFIED_1_SIZE='600000'
ARCHIVE_BASE_AMPLIFIED_1_VERSION='3.4.0-gog61079'

ARCHIVE_BASE_AMPLIFIED_0_NAME='crypt_of_the_necrodancer_amplified_3_1_5_b3223_59419.sh'
ARCHIVE_BASE_AMPLIFIED_0_MD5='67c2111ad6116ea68c343f9d7694eb1c'
ARCHIVE_BASE_AMPLIFIED_0_SIZE='600000'
ARCHIVE_BASE_AMPLIFIED_0_VERSION='3.1.5-gog59419'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
data
goggame-1981284042.info'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_PROVIDES="
${GAME_ID}-data-shared"
PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'
## Easy upgrade from pre-20250708.2 packages.
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
crypt-of-the-necrodancer-data-common"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
