# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gtk import STOCK_MEDIA_PLAY
from ConfigParser import ConfigParser, NoSectionError
from os.path import join, isdir
from os import makedirs

from common.config import ConfigLoader

from modules.player.player_gui import PlayerGUI
from modules.player.config import Config

class Player:
    def __init__(self, extensionsloader):
        self.extensions = extensionsloader
        self.module = {'name': 'Player',
                       'logo': STOCK_MEDIA_PLAY,
                       'configurable': True}

    def start_module(self):
        """This function starts the module."""
        # Start configuration
        name = self.module['name'].lower() + '.cfg'
        self.config = ConfigLoader()
        self.config_file = join(self.config.confdir, 'modules', name)
        self.data_dir = join(self.config.datadir, 'modules', 'player')

        if not isdir(self.data_dir):
            makedirs(self.data_dir)

        def launch_player(glade_file):
            conf = self.get_configuration()
            self.player_gui = PlayerGUI(glade_file, conf)
            self.cfg = Config(self.module, self.player_gui,
                              self.config_file, self.get_configuration)

        def handler_previous():
            self.player_gui.handler_previous()

        def handler_stop():
            self.player_gui.handler_stop()

        def handler_play():
            self.player_gui.handler_play()

        def handler_next():
            self.player_gui.handler_next()

        def handler_play_new_song(song):
            self.player_gui.handler_play_new_song(song)

        def handler_play_new_radio(song):
            self.player_gui.handler_play_new_radio(song)

        def configuration(args):
            self.cfg.configuration(args)

        def save_config(args):
            self.cfg.save_config(args)

        # Connect to Bluemindo's signals
        self.extensions.connect('OnBluemindoStarted', launch_player)
        self.extensions.connect('OnPreviousPressed', handler_previous)
        self.extensions.connect('OnStopPressed', handler_stop)
        self.extensions.connect('OnPlayPressed', handler_play)
        self.extensions.connect('OnNextPressed', handler_next)
        self.extensions.connect('OnPlayNewSong', handler_play_new_song)
        self.extensions.connect('OnPlayNewRadio', handler_play_new_radio)
        self.extensions.connect('OnModuleConfiguration', configuration)
        self.extensions.connect('OnModuleConfigurationSave', save_config)

    def get_configuration(self):
        configparser = ConfigParser()
        configparser.read(self.config_file)
        config = {}

        try:
            for item in configparser.items(self.module['name']):
                try:
                    value = int(item[1])
                except ValueError:
                    value = str(item[1])

                config[item[0]] = value
        except NoSectionError:
            config['popup'] = True
            config['title'] = True
            config['gstplayback'] = 'default'
            config['startminimized'] = True

        name = self.module['name'].lower() + '.cfg'
        config['__config-file'] = self.config_file
        config['__data-dir'] = self.data_dir
        config['__extensions'] = self.extensions

        return config