!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_def
!! NAME
!!  etsf_io_split_def
!!
!! FUNCTION
!!    Create arrays for split definitions. They are defined only if their
!!    dimensions (my_<something>) are different from etsf_no_dimension (see
!!    ETSF_IO_CONSTANTS) or from the value of dimension <something>.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * dims <type(etsf_dims)> = 
!!     contains all the dimensions required by the special my_something arrays.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_def(ncid, dims, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_def'


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_def : enter'
!ENDDEBUG

  if (dims%my_number_of_kpoints /= etsf_no_dimension .and. &
    & dims%my_number_of_kpoints /= dims%number_of_kpoints) then 
    call etsf_io_low_def_var(ncid, "my_kpoints", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_kpoints") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_number_of_grid_points_vect3 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect3 /= dims%number_of_grid_points_vector3) then 
    call etsf_io_low_def_var(ncid, "my_grid_points_vector3", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_grid_points_vector3") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_number_of_spins /= etsf_no_dimension .and. &
    & dims%my_number_of_spins /= dims%number_of_spins) then 
    call etsf_io_low_def_var(ncid, "my_spins", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_spins") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_number_of_grid_points_vect1 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect1 /= dims%number_of_grid_points_vector1) then 
    call etsf_io_low_def_var(ncid, "my_grid_points_vector1", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_grid_points_vector1") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_number_of_grid_points_vect2 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect2 /= dims%number_of_grid_points_vector2) then 
    call etsf_io_low_def_var(ncid, "my_grid_points_vector2", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_grid_points_vector2") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_max_number_of_coefficients /= etsf_no_dimension .and. &
    & dims%my_max_number_of_coefficients /= dims%max_number_of_coefficients) then 
    call etsf_io_low_def_var(ncid, "my_coefficients", &
      & etsf_io_low_integer, &
      & (/ pad("my_max_number_of_coefficients") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_number_of_components /= etsf_no_dimension .and. &
    & dims%my_number_of_components /= dims%number_of_components) then 
    call etsf_io_low_def_var(ncid, "my_components", &
      & etsf_io_low_integer, &
      & (/ pad("my_number_of_components") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if
  if (dims%my_max_number_of_states /= etsf_no_dimension .and. &
    & dims%my_max_number_of_states /= dims%max_number_of_states) then 
    call etsf_io_low_def_var(ncid, "my_states", &
      & etsf_io_low_integer, &
      & (/ pad("my_max_number_of_states") /), &
      & lstat, error_data = error_data)
    if (.not. lstat) return
  end if


!DEBUG
!write (*,*) 'etsf_io_split_def : exit'
!ENDDEBUG

end subroutine etsf_io_split_def
!!***
