{
     File:       ATS/ScalerStreamTypes.h
 
     Contains:   Scaler streaming data structures and constants for OFA 1.x
 
     Copyright:   1994-2008 by Apple Inc., all rights reserved.
 
     Warning:    *** APPLE INTERNAL USE ONLY ***
                 This file may contain unreleased API's
 
     BuildInfo:  Built by:            root
                 On:                  Fri Jul 24 22:21:51 2009
                 With Interfacer:     3.0d46   (Mac OS X for PowerPC)
                 From:                ScalerStreamTypes.i
                     Revision:        1.5
                     Dated:           2007/01/15 23:28:27
                     Last change by:  kurita
                     Last comment:    <rdar://problem/4916090> updated copyright.
 
     Bugs:       Report bugs to Radar component "System Interfaces", "Latest"
                 List the version information (from above) in the Problem Description.
 
}

{ Pascal Translation: Gorazd Krosl <gorazd_1957@yahoo.ca>, October 2009 }

{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

unit ScalerStreamTypes;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
{$ifc defined(iphonesim)}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{ will require compiler define when/if other Apple devices with ARM cpus ship }
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,SFNTTypes;
{$endc} {not MACOSALLINCLUDE}


{$ifc TARGET_OS_MAC}

{$ALIGN POWER}


{ ScalerStream input/output types }
const
	cexec68K = $00000001;
	truetypeStreamType = $00000001;
	type1StreamType = $00000002;
	type3StreamType = $00000004;
	type42StreamType = $00000008;
	type42GXStreamType = $00000010;
	portableStreamType = $00000020;
	flattenedStreamType = $00000040;
	cidType2StreamType = $00000080;
	cidType0StreamType = $00000100;
	type1CFFStreamType = $00000200;
	evenOddModifierStreamType = $00008000;
	eexecBinaryModifierStreamType = $00010000; { encrypted portion of Type1Stream to be binary }
	unicodeMappingModifierStreamType = $00020000; { include glyph ID to unicode mapping info for PDF }
	scalerSpecifcModifierMask = $0000F000; { for scaler's internal use }
	streamTypeModifierMask = $FFFFF000; { 16 bits for Apple, 4 bits for scaler }

{ Possible streamed font formats }
type
	scalerStreamTypeFlag = UInt32;
const
	downloadStreamAction = 0;    { Transmit the (possibly sparse) font data }
	asciiDownloadStreamAction = 1;    { Transmit font data to a 7-bit ASCII destination }
	fontSizeQueryStreamAction = 2;    { Estimate in-printer memory used if the font were downloaded }
	encodingOnlyStreamAction = 3;    { Transmit only the encoding for the font }
	prerequisiteQueryStreamAction = 4;    { Return a list of prerequisite items needed for the font }
	prerequisiteItemStreamAction = 5;    { Transmit a specified prerequisite item }
	variationQueryStreamAction = 6;    { Return information regarding support for variation streaming }
	variationPSOperatorStreamAction = 7;   { Transmit Postscript code necessary to effect variation of a font }

type
	scalerStreamAction = SInt32;
const
	selectAllVariations = -1;    { Special variationCount value meaning include all variation data }

type
	scalerPrerequisiteItem = record
		enumeration: SInt32;            { Shorthand tag identifying the item }
		size: SInt32;                   { Worst case vm in printer item requires. Never > than 16-bit quantity }
		name: packed array[0..0] of char;          { Name to be used by the client when emitting the item (Pascal string) }
	end;


	scalerStremFontRec = record
		encoding: { const } UInt16Ptr;        { <- Intention is * unsigned short[256] }
		glyphBits: SInt32Ptr;          { <->    Bitvector: a bit for each glyph, 1 = desired/supplied }
		name: PChar               { <->    The printer font name to use/used (C string) }
	end;

	scalerStreamPrerequisiteQueryRec = record
		size: SInt32;               { ->     Size of the prereq. list in bytes (0 indicates no prerequisites)}
		list: { const } UnivPtr;               { <- Pointer to client block to hold list (nil = list size query only) }
	end;

	scalerStreamInfoRec = record
		case SInt16 of
		0:	(	{ Normal font streaming information }
				font: scalerStremFontRec
			);
		1:	(	{ Used to obtain a list of prerequisites from the scaler}
				prerequisiteQuery: scalerStreamPrerequisiteQueryRec
			);
		2:	(
				prerequisiteItem: SInt32;	{ <-     Enumeration value for the prerequisite item to be streamed.}
			);
		3:	(
				variationQueryResult: SInt32;	{ -> Output from the variationQueryStreamAction }
			);
		end;

	scalerStreamPtr = ^scalerStream;
	scalerStream = record
		streamRefCon: { const } UnivPtr;           { <- private reference for client }
		targetVersion: { const } PChar;          { <- e.g. Postscript printer name (C string) }
		types: scalerStreamTypeFlag;                { <->    Data stream formats desired/supplied }
		action: scalerStreamAction;                 { <-     What action to take }
		memorySize: UInt32;             { -> Worst case memory use (vm) in printer or as sfnt }
		variationCount: SInt32;         { <- The number of variations, or selectAllVariations }
		variations: { const } UnivPtr;             { <- A pointer to an array of the variations (gxFontVariation) }
		info: scalerStreamInfoRec;
	end;


	scalerStreamDataPtr = ^scalerStreamData;
	scalerStreamData = record
		hexFlag: SInt32;                { Indicates that the data is to be interpreted as hex, versus binary }
		byteCount: SInt32;              { Number of bytes in the data being streamed }
		data: { const } UnivPtr;                   { Pointer to the data being streamed }
	end;

{$endc} {TARGET_OS_MAC}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}

end.
{$endc} {not MACOSALLINCLUDE}
