/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by the gen-test-libm.sh script.
 * Do not edit! */

check_double ("acos (0.0)", acos (0.0), 1.57079632679489655800E+00);
check_double ("acos (-0.0)", acos (-0.0), 1.57079632679489655800E+00);
check_double ("acos (1.0)", acos (1.0), 0.00000000000000000000E+00);
check_double ("acos (-1.0)", acos (-1.0), 3.14159265358979311600E+00);
check_double ("acos (0.5)", acos (0.5), 1.04719755119659785336E+00);
check_double ("acos (-0.5)", acos (-0.5), 2.09439510239319570672E+00);
check_double ("acos (INFINITY)", acos (INFINITY), NAN);
check_double ("acos (-INFINITY)", acos (-INFINITY), NAN);
check_double ("acos (NAN)", acos (NAN), NAN);
check_double ("acos (6.9e-18)", acos (6.9e-18), 1.57079632679489655800E+00);
check_double ("acos (-6.9e-18)", acos (-6.9e-18), 1.57079632679489655800E+00);
check_double ("acos (7.0e-18)", acos (7.0e-18), 1.57079632679489655800E+00);
check_double ("acos (-7.0e-18)", acos (-7.0e-18), 1.57079632679489655800E+00);
check_double ("acos (7.4e-9)", acos (7.4e-9), 1.57079631939489661185E+00);
check_double ("acos (-7.4e-9)", acos (-7.4e-9), 1.57079633419489672619E+00);
check_double ("acos (7.5e-9)", acos (7.5e-9), 1.57079631929489660358E+00);
check_double ("acos (-7.5e-9)", acos (-7.5e-9), 1.57079633429489651242E+00);
check_double ("acos (0.1)", acos (0.1), 1.47062890563333681371E+00);
check_double ("acos (-0.1)", acos (-0.1), 1.67096374795645652434E+00);
check_double ("acos (0.4)", acos (0.4), 1.15927948072740849561E+00);
check_double ("acos (-0.4)", acos (-0.4), 1.98231317286238462039E+00);
check_double ("acos (0.6)", acos (0.6), 9.27295218001612298053E-01);
check_double ("acos (-0.6)", acos (-0.6), 2.21429743558818081794E+00);
check_double ("acos (0.99)", acos (0.99), 1.41539473324427289569E-01);
check_double ("acos (-0.99)", acos (-0.99), 3.00005318026536604847E+00);
check_double ("acos (1.1)", acos (1.1), NAN);
check_double ("acos (-1.1)", acos (-1.1), NAN);
check_double ("acos (0.7)", acos (0.7), 7.95398830184143590394E-01);
check_double ("asin (0.0)", asin (0.0), 0.00000000000000000000E+00);
check_double ("asin (-0.0)", asin (-0.0), -0.00000000000000000000E+00);
check_double ("asin (1.0)", asin (1.0), 1.57079632679489655800E+00);
check_double ("asin (-1.0)", asin (-1.0), -1.57079632679489655800E+00);
check_double ("asin (0.5)", asin (0.5), 5.23598775598298926681E-01);
check_double ("asin (-0.5)", asin (-0.5), -5.23598775598298926681E-01);
check_double ("asin (0.98)", asin (0.98), 1.37046148447177684737E+00);
check_double ("asin (-0.98)", asin (-0.98), -1.37046148447177684737E+00);
check_double ("asin (INFINITY)", asin (INFINITY), NAN);
check_double ("asin (-INFINITY)", asin (-INFINITY), NAN);
check_double ("asin (NAN)", asin (NAN), NAN);
check_double ("asin (6.9e-18)", asin (6.9e-18), 6.90000000000000026253E-18);
check_double ("asin (-6.9e-18)", asin (-6.9e-18), -6.90000000000000026253E-18);
check_double ("asin (7.0e-18)", asin (7.0e-18), 6.99999999999999973042E-18);
check_double ("asin (-7.0e-18)", asin (-7.0e-18), -6.99999999999999973042E-18);
check_double ("asin (7.4e-9)", asin (7.4e-9), 7.40000000000000008865E-09);
check_double ("asin (-7.4e-9)", asin (-7.4e-9), -7.40000000000000008865E-09);
check_double ("asin (7.5e-9)", asin (7.5e-9), 7.49999999999999932974E-09);
check_double ("asin (-7.5e-9)", asin (-7.5e-9), -7.49999999999999932974E-09);
check_double ("asin (0.1)", asin (0.1), 1.00167421161559799803E-01);
check_double ("asin (-0.1)", asin (-0.1), -1.00167421161559799803E-01);
check_double ("asin (0.4)", asin (0.4), 4.11516846067488062388E-01);
check_double ("asin (-0.4)", asin (-0.4), -4.11516846067488062388E-01);
check_double ("asin (0.6)", asin (0.6), 6.43501108793284370968E-01);
check_double ("asin (-0.6)", asin (-0.6), -6.43501108793284370968E-01);
check_double ("asin (0.97)", asin (0.97), 1.32523080927960457132E+00);
check_double ("asin (-0.97)", asin (-0.97), -1.32523080927960457132E+00);
check_double ("asin (0.99)", asin (0.99), 1.42925685347046926843E+00);
check_double ("asin (-0.99)", asin (-0.99), -1.42925685347046926843E+00);
check_double ("asin (1.1)", asin (1.1), NAN);
check_double ("asin (-1.1)", asin (-1.1), NAN);
check_double ("asin (0.7)", asin (0.7), 7.75397496610752967605E-01);
check_double ("atan (0.0)", atan (0.0), 0.00000000000000000000E+00);
check_double ("atan (-0.0)", atan (-0.0), -0.00000000000000000000E+00);
check_double ("atan (7.0 / 16.0)", atan (7.0 / 16.0), 4.12410441597387322776E-01);
check_double ("atan (-7.0 / 16.0)", atan (-7.0 / 16.0), -4.12410441597387322776E-01);
check_double ("atan (11.0 / 16.0)", atan (11.0 / 16.0), 6.02287346134964152178E-01);
check_double ("atan (-11.0 / 16.0)", atan (-11.0 / 16.0), -6.02287346134964152178E-01);
check_double ("atan (19.0 / 16.0)", atan (19.0 / 16.0), 8.70903457075652975838E-01);
check_double ("atan (-19.0 / 16.0)", atan (-19.0 / 16.0), -8.70903457075652975838E-01);
check_double ("atan (39.0 / 16.0)", atan (39.0 / 16.0), 1.18147960496175574718E+00);
check_double ("atan (-39.0 / 16.0)", atan (-39.0 / 16.0), -1.18147960496175574718E+00);
check_double ("atan (1.0)", atan (1.0), 7.85398163397448278999E-01);
check_double ("atan (-1.0)", atan (-1.0), -7.85398163397448278999E-01);
check_double ("atan (INFINITY)", atan (INFINITY), 1.57079632679489655800E+00);
check_double ("atan (-INFINITY)", atan (-INFINITY), -1.57079632679489655800E+00);
check_double ("atan (NAN)", atan (NAN), NAN);
check_double ("atan (6.9 / 16.0)", atan (6.9 / 16.0), 4.07152520941509277197E-01);
check_double ("atan (-6.9 / 16.0)", atan (-6.9 / 16.0), -4.07152520941509277197E-01);
check_double ("atan (7.1 / 16.0)", atan (7.1 / 16.0), 4.17644283240569735849E-01);
check_double ("atan (-7.1 / 16.0)", atan (-7.1 / 16.0), -4.17644283240569735849E-01);
check_double ("atan (10.9 / 16.0)", atan (10.9 / 16.0), 5.98030920656102416011E-01);
check_double ("atan (-10.9 / 16.0)", atan (-10.9 / 16.0), -5.98030920656102416011E-01);
check_double ("atan (11.1 / 16.0)", atan (11.1 / 16.0), 6.06519005615576589641E-01);
check_double ("atan (-11.1 / 16.0)", atan (-11.1 / 16.0), -6.06519005615576589641E-01);
check_double ("atan (18.9 / 16.0)", atan (18.9 / 16.0), 8.68302259886018612534E-01);
check_double ("atan (-18.9 / 16.0)", atan (-18.9 / 16.0), -8.68302259886018612534E-01);
check_double ("atan (19.1 / 16.0)", atan (19.1 / 16.0), 8.73488683179258762479E-01);
check_double ("atan (-19.1 / 16.0)", atan (-19.1 / 16.0), -8.73488683179258762479E-01);
check_double ("atan (38.9 / 16.0)", atan (38.9 / 16.0), 1.18057723083411603149E+00);
check_double ("atan (-38.9 / 16.0)", atan (-38.9 / 16.0), -1.18057723083411603149E+00);
check_double ("atan (39.1 / 16.0)", atan (39.1 / 16.0), 1.18237802686613768799E+00);
check_double ("atan (-39.1 / 16.0)", atan (-39.1 / 16.0), -1.18237802686613768799E+00);
check_double ("atan (0.99)", atan (0.99), 7.80373080066635860241E-01);
check_double ("atan (-0.99)", atan (-0.99), -7.80373080066635860241E-01);
check_double ("atan (1.1)", atan (1.1), 8.32981266674431730657E-01);
check_double ("atan (-1.1)", atan (-1.1), -8.32981266674431730657E-01);
check_double ("atan (7.37e+19)", atan (7.37e+19), 1.57079632679489655800E+00);
check_double ("atan (-7.37e+19)", atan (-7.37e+19), -1.57079632679489655800E+00);
check_double ("atan (7.38e+19)", atan (7.38e+19), 1.57079632679489655800E+00);
check_double ("atan (-7.38e+19)", atan (-7.38e+19), -1.57079632679489655800E+00);
check_double ("atan (0.7)", atan (0.7), 6.10725964389208564320E-01);
check_double ("atan2 (NAN, NAN)", atan2 (NAN, NAN), NAN);
check_double ("atan2 (0.0, NAN)", atan2 (0.0, NAN), NAN);
check_double ("atan2 (-0.0, NAN)", atan2 (-0.0, NAN), NAN);
check_double ("atan2 (1.0, NAN)", atan2 (1.0, NAN), NAN);
check_double ("atan2 (-1.0, NAN)", atan2 (-1.0, NAN), NAN);
check_double ("atan2 (INFINITY, NAN)", atan2 (INFINITY, NAN), NAN);
check_double ("atan2 (-INFINITY, NAN)", atan2 (-INFINITY, NAN), NAN);
check_double ("atan2 (NAN, 0.0)", atan2 (NAN, 0.0), NAN);
check_double ("atan2 (NAN, -0.0)", atan2 (NAN, -0.0), NAN);
check_double ("atan2 (NAN, 1.0)", atan2 (NAN, 1.0), NAN);
check_double ("atan2 (NAN, -1.0)", atan2 (NAN, -1.0), NAN);
check_double ("atan2 (NAN, INFINITY)", atan2 (NAN, INFINITY), NAN);
check_double ("atan2 (NAN, -INFINITY)", atan2 (NAN, -INFINITY), NAN);
check_double ("atan2 (0.0, 0.0)", atan2 (0.0, 0.0), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -0.0)", atan2 (0.0, -0.0), 3.14159265358979311600E+00);
check_double ("atan2 (-0.0, 0.0)", atan2 (-0.0, 0.0), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -0.0)", atan2 (-0.0, -0.0), -3.14159265358979311600E+00);
check_double ("atan2 (0.0, 1.0)", atan2 (0.0, 1.0), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -1.0)", atan2 (0.0, -1.0), 3.14159265358979311600E+00);
check_double ("atan2 (0.0, INFINITY)", atan2 (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("atan2 (0.0, -INFINITY)", atan2 (0.0, -INFINITY), 3.14159265358979311600E+00);
check_double ("atan2 (-0.0, 1.0)", atan2 (-0.0, 1.0), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -1.0)", atan2 (-0.0, -1.0), -3.14159265358979311600E+00);
check_double ("atan2 (-0.0, INFINITY)", atan2 (-0.0, INFINITY), -0.00000000000000000000E+00);
check_double ("atan2 (-0.0, -INFINITY)", atan2 (-0.0, -INFINITY), -3.14159265358979311600E+00);
check_double ("atan2 (1.0, 0.0)", atan2 (1.0, 0.0), 1.57079632679489655800E+00);
check_double ("atan2 (1.0, -0.0)", atan2 (1.0, -0.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, 0.0)", atan2 (INFINITY, 0.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, -0.0)", atan2 (INFINITY, -0.0), 1.57079632679489655800E+00);
check_double ("atan2 (-1.0, 0.0)", atan2 (-1.0, 0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-1.0, -0.0)", atan2 (-1.0, -0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, 0.0)", atan2 (-INFINITY, 0.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, -0.0)", atan2 (-INFINITY, -0.0), -1.57079632679489655800E+00);
check_double ("atan2 (1.0, INFINITY)", atan2 (1.0, INFINITY), 0.00000000000000000000E+00);
check_double ("atan2 (-1.0, INFINITY)", atan2 (-1.0, INFINITY), -0.00000000000000000000E+00);
check_double ("atan2 (1.0, -INFINITY)", atan2 (1.0, -INFINITY), 3.14159265358979311600E+00);
check_double ("atan2 (-1.0, -INFINITY)", atan2 (-1.0, -INFINITY), -3.14159265358979311600E+00);
check_double ("atan2 (INFINITY, INFINITY)", atan2 (INFINITY, INFINITY), 7.85398163397448278999E-01);
check_double ("atan2 (INFINITY, -INFINITY)", atan2 (INFINITY, -INFINITY), 2.35619449019234483700E+00);
check_double ("atan2 (-INFINITY, INFINITY)", atan2 (-INFINITY, INFINITY), -7.85398163397448278999E-01);
check_double ("atan2 (-INFINITY, -INFINITY)", atan2 (-INFINITY, -INFINITY), -2.35619449019234483700E+00);
check_double ("atan2 (INFINITY, 1.0)", atan2 (INFINITY, 1.0), 1.57079632679489655800E+00);
check_double ("atan2 (INFINITY, -1.0)", atan2 (INFINITY, -1.0), 1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, 1.0)", atan2 (-INFINITY, 1.0), -1.57079632679489655800E+00);
check_double ("atan2 (-INFINITY, -1.0)", atan2 (-INFINITY, -1.0), -1.57079632679489655800E+00);
check_double ("atan2 (0.7, 1.0)", atan2 (0.7, 1.0), 6.10725964389208564320E-01);
check_double ("atan2 (-0.7, 1.0)", atan2 (-0.7, 1.0), -6.10725964389208564320E-01);
check_double ("atan2 (0.7, -1.0)", atan2 (0.7, -1.0), 2.53086668920058466270E+00);
check_double ("atan2 (-0.7, -1.0)", atan2 (-0.7, -1.0), -2.53086668920058466270E+00);
check_double ("atan2 (0.4, 0.0003)", atan2 (0.4, 0.0003), 1.57004632693552159672E+00);
check_double ("atan2 (1.4, -0.93)", atan2 (1.4, -0.93), 2.15714876682378431383E+00);
check_double ("ceil (0.0)", ceil (0.0), 0.00000000000000000000E+00);
check_double ("ceil (-0.0)", ceil (-0.0), -0.00000000000000000000E+00);
check_double ("ceil (INFINITY)", ceil (INFINITY), INF);
check_double ("ceil (-INFINITY)", ceil (-INFINITY), -INF);
check_double ("ceil (NAN)", ceil (NAN), NAN);
check_double ("ceil (3.14)", ceil (3.14), 4.00000000000000000000E+00);
check_double ("ceil (-3.14)", ceil (-3.14), -3.00000000000000000000E+00);
check_double ("ceil (3.72e-09)", ceil (3.72e-09), 1.00000000000000000000E+00);
check_double ("ceil (-3.72e-09)", ceil (-3.72e-09), -0.00000000000000000000E+00);
check_double ("ceil (7.37e+19)", ceil (7.37e+19), 7.37000000000000000000E+19);
check_double ("ceil (-7.37e+19)", ceil (-7.37e+19), -7.37000000000000000000E+19);
check_double ("exp (0.0)", exp (0.0), 1.00000000000000000000E+00);
check_double ("exp (-0.0)", exp (-0.0), 1.00000000000000000000E+00);
check_double ("exp (1.0)", exp (1.0), 2.71828182845904509080E+00);
check_double ("exp (-1.0)", exp (-1.0), 3.67879441171442334024E-01);
check_double ("exp (INFINITY)", exp (INFINITY), INF);
check_double ("exp (-INFINITY)", exp (-INFINITY), 0.00000000000000000000E+00);
check_double ("exp (NAN)", exp (NAN), NAN);
check_double ("exp (7.08e+02)", exp (7.08e+02), 3.02338314427605515848E+307);
check_double ("exp (7.10e+02)", exp (7.10e+02), INF);
check_double ("exp (-7.40e+02)", exp (-7.40e+02), 4.19955798965059562550E-322);
check_double ("exp (-7.50e+02)", exp (-7.50e+02), 0.00000000000000000000E+00);
check_double ("exp (0.34)", exp (0.34), 1.40494759056359375116E+00);
check_double ("exp (-0.34)", exp (-0.34), 7.11770322762609652933E-01);
check_double ("exp (0.35)", exp (0.35), 1.41906754859325712204E+00);
check_double ("exp (-0.35)", exp (-0.35), 7.04688089718713439602E-01);
check_double ("exp (1.03)", exp (1.03), 2.80106583469907910455E+00);
check_double ("exp (-1.03)", exp (-1.03), 3.57006960569147380191E-01);
check_double ("exp (1.04)", exp (1.04), 2.82921701435155981130E+00);
check_double ("exp (-1.04)", exp (-1.04), 3.53454681958780159157E-01);
check_double ("exp (3.72e-09)", exp (3.72e-09), 1.00000000372000008575E+00);
check_double ("exp (-3.72e-09)", exp (-3.72e-09), 9.99999996280000025273E-01);
check_double ("exp (3.73e-09)", exp (3.73e-09), 1.00000000373000008658E+00);
check_double ("exp (-3.73e-09)", exp (-3.73e-09), 9.99999996270000024445E-01);
check_double ("exp (2.0)", exp (2.0), 7.38905609893065040694E+00);
check_double ("exp (3.0)", exp (3.0), 2.00855369231876679237E+01);
check_double ("exp (0.7)", exp (0.7), 2.01375270747047663278E+00);
check_double ("exp (38.0)", exp (38.0), 3.18559317571137560000E+16);
check_double ("fabs (0.0)", fabs (0.0), 0.00000000000000000000E+00);
check_double ("fabs (-0.0)", fabs (-0.0), 0.00000000000000000000E+00);
check_double ("fabs (1.0)", fabs (1.0), 1.00000000000000000000E+00);
check_double ("fabs (-1.0)", fabs (-1.0), 1.00000000000000000000E+00);
check_double ("fabs (INFINITY)", fabs (INFINITY), INF);
check_double ("fabs (-INFINITY)", fabs (-INFINITY), INF);
check_double ("fabs (NAN)", fabs (NAN), NAN);
check_double ("fabs (3.14)", fabs (3.14), 3.14000000000000012434E+00);
check_double ("fabs (-3.14)", fabs (-3.14), 3.14000000000000012434E+00);
check_double ("fabs (0.7)", fabs (0.7), 6.99999999999999955591E-01);
check_double ("fabs (-0.7)", fabs (-0.7), 6.99999999999999955591E-01);
check_double ("fabs (3.72e-09)", fabs (3.72e-09), 3.71999999999999997526E-09);
check_double ("fabs (-3.72e-09)", fabs (-3.72e-09), 3.71999999999999997526E-09);
check_double ("fabs (7.37e+19)", fabs (7.37e+19), 7.37000000000000000000E+19);
check_double ("fabs (-7.37e+19)", fabs (-7.37e+19), 7.37000000000000000000E+19);
check_double ("floor (0.0)", floor (0.0), 0.00000000000000000000E+00);
check_double ("floor (-0.0)", floor (-0.0), -0.00000000000000000000E+00);
check_double ("floor (INFINITY)", floor (INFINITY), INF);
check_double ("floor (-INFINITY)", floor (-INFINITY), -INF);
check_double ("floor (NAN)", floor (NAN), NAN);
check_double ("floor (3.14)", floor (3.14), 3.00000000000000000000E+00);
check_double ("floor (-3.14)", floor (-3.14), -4.00000000000000000000E+00);
check_double ("floor (3.72e-09)", floor (3.72e-09), 0.00000000000000000000E+00);
check_double ("floor (-3.72e-09)", floor (-3.72e-09), -1.00000000000000000000E+00);
check_double ("floor (7.37e+19)", floor (7.37e+19), 7.37000000000000000000E+19);
check_double ("floor (-7.37e+19)", floor (-7.37e+19), -7.37000000000000000000E+19);
check_double ("fmod (0.0, 0.0)", fmod (0.0, 0.0), -NAN);
check_double ("fmod (0.0, -0.0)", fmod (0.0, -0.0), -NAN);
check_double ("fmod (-0.0, 0.0)", fmod (-0.0, 0.0), -NAN);
check_double ("fmod (-0.0, -0.0)", fmod (-0.0, -0.0), -NAN);
check_double ("fmod (0.0, 3.0)", fmod (0.0, 3.0), 0.00000000000000000000E+00);
check_double ("fmod (0.0, -3.0)", fmod (0.0, -3.0), 0.00000000000000000000E+00);
check_double ("fmod (-0.0, 3.0)", fmod (-0.0, 3.0), -0.00000000000000000000E+00);
check_double ("fmod (-0.0, -3.0)", fmod (-0.0, -3.0), -0.00000000000000000000E+00);
check_double ("fmod (0.0, INFINITY)", fmod (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("fmod (0.0, -INFINITY)", fmod (0.0, -INFINITY), 0.00000000000000000000E+00);
check_double ("fmod (-0.0, INFINITY)", fmod (-0.0, INFINITY), -0.00000000000000000000E+00);
check_double ("fmod (-0.0, -INFINITY)", fmod (-0.0, -INFINITY), -0.00000000000000000000E+00);
check_double ("fmod (0.0, NAN)", fmod (0.0, NAN), NAN);
check_double ("fmod (-0.0, NAN)", fmod (-0.0, NAN), NAN);
check_double ("fmod (3.0, 0.0)", fmod (3.0, 0.0), -NAN);
check_double ("fmod (3.0, -0.0)", fmod (3.0, -0.0), -NAN);
check_double ("fmod (-3.0, 0.0)", fmod (-3.0, 0.0), -NAN);
check_double ("fmod (-3.0, -0.0)", fmod (-3.0, -0.0), -NAN);
check_double ("fmod (3.0, 3.0)", fmod (3.0, 3.0), 0.00000000000000000000E+00);
check_double ("fmod (3.0, -3.0)", fmod (3.0, -3.0), 0.00000000000000000000E+00);
check_double ("fmod (-3.0, 3.0)", fmod (-3.0, 3.0), -0.00000000000000000000E+00);
check_double ("fmod (-3.0, -3.0)", fmod (-3.0, -3.0), -0.00000000000000000000E+00);
check_double ("fmod (3.0, INFINITY)", fmod (3.0, INFINITY), 3.00000000000000000000E+00);
check_double ("fmod (3.0, -INFINITY)", fmod (3.0, -INFINITY), 3.00000000000000000000E+00);
check_double ("fmod (-3.0, INFINITY)", fmod (-3.0, INFINITY), -3.00000000000000000000E+00);
check_double ("fmod (-3.0, -INFINITY)", fmod (-3.0, -INFINITY), -3.00000000000000000000E+00);
check_double ("fmod (3.0, NAN)", fmod (3.0, NAN), NAN);
check_double ("fmod (-3.0, NAN)", fmod (-3.0, NAN), NAN);
check_double ("fmod (INFINITY, 0.0)", fmod (INFINITY, 0.0), -NAN);
check_double ("fmod (INFINITY, -0.0)", fmod (INFINITY, -0.0), -NAN);
check_double ("fmod (-INFINITY, 0.0)", fmod (-INFINITY, 0.0), -NAN);
check_double ("fmod (-INFINITY, -0.0)", fmod (-INFINITY, -0.0), -NAN);
check_double ("fmod (INFINITY, 3.0)", fmod (INFINITY, 3.0), -NAN);
check_double ("fmod (INFINITY, -3.0)", fmod (INFINITY, -3.0), -NAN);
check_double ("fmod (-INFINITY, 3.0)", fmod (-INFINITY, 3.0), -NAN);
check_double ("fmod (-INFINITY, -3.0)", fmod (-INFINITY, -3.0), -NAN);
check_double ("fmod (INFINITY, INFINITY)", fmod (INFINITY, INFINITY), -NAN);
check_double ("fmod (INFINITY, -INFINITY)", fmod (INFINITY, -INFINITY), -NAN);
check_double ("fmod (-INFINITY, INFINITY)", fmod (-INFINITY, INFINITY), -NAN);
check_double ("fmod (-INFINITY, -INFINITY)", fmod (-INFINITY, -INFINITY), -NAN);
check_double ("fmod (INFINITY, NAN)", fmod (INFINITY, NAN), NAN);
check_double ("fmod (-INFINITY, NAN)", fmod (-INFINITY, NAN), NAN);
check_double ("fmod (NAN, 0.0)", fmod (NAN, 0.0), NAN);
check_double ("fmod (NAN, -0.0)", fmod (NAN, -0.0), NAN);
check_double ("fmod (NAN, 3.0)", fmod (NAN, 3.0), NAN);
check_double ("fmod (NAN, -3.0)", fmod (NAN, -3.0), NAN);
check_double ("fmod (NAN, INFINITY)", fmod (NAN, INFINITY), NAN);
check_double ("fmod (NAN, -INFINITY)", fmod (NAN, -INFINITY), NAN);
check_double ("fmod (NAN, NAN)", fmod (NAN, NAN), NAN);
check_double ("fmod (3.0, 1.0)", fmod (3.0, 1.0), 0.00000000000000000000E+00);
check_double ("fmod (3.0, -1.0)", fmod (3.0, -1.0), 0.00000000000000000000E+00);
check_double ("fmod (-3.0, 1.0)", fmod (-3.0, 1.0), -0.00000000000000000000E+00);
check_double ("fmod (-3.0, -1.0)", fmod (-3.0, -1.0), -0.00000000000000000000E+00);
check_double ("fmod (6.5, 2.3)", fmod (6.5, 2.3), 1.90000000000000035527E+00);
check_double ("fmod (6.5, -2.3)", fmod (6.5, -2.3), 1.90000000000000035527E+00);
check_double ("fmod (-6.5, 2.3)", fmod (-6.5, 2.3), -1.90000000000000035527E+00);
check_double ("fmod (-6.5, -2.3)", fmod (-6.5, -2.3), -1.90000000000000035527E+00);
check_int ("isnan (0.0)", isnan (0.0), 0);
check_int ("isnan (-0.0)", isnan (-0.0), 0);
check_int ("isnan (1.0)", isnan (1.0), 0);
check_int ("isnan (-1.0)", isnan (-1.0), 0);
check_int ("isnan (INFINITY)", isnan (INFINITY), 0);
check_int ("isnan (-INFINITY)", isnan (-INFINITY), 0);
check_int ("isnan (NAN)", isnan (NAN), 1);
check_int ("isnan (3.14)", isnan (3.14), 0);
check_int ("isnan (-3.14)", isnan (-3.14), 0);
check_int ("isnan (0.7)", isnan (0.7), 0);
check_int ("isnan (-0.7)", isnan (-0.7), 0);
check_int ("isnan (3.72e-09)", isnan (3.72e-09), 0);
check_int ("isnan (-3.72e-09)", isnan (-3.72e-09), 0);
check_int ("isnan (7.37e+19)", isnan (7.37e+19), 0);
check_int ("isnan (-7.37e+19)", isnan (-7.37e+19), 0);
check_double ("log (0.0)", log (0.0), -INF);
check_double ("log (-0.0)", log (-0.0), -INF);
check_double ("log (1.0)", log (1.0), 0.00000000000000000000E+00);
check_double ("log (-1.0)", log (-1.0), NAN);
check_double ("log (INFINITY)", log (INFINITY), INF);
check_double ("log (-INFINITY)", log (-INFINITY), NAN);
check_double ("log (NAN)", log (NAN), NAN);
check_double ("log (M_E)", log (M_E), 1.00000000000000000000E+00);
check_double ("log (1.0 / M_E)", log (1.0 / M_E), -1.00000000000000000000E+00);
check_double ("log (2)", log (2), 6.93147180559945286227E-01);
check_double ("log (10)", log (10), 2.30258509299404590109E+00);
check_double ("log (0.7)", log (0.7), -3.56674943938732447180E-01);
check_double ("log (2.22e-308)", log (2.22e-308), -7.08398701446281847893E+02);
check_double ("log (2.23e-308)", log (2.23e-308), -7.08394207056694085622E+02);
check_double ("log (0.17)", log (0.17), -1.77195684193187519284E+00);
check_double ("log (0.18)", log (0.18), -1.71479842809192661868E+00);
check_double ("log (1999.0)", log (1999.0), 7.60040233450039970364E+00);
check_double ("log (2000.0)", log (2000.0), 7.60090245954208221235E+00);
check_double ("log (2001.0)", log (2001.0), 7.60140233458373337783E+00);
check_double ("pow (0.0, 0.0)", pow (0.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (0.0, -0.0)", pow (0.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-0.0, 0.0)", pow (-0.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-0.0, -0.0)", pow (-0.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (0.0, 1.0)", pow (0.0, 1.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -1.0)", pow (0.0, -1.0), INF);
check_double ("pow (-0.0, 1.0)", pow (-0.0, 1.0), -0.00000000000000000000E+00);
check_double ("pow (-0.0, -1.0)", pow (-0.0, -1.0), -INF);
check_double ("pow (0.0, INFINITY)", pow (0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.0, -INFINITY)", pow (0.0, -INFINITY), INF);
check_double ("pow (-0.0, INFINITY)", pow (-0.0, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -INFINITY)", pow (-0.0, -INFINITY), INF);
check_double ("pow (0.0, NAN)", pow (0.0, NAN), NAN);
check_double ("pow (-0.0, NAN)", pow (-0.0, NAN), NAN);
check_double ("pow (1.0, 0.0)", pow (1.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, -0.0)", pow (1.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 0.0)", pow (-1.0, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, -0.0)", pow (-1.0, -0.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, 1.0)", pow (1.0, 1.0), 1.00000000000000000000E+00);
check_double ("pow (1.0, -1.0)", pow (1.0, -1.0), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 1.0)", pow (-1.0, 1.0), -1.00000000000000000000E+00);
check_double ("pow (-1.0, -1.0)", pow (-1.0, -1.0), -1.00000000000000000000E+00);
check_double ("pow (1.0, INFINITY)", pow (1.0, INFINITY), 1.00000000000000000000E+00);
check_double ("pow (1.0, -INFINITY)", pow (1.0, -INFINITY), 1.00000000000000000000E+00);
check_double ("pow (-1.0, INFINITY)", pow (-1.0, INFINITY), 1.00000000000000000000E+00);
check_double ("pow (-1.0, -INFINITY)", pow (-1.0, -INFINITY), 1.00000000000000000000E+00);
check_double ("pow (1.0, NAN)", pow (1.0, NAN), 1.00000000000000000000E+00);
check_double ("pow (-1.0, NAN)", pow (-1.0, NAN), NAN);
check_double ("pow (INFINITY, 0.0)", pow (INFINITY, 0.0), 1.00000000000000000000E+00);
check_double ("pow (INFINITY, -0.0)", pow (INFINITY, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-INFINITY, 0.0)", pow (-INFINITY, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-INFINITY, -0.0)", pow (-INFINITY, -0.0), 1.00000000000000000000E+00);
check_double ("pow (INFINITY, 1.0)", pow (INFINITY, 1.0), INF);
check_double ("pow (INFINITY, -1.0)", pow (INFINITY, -1.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 1.0)", pow (-INFINITY, 1.0), -INF);
check_double ("pow (-INFINITY, -1.0)", pow (-INFINITY, -1.0), -0.00000000000000000000E+00);
check_double ("pow (INFINITY, INFINITY)", pow (INFINITY, INFINITY), INF);
check_double ("pow (INFINITY, -INFINITY)", pow (INFINITY, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, INFINITY)", pow (-INFINITY, INFINITY), INF);
check_double ("pow (-INFINITY, -INFINITY)", pow (-INFINITY, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (INFINITY, NAN)", pow (INFINITY, NAN), NAN);
check_double ("pow (-INFINITY, NAN)", pow (-INFINITY, NAN), NAN);
check_double ("pow (NAN, 0.0)", pow (NAN, 0.0), 1.00000000000000000000E+00);
check_double ("pow (NAN, -0.0)", pow (NAN, -0.0), 1.00000000000000000000E+00);
check_double ("pow (NAN, 1.0)", pow (NAN, 1.0), NAN);
check_double ("pow (NAN, -1.0)", pow (NAN, -1.0), NAN);
check_double ("pow (NAN, INFINITY)", pow (NAN, INFINITY), NAN);
check_double ("pow (NAN, -INFINITY)", pow (NAN, -INFINITY), NAN);
check_double ("pow (NAN, NAN)", pow (NAN, NAN), NAN);
check_double ("pow (0.9, INFINITY)", pow (0.9, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.9, -INFINITY)", pow (0.9, -INFINITY), INF);
check_double ("pow (-0.9, INFINITY)", pow (-0.9, INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-0.9, -INFINITY)", pow (-0.9, -INFINITY), INF);
check_double ("pow (1.1, INFINITY)", pow (1.1, INFINITY), INF);
check_double ("pow (1.1, -INFINITY)", pow (1.1, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (-1.1, INFINITY)", pow (-1.1, INFINITY), INF);
check_double ("pow (-1.1, -INFINITY)", pow (-1.1, -INFINITY), 0.00000000000000000000E+00);
check_double ("pow (0.0, 2.0)", pow (0.0, 2.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -2.0)", pow (0.0, -2.0), INF);
check_double ("pow (-0.0, 2.0)", pow (-0.0, 2.0), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -2.0)", pow (-0.0, -2.0), INF);
check_double ("pow (0.0, 3.0)", pow (0.0, 3.0), 0.00000000000000000000E+00);
check_double ("pow (0.0, -3.0)", pow (0.0, -3.0), INF);
check_double ("pow (-0.0, 3.0)", pow (-0.0, 3.0), -0.00000000000000000000E+00);
check_double ("pow (-0.0, -3.0)", pow (-0.0, -3.0), -INF);
check_double ("pow (0.0, 3.14)", pow (0.0, 3.14), 0.00000000000000000000E+00);
check_double ("pow (0.0, -3.14)", pow (0.0, -3.14), INF);
check_double ("pow (-0.0, 3.14)", pow (-0.0, 3.14), 0.00000000000000000000E+00);
check_double ("pow (-0.0, -3.14)", pow (-0.0, -3.14), INF);
check_double ("pow (1.0, 3.14)", pow (1.0, 3.14), 1.00000000000000000000E+00);
check_double ("pow (1.0, -3.14)", pow (1.0, -3.14), 1.00000000000000000000E+00);
check_double ("pow (-1.0, 3.14)", pow (-1.0, 3.14), -NAN);
check_double ("pow (-1.0, -3.14)", pow (-1.0, -3.14), -NAN);
check_double ("pow (3.14, 0.0)", pow (3.14, 0.0), 1.00000000000000000000E+00);
check_double ("pow (3.14, -0.0)", pow (3.14, -0.0), 1.00000000000000000000E+00);
check_double ("pow (-3.14, 0.0)", pow (-3.14, 0.0), 1.00000000000000000000E+00);
check_double ("pow (-3.14, -0.0)", pow (-3.14, -0.0), 1.00000000000000000000E+00);
check_double ("pow (3.14, 1.0)", pow (3.14, 1.0), 3.14000000000000012434E+00);
check_double ("pow (3.14, -1.0)", pow (3.14, -1.0), 3.18471337579617819191E-01);
check_double ("pow (-3.14, 1.0)", pow (-3.14, 1.0), -3.14000000000000012434E+00);
check_double ("pow (-3.14, -1.0)", pow (-3.14, -1.0), -3.18471337579617819191E-01);
check_double ("pow (3.14, 2.0)", pow (3.14, 2.0), 9.85960000000000036380E+00);
check_double ("pow (3.14, -2.0)", pow (3.14, -2.0), 1.01423992859750899953E-01);
check_double ("pow (-3.14, 2.0)", pow (-3.14, 2.0), 9.85960000000000036380E+00);
check_double ("pow (-3.14, -2.0)", pow (-3.14, -2.0), 1.01423992859750899953E-01);
check_double ("pow (3.14, 3.0)", pow (3.14, 3.0), 3.09591440000000019950E+01);
check_double ("pow (3.14, -3.0)", pow (3.14, -3.0), 3.23006346687104775595E-02);
check_double ("pow (-3.14, 3.0)", pow (-3.14, 3.0), -3.09591440000000019950E+01);
check_double ("pow (-3.14, -3.0)", pow (-3.14, -3.0), -3.23006346687104775595E-02);
check_double ("pow (3.14, 3.14)", pow (3.14, 3.14), 3.63378388801747078674E+01);
check_double ("pow (3.14, -3.14)", pow (3.14, -3.14), 2.75195231972252124519E-02);
check_double ("pow (-3.14, 3.14)", pow (-3.14, 3.14), -NAN);
check_double ("pow (-3.14, -3.14)", pow (-3.14, -3.14), -NAN);
check_double ("pow (INFINITY, 2.0)", pow (INFINITY, 2.0), INF);
check_double ("pow (INFINITY, -2.0)", pow (INFINITY, -2.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 2.0)", pow (-INFINITY, 2.0), INF);
check_double ("pow (-INFINITY, -2.0)", pow (-INFINITY, -2.0), 0.00000000000000000000E+00);
check_double ("pow (INFINITY, 3.0)", pow (INFINITY, 3.0), INF);
check_double ("pow (INFINITY, -3.0)", pow (INFINITY, -3.0), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 3.0)", pow (-INFINITY, 3.0), -INF);
check_double ("pow (-INFINITY, -3.0)", pow (-INFINITY, -3.0), -0.00000000000000000000E+00);
check_double ("pow (INFINITY, 3.14)", pow (INFINITY, 3.14), INF);
check_double ("pow (INFINITY, -3.14)", pow (INFINITY, -3.14), 0.00000000000000000000E+00);
check_double ("pow (-INFINITY, 3.14)", pow (-INFINITY, 3.14), INF);
check_double ("pow (-INFINITY, -3.14)", pow (-INFINITY, -3.14), 0.00000000000000000000E+00);
check_double ("pow (0.7, 1.2)", pow (0.7, 1.2), 6.51804940566386381562E-01);
check_double ("sqrt (0.0)", sqrt (0.0), 0.00000000000000000000E+00);
check_double ("sqrt (-0.0)", sqrt (-0.0), -0.00000000000000000000E+00);
check_double ("sqrt (1.0)", sqrt (1.0), 1.00000000000000000000E+00);
check_double ("sqrt (-1.0)", sqrt (-1.0), -NAN);
check_double ("sqrt (INFINITY)", sqrt (INFINITY), INF);
check_double ("sqrt (-INFINITY)", sqrt (-INFINITY), -NAN);
check_double ("sqrt (NAN)", sqrt (NAN), NAN);
check_double ("sqrt (0.7)", sqrt (0.7), 8.36660026534075562665E-01);
check_double ("sqrt (2)", sqrt (2), 1.41421356237309514547E+00);
check_double ("sqrt (10)", sqrt (10), 3.16227766016837952279E+00);
check_double ("sqrt (2.22e-308)", sqrt (2.22e-308), 1.48996644257513405066E-154);
check_double ("sqrt (2.23e-308)", sqrt (2.23e-308), 1.49331845230680803391E-154);
check_double ("sqrt (3.72e-09)", sqrt (3.72e-09), 6.09918027279076225416E-05);
check_double ("sqrt (7.37e+19)", sqrt (7.37e+19), 8.58487041253390121460E+09);
check_double ("sqrt (2209)", sqrt (2209), 4.70000000000000000000E+01);
check_double ("sqrt (4)", sqrt (4), 2.00000000000000000000E+00);
check_double ("sqrt (0.25)", sqrt (0.25), 5.00000000000000000000E-01);
check_double ("sqrt (6642.25)", sqrt (6642.25), 8.15000000000000000000E+01);
check_double ("sqrt (15239.9025)", sqrt (15239.9025), 1.23450000000000002842E+02);
check_double ("sin (0.0)", sin (0.0), 0.00000000000000000000E+00);
check_double ("sin (-0.0)", sin (-0.0), -0.00000000000000000000E+00);
check_double ("sin (1.0)", sin (1.0), 8.41470984807896504876E-01);
check_double ("sin (-1.0)", sin (-1.0), -8.41470984807896504876E-01);
check_double ("sin (INFINITY)", sin (INFINITY), -NAN);
check_double ("sin (-INFINITY)", sin (-INFINITY), -NAN);
check_double ("sin (NAN)", sin (NAN), NAN);
check_double ("sin (M_PI)", sin (M_PI), 1.22464679914735320717E-16);
check_double ("sin (-M_PI)", sin (-M_PI), -1.22464679914735320717E-16);
check_double ("sin (2.0 * M_PI)", sin (2.0 * M_PI), -2.44929359829470641435E-16);
check_double ("sin (-2.0 * M_PI)", sin (-2.0 * M_PI), 2.44929359829470641435E-16);
check_double ("sin (M_PI / 2.0)", sin (M_PI / 2.0), 1.00000000000000000000E+00);
check_double ("sin (-M_PI / 2.0)", sin (-M_PI / 2.0), -1.00000000000000000000E+00);
check_double ("sin (M_PI / 3.0)", sin (M_PI / 3.0), 8.66025403784438596588E-01);
check_double ("sin (-M_PI / 3.0)", sin (-M_PI / 3.0), -8.66025403784438596588E-01);
check_double ("sin (M_PI / 4.0)", sin (M_PI / 4.0), 7.07106781186547461715E-01);
check_double ("sin (-M_PI / 4.0)", sin (-M_PI / 4.0), -7.07106781186547461715E-01);
check_double ("sin (M_PI / 6.0)", sin (M_PI / 6.0), 4.99999999999999944489E-01);
check_double ("sin (-M_PI / 6.0)", sin (-M_PI / 6.0), -4.99999999999999944489E-01);
check_double ("sin (M_PI * 2.0 / 3.0)", sin (M_PI * 2.0 / 3.0), 8.66025403784438707611E-01);
check_double ("sin (-M_PI * 2.0 / 3.0)", sin (-M_PI * 2.0 / 3.0), -8.66025403784438707611E-01);
check_double ("sin (M_PI * 5.0 / 6.0)", sin (M_PI * 5.0 / 6.0), 4.99999999999999944489E-01);
check_double ("sin (-M_PI * 5.0 / 6.0)", sin (-M_PI * 5.0 / 6.0), -4.99999999999999944489E-01);
check_double ("sin (6.9e-18)", sin (6.9e-18), 6.90000000000000026253E-18);
check_double ("sin (-6.9e-18)", sin (-6.9e-18), -6.90000000000000026253E-18);
check_double ("sin (7.0e-18)", sin (7.0e-18), 6.99999999999999973042E-18);
check_double ("sin (-7.0e-18)", sin (-7.0e-18), -6.99999999999999973042E-18);
check_double ("sin (7.4e-9)", sin (7.4e-9), 7.40000000000000008865E-09);
check_double ("sin (-7.4e-9)", sin (-7.4e-9), -7.40000000000000008865E-09);
check_double ("sin (7.5e-9)", sin (7.5e-9), 7.49999999999999932974E-09);
check_double ("sin (-7.5e-9)", sin (-7.5e-9), -7.49999999999999932974E-09);
check_double ("sin (0.2)", sin (0.2), 1.98669330795061216399E-01);
check_double ("sin (-0.2)", sin (-0.2), -1.98669330795061216399E-01);
check_double ("sin (0.4)", sin (0.4), 3.89418342308650522465E-01);
check_double ("sin (-0.4)", sin (-0.4), -3.89418342308650522465E-01);
check_double ("sin (0.7)", sin (0.7), 6.44217687237691016833E-01);
check_double ("sin (-0.7)", sin (-0.7), -6.44217687237691016833E-01);
check_double ("sin (0.8)", sin (0.8), 7.17356090899522791382E-01);
check_double ("sin (-0.8)", sin (-0.8), -7.17356090899522791382E-01);
check_double ("sin (3.0)", sin (3.0), 1.41120008059867213523E-01);
check_double ("sin (-3.0)", sin (-3.0), -1.41120008059867213523E-01);
check_double ("sin (4.0)", sin (4.0), -7.56802495307928202450E-01);
check_double ("sin (-4.0)", sin (-4.0), 7.56802495307928202450E-01);
check_double ("sin (6.0)", sin (6.0), -2.79415498198925860152E-01);
check_double ("sin (-6.0)", sin (-6.0), 2.79415498198925860152E-01);
check_double ("sin (7.0)", sin (7.0), 6.56986598718789061024E-01);
check_double ("sin (-7.0)", sin (-7.0), -6.56986598718789061024E-01);
check_double ("cos (0.0)", cos (0.0), 1.00000000000000000000E+00);
check_double ("cos (-0.0)", cos (-0.0), 1.00000000000000000000E+00);
check_double ("cos (1.0)", cos (1.0), 5.40302305868139765010E-01);
check_double ("cos (-1.0)", cos (-1.0), 5.40302305868139765010E-01);
check_double ("cos (INFINITY)", cos (INFINITY), -NAN);
check_double ("cos (-INFINITY)", cos (-INFINITY), -NAN);
check_double ("cos (NAN)", cos (NAN), NAN);
check_double ("cos (M_PI)", cos (M_PI), -1.00000000000000000000E+00);
check_double ("cos (-M_PI)", cos (-M_PI), -1.00000000000000000000E+00);
check_double ("cos (2.0 * M_PI)", cos (2.0 * M_PI), 1.00000000000000000000E+00);
check_double ("cos (-2.0 * M_PI)", cos (-2.0 * M_PI), 1.00000000000000000000E+00);
check_double ("cos (M_PI / 2.0)", cos (M_PI / 2.0), 6.12323399573676603587E-17);
check_double ("cos (-M_PI / 2.0)", cos (-M_PI / 2.0), 6.12323399573676603587E-17);
check_double ("cos (M_PI / 3.0)", cos (M_PI / 3.0), 5.00000000000000111022E-01);
check_double ("cos (-M_PI / 3.0)", cos (-M_PI / 3.0), 5.00000000000000111022E-01);
check_double ("cos (M_PI / 4.0)", cos (M_PI / 4.0), 7.07106781186547572737E-01);
check_double ("cos (-M_PI / 4.0)", cos (-M_PI / 4.0), 7.07106781186547572737E-01);
check_double ("cos (M_PI / 6.0)", cos (M_PI / 6.0), 8.66025403784438707611E-01);
check_double ("cos (-M_PI / 6.0)", cos (-M_PI / 6.0), 8.66025403784438707611E-01);
check_double ("cos (M_PI * 2.0 / 3.0)", cos (M_PI * 2.0 / 3.0), -4.99999999999999777955E-01);
check_double ("cos (-M_PI * 2.0 / 3.0)", cos (-M_PI * 2.0 / 3.0), -4.99999999999999777955E-01);
check_double ("cos (M_PI * 5.0 / 6.0)", cos (M_PI * 5.0 / 6.0), -8.66025403784438707611E-01);
check_double ("cos (-M_PI * 5.0 / 6.0)", cos (-M_PI * 5.0 / 6.0), -8.66025403784438707611E-01);
check_double ("cos (6.9e-18)", cos (6.9e-18), 1.00000000000000000000E+00);
check_double ("cos (-6.9e-18)", cos (-6.9e-18), 1.00000000000000000000E+00);
check_double ("cos (7.0e-18)", cos (7.0e-18), 1.00000000000000000000E+00);
check_double ("cos (-7.0e-18)", cos (-7.0e-18), 1.00000000000000000000E+00);
check_double ("cos (7.4e-9)", cos (7.4e-9), 1.00000000000000000000E+00);
check_double ("cos (-7.4e-9)", cos (-7.4e-9), 1.00000000000000000000E+00);
check_double ("cos (7.5e-9)", cos (7.5e-9), 1.00000000000000000000E+00);
check_double ("cos (-7.5e-9)", cos (-7.5e-9), 1.00000000000000000000E+00);
check_double ("cos (0.2)", cos (0.2), 9.80066577841241626246E-01);
check_double ("cos (-0.2)", cos (-0.2), 9.80066577841241626246E-01);
check_double ("cos (0.4)", cos (0.4), 9.21060994002885102816E-01);
check_double ("cos (-0.4)", cos (-0.4), 9.21060994002885102816E-01);
check_double ("cos (0.7)", cos (0.7), 7.64842187284488495003E-01);
check_double ("cos (-0.7)", cos (-0.7), 7.64842187284488495003E-01);
check_double ("cos (0.8)", cos (0.8), 6.96706709347165387136E-01);
check_double ("cos (-0.8)", cos (-0.8), 6.96706709347165387136E-01);
check_double ("cos (3.0)", cos (3.0), -9.89992496600445415211E-01);
check_double ("cos (-3.0)", cos (-3.0), -9.89992496600445415211E-01);
check_double ("cos (4.0)", cos (4.0), -6.53643620863611940486E-01);
check_double ("cos (-4.0)", cos (-4.0), -6.53643620863611940486E-01);
check_double ("cos (6.0)", cos (6.0), 9.60170286650365967240E-01);
check_double ("cos (-6.0)", cos (-6.0), 9.60170286650365967240E-01);
check_double ("cos (7.0)", cos (7.0), 7.53902254343304600859E-01);
check_double ("cos (-7.0)", cos (-7.0), 7.53902254343304600859E-01);
check_double ("tan (0.0)", tan (0.0), 0.00000000000000000000E+00);
check_double ("tan (-0.0)", tan (-0.0), -0.00000000000000000000E+00);
check_double ("tan (1.0)", tan (1.0), 1.55740772465490229237E+00);
check_double ("tan (-1.0)", tan (-1.0), -1.55740772465490229237E+00);
check_double ("tan (INFINITY)", tan (INFINITY), -NAN);
check_double ("tan (-INFINITY)", tan (-INFINITY), -NAN);
check_double ("tan (NAN)", tan (NAN), NAN);
check_double ("tan (M_PI)", tan (M_PI), -1.22464679914735320717E-16);
check_double ("tan (-M_PI)", tan (-M_PI), 1.22464679914735320717E-16);
check_double ("tan (2.0 * M_PI)", tan (2.0 * M_PI), -2.44929359829470641435E-16);
check_double ("tan (-2.0 * M_PI)", tan (-2.0 * M_PI), 2.44929359829470641435E-16);
check_double ("tan (M_PI / 2.0)", tan (M_PI / 2.0), 1.63312393531953700000E+16);
check_double ("tan (-M_PI / 2.0)", tan (-M_PI / 2.0), -1.63312393531953700000E+16);
check_double ("tan (M_PI / 3.0)", tan (M_PI / 3.0), 1.73205080756887674909E+00);
check_double ("tan (-M_PI / 3.0)", tan (-M_PI / 3.0), -1.73205080756887674909E+00);
check_double ("tan (M_PI / 4.0)", tan (M_PI / 4.0), 9.99999999999999888978E-01);
check_double ("tan (-M_PI / 4.0)", tan (-M_PI / 4.0), -9.99999999999999888978E-01);
check_double ("tan (M_PI / 6.0)", tan (M_PI / 6.0), 5.77350269189625731059E-01);
check_double ("tan (-M_PI / 6.0)", tan (-M_PI / 6.0), -5.77350269189625731059E-01);
check_double ("tan (M_PI * 2.0 / 3.0)", tan (M_PI * 2.0 / 3.0), -1.73205080756887830340E+00);
check_double ("tan (-M_PI * 2.0 / 3.0)", tan (-M_PI * 2.0 / 3.0), 1.73205080756887830340E+00);
check_double ("tan (M_PI * 5.0 / 6.0)", tan (M_PI * 5.0 / 6.0), -5.77350269189625731059E-01);
check_double ("tan (-M_PI * 5.0 / 6.0)", tan (-M_PI * 5.0 / 6.0), 5.77350269189625731059E-01);
check_double ("tan (3.7e-9)", tan (3.7e-9), 3.70000000000000004433E-09);
check_double ("tan (-3.7e-9)", tan (-3.7e-9), -3.70000000000000004433E-09);
check_double ("tan (3.8e-9)", tan (3.8e-9), 3.80000000000000011259E-09);
check_double ("tan (-3.8e-9)", tan (-3.8e-9), -3.80000000000000011259E-09);
check_double ("tan (0.6)", tan (0.6), 6.84136808341692326252E-01);
check_double ("tan (-0.6)", tan (-0.6), -6.84136808341692326252E-01);
check_double ("tan (0.7)", tan (0.7), 8.42288380463079411342E-01);
check_double ("tan (-0.7)", tan (-0.7), -8.42288380463079411342E-01);
check_double ("tan (3.0)", tan (3.0), -1.42546543074277803909E-01);
check_double ("tan (-3.0)", tan (-3.0), 1.42546543074277803909E-01);
check_double ("tan (4.0)", tan (4.0), 1.15782128234957748525E+00);
check_double ("tan (-4.0)", tan (-4.0), -1.15782128234957748525E+00);
check_double ("tan (6.0)", tan (6.0), -2.91006191384749146600E-01);
check_double ("tan (-6.0)", tan (-6.0), 2.91006191384749146600E-01);
check_double ("tan (7.0)", tan (7.0), 8.71447982724318781500E-01);
check_double ("tan (-7.0)", tan (-7.0), -8.71447982724318781500E-01);
