/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WIDGETOPERATION_H
#define WIDGETOPERATION_H

#include <QWidget>

class QPixmap;
class QLabel;
class QPushButton;

//petite classe pour les plaques avec les oprations
class WidgetOperation : public QWidget {
	Q_OBJECT
	
  public:
	WidgetOperation( QWidget *parent=0, int numW=0, int opW=0, bool cliquableW=false); //constructeur
	
	//constantes conventionnelles pour idnetifier les 4 oprations
	const static int Plus, Moins, Fois, Divise;
	
	//pixmap des oprations (pointeurs statiques car commun  tous les objets de la classe)
	static QPixmap * pixPlus, * pixMoins, * pixFois, * pixDivise, *pixVide;
	
	//indique si la plaque est cliquable ou non
	bool cliquable;
	
	//lments graphiques : une tiquette cliquable avec un pixmap de l'opration
	QLabel *lbOperation;
	QPushButton *pbOperation;
	
	int num; //numero de widget
	int op; //operation affiche
	
	void static nettoyagePixmap();
	
	public slots :
	void changeOperation(int, int); //permet de changer l'opration affiche
	void mousePressEvent();
	
	signals :
	void valeur(int,int);  //met l'opration affiche
};

#endif
