# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-oracledatabase
# USAGE
    python autonomous_databases_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = OracleDatabaseMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.autonomous_databases.begin_update(
        resource_group_name="rgopenapi",
        autonomousdatabasename="databasedb1",
        properties={
            "properties": {
                "adminPassword": "<a-password-goes-here>",
                "autonomousMaintenanceScheduleType": "Early",
                "backupRetentionPeriodInDays": 12,
                "computeCount": 56.1,
                "cpuCoreCount": 45,
                "customerContacts": [{"email": "dummyemail@microsoft.com"}],
                "dataStorageSizeInGbs": 175271,
                "dataStorageSizeInTbs": 133,
                "databaseEdition": "StandardEdition",
                "displayName": "lrdrjpyyvufnxdzpwvlkmfukpstrjftdxcejcxtnqhxqbhvtzeiokllnspotsqeggddxkjjtf",
                "isAutoScalingEnabled": True,
                "isAutoScalingForStorageEnabled": True,
                "isLocalDataGuardEnabled": True,
                "isMtlsConnectionRequired": True,
                "licenseModel": "LicenseIncluded",
                "localAdgAutoFailoverMaxDataLossLimit": 212,
                "longTermBackupSchedule": {
                    "isDisabled": True,
                    "repeatCadence": "OneTime",
                    "retentionPeriodInDays": 188,
                    "timeOfBackup": "2025-08-01T04:32:58.715Z",
                },
                "openMode": "ReadOnly",
                "peerDbId": "qmpfwtvpfvbgmulethqznsyyjlpxmyfqfanrymzqsgraavtmlqqbexpzguyqybngoupbshlzpxv",
                "permissionLevel": "Restricted",
                "role": "Primary",
                "scheduledOperationsList": [
                    {
                        "dayOfWeek": {"name": "Monday"},
                        "scheduledStartTime": "lwwvkazgmfremfwhckfb",
                        "scheduledStopTime": "hjwagzxijpiaogulmnmbuqakpqxhkjvaypjqnvbvtjddc",
                    }
                ],
                "whitelistedIps": [
                    "kfierlppwurtqrhfxwgfgrnqtmvraignzwsddwmpdijeveuevuoejfmbjvpnlrmmdflilxcwkkzvdofctsdjfxrrrwctihhnchtrouauesqbmlcqhzwnppnhrtitecenlfyshassvajukbwxudhlwixkvkgsessvshcwmleoqujeemwenhwlsccbcjnnviugzgylsxkssalqoicatcvkahogdvweymhdxboyqwhaxuzlmrdbvgbnnetobkbwygcsflzanwknlybvvzgjzjirpfrksbxwgllgfxwdflcisvxpkjecpgdaxccqkzxofedkrawvhzeabmunpykwd"
                ],
            },
            "tags": {"key9827": "bygpoqozrwfyiootncgcqq"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-09-01/AutonomousDatabases_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
