% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fastq.R
\name{getPositionQuality}
\alias{getPositionQuality}
\title{Get a data.frame with sequencing qualities per position}
\usage{
getPositionQuality(
  data,
  sequence_id = "sequence_id",
  sequence = "sequence_alignment",
  quality_num = "quality_alignment_num"
)
}
\arguments{
\item{data}{\code{data.frame} containing sequence data.}

\item{sequence_id}{column in \code{data} with sequence identifiers.}

\item{sequence}{column in \code{data} with sequence data.}

\item{quality_num}{column in \code{data} with quality scores (as
strings of numeric values, comma separated) for \code{sequence}.}
}
\value{
\code{data} with one additional field with masked sequences. The 
          name of this field is created concatenating \code{sequence} 
          and '_masked'.
}
\description{
\code{getPositionQuality} takes a data.frame with sequence quality scores 
in the form of a strings of comma separated numeric values, split the quality 
scores values by \code{","},  and returns a data.frame with the values
for each position.
}
\examples{
db <- airr::read_rearrangement(system.file("extdata", "example_quality.tsv", package="alakazam"))
fastq_file <- system.file("extdata", "example_quality.fastq", package="alakazam")
db <- readFastqDb(db, fastq_file, quality_offset=-33)
head(getPositionQuality(db))
}
\seealso{
\link{readFastqDb} and \link{maskPositionsByQuality}
}
