/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TFontChoser.h"

TFontChoser::TFontChoser(QWidget *parent)
    :QWidget(parent)
{
    fontLabel = new QLabel(this);

    fontName = new QLineEdit(this);
    fontName->setEnabled(false);
    QPalette palette;
    palette.setColor(QPalette::Base, this->palette().background().color()); 
    fontName->setPalette(palette);

    fontSelect = new QPushButton(this);
    fontSelect->setText(tr("Choose..."));

    // adding widgets to horizontal layout
    hLayout = new QHBoxLayout;
    hLayout->addWidget(fontLabel);
    hLayout->addWidget(fontName);
    hLayout->addWidget(fontSelect);

    connect(fontSelect, SIGNAL(clicked()), this, SLOT(S_SelectFont()));
}

void TFontChoser::setFont(QFont font)
{
    fontName->setFont(font);
    fontName->setText(font.family());
}

void TFontChoser::setText(QString text)
{
    fontLabel->setText(text);
}

QHBoxLayout *TFontChoser::getLayout()
{
    return hLayout;
}

QFont TFontChoser::getFont()
{
    return fontName->font();
}

void TFontChoser::S_SelectFont() // view font dialog
{
    bool ok;
	QFont font = QFontDialog::getFont(&ok, fontName->font(), this);
	
	if(ok)
	{
		//fontTimeInfo = font;
		fontName->setFont(font);
		fontName->setText(font.family());
	} 
	else 
	{
		// the user canceled the dialog; font is set to the initial
		// value, in this case Times, 12.
	}
}

