/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#ifndef _TPREVIEWPANEL_H_
#define _TPREVIEWPANEL_H_

#include <QtSvg>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <QGraphicsTextItem>
#include <QRect>
#include <QWidget>
#include <QAction>
#include <QFileDialog>
#include <QPrinter>
#include <QPrintDialog>
#include "TGraphItem.h"
#include "TBackground.h"
#include "TLogo.h"
#include "../frameStruct.h"
#include <QMessageBox>
#include <QtAlgorithms>
#include "../const.h"


class TPreviewPanel : public QGraphicsView 
{
    Q_OBJECT
public:
    TPreviewPanel(QWidget *parent = 0, Qt::WindowFlags f = 0);
    virtual ~TPreviewPanel(void);
	void menuInit();
	void addText(QString infoText, QString infoInfo);
	void addLogo();
	void removeLogo();
    void setAtributes(int otst, qreal h_proc, int space, int hor_count, QFont, QColor, QColor, QColor);
	void removeAll();
	void deleteItem(int index);
	void prepare();
	int zoomInOut(bool);
	bool saveToFile(QString path);
	void print(QPrinter &);
	void setList(QList<frameStruct*> *);
	void autoRedraw(bool);
	
	void tempSceneBorn();
	void createItems();
	
	void setItemTextPos(uint);
	void adjustItems();
	
	void setSceneAfter();
	
	void setCountHor(uint);
	void setOffset(uint);
	void setOffsetValue(uint);
	void setSpace(uint);
	void setSpaceValue(uint);
	void setScaleValue(qreal);
	void setBackgroundColor(QColor &color);
	void setBackgroundColorValue(QColor);
	void setScale(qreal);
	void setItemsStyle(int);
	void setfontMetaInfo(QFont);
	void setColorInfoText(QColor);
	void setColorInfoInfo(QColor);
	void setQuality(int);
	
	uint getOffset();
	uint getSpace();
	qreal getScale();
	int getItemStyle();
	QColor getBackgroundColor();

private slots:
	void S_ZoomInOut();

protected:

private:
    QGraphicsScene *scene;
	QGraphicsScene *tempScene;
	TBackground *backgroundRect;
    QGraphicsTextItem *infoText;
	QGraphicsTextItem *infoInfo;
    QList<TGraphItem*> *graphItems;
	QPixmap *resultPix;

	QList<frameStruct*> *listItems;
	
	TLogo *logo;
	bool logo_added;
	
	int style;
    int currentCount; // current count of items
    //int countItems; //
    qreal h_proc; // height of item (0 - 1)
    int offset; // otstup
    int borderWidth;
    int space; // space between items
    int hor_count; // how many items on horisontal
	
	int quality;
	
	QFont fontMetaInfo;
	QColor colorInfoText;
	QColor colorInfoInfo;
	QColor colorBackground;
	int h, countItems;
	int infoTextHeight; // height of text (metainfo)
	qreal currentZoom;
	
	bool autoredraw;
	
	QAction *zoomInAct, *zoomOutAct;
	
	bool isOpen;
};

#endif
