from viper import Viper, SimpleMesh
import numpy

def _clear_tests(tests, n=1000):

    coordinates = numpy.array([[0,0,0], [1,0,0], [0,1,0]], dtype='d')
    coordinates2 = numpy.array([[0,0,0], [1,0,0], [0,1,0], [1,1,0]], dtype='d')
    nodes = numpy.array([[0,1,2]],dtype='i')
    nodes2 = numpy.array([[0,1,2], [1,2,3]],dtype='i')
    mesh = SimpleMesh(coordinates, nodes)
    mesh2 = SimpleMesh(coordinates2, nodes2)
    plotter = Viper(mesh)

    if 1 in tests:
        for i in xrange(n):
            plotter.add_sphere((0.5,0.5,0.0), 0.2, 30, 20, (1,0,0))
            plotter.add_sphere((0.0,0.5,0.0), 0.2, 30, 20, (1,0,0))
            plotter.clear_spheres()

    if 2 in tests:
        for i in xrange(n):
            plotter.add_polygon(((0,0,0), (1,1,0)))
            plotter.add_polygon(((1,1,0), (1,0,0)))
            plotter.clear_polygons()

    if 3 in tests:
        plotter.add_sphere((0.0,0.5,0.0), 0.2, 30, 20, (1,0,0))
        plotter.clear_scalars()
        plotter.interactive()

    if 4 in tests:
        x = numpy.linspace(0,1, len(mesh.coordinates()))
        x2 = numpy.linspace(0,1, len(mesh2.coordinates()))
        for i in xrange(1000):
            if i%2:
                plotter.set_scalar(mesh, x)
            else:
                plotter.set_scalar(mesh2, x2)

    if 5 in tests:
        for i in xrange(1000):
            if i%2:
                plotter.set_vector(mesh, coordinates)
            else:
                plotter.set_vector(mesh2, coordinates2)


if __name__ == "__main__":
    _clear_tests([1,2,3,4,5])
    #_clear_tests([5,])
