/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.spline.BSplineCurveData;

public class BSplineUtils {
    public static int getKnotMultiplicity(float[] fArray, float f) {
        return BSplineUtils.getKnotMultiplicity(fArray, fArray.length, f);
    }

    public static int getKnotMultiplicity(float[] fArray, int n, float f) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (f == fArray[i]) {
                ++n2;
                continue;
            }
            if (f < fArray[i]) break;
        }
        return n2;
    }

    public static void interpolatePoint(BSplineCurveData bSplineCurveData, float f, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        float[] fArray2 = bSplineCurveData.controlPoints;
        if (bSplineCurveData.numWeights > 0) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (int i = 0; i < bSplineCurveData.numControlPoints; ++i) {
                double d6 = BSplineUtils.splineBlend(i, bSplineCurveData.degree, bSplineCurveData.knots, f);
                d5 = bSplineCurveData.weights[i];
                d += (double)fArray2[i * 3] * d6 * d5;
                d2 += (double)fArray2[i * 3 + 1] * d6 * d5;
                d3 += (double)fArray2[i * 3 + 2] * d6 * d5;
                d4 += d6 * d5;
            }
            if (d4 != 0.0) {
                fArray[0] = (float)(d / d5);
                fArray[1] = (float)(d2 / d5);
                fArray[2] = (float)(d3 / d5);
            } else {
                fArray[0] = (float)d;
                fArray[1] = (float)d2;
                fArray[2] = (float)d3;
            }
        } else {
            for (int i = 0; i < bSplineCurveData.numControlPoints; ++i) {
                double d7 = BSplineUtils.splineBlend(i, bSplineCurveData.degree, bSplineCurveData.knots, f);
                d += (double)fArray2[i * 3] * d7;
                d2 += (double)fArray2[i * 3 + 1] * d7;
                d3 += (double)fArray2[i * 3 + 2] * d7;
            }
            fArray[0] = (float)d;
            fArray[1] = (float)d2;
            fArray[2] = (float)d3;
        }
    }

    private static double splineBlend(int n, int n2, float[] fArray, double d) {
        double d2 = n2 == 1 ? ((double)fArray[n] <= d && d < (double)fArray[n + 1] ? 1.0 : 0.0) : (fArray[n + n2 - 1] == fArray[n] && fArray[n + n2] == fArray[n + 1] ? 0.0 : (fArray[n + n2 - 1] == fArray[n] ? ((double)fArray[n + n2] - d) / (double)(fArray[n + n2] - fArray[n + 1]) * BSplineUtils.splineBlend(n + 1, n2 - 1, fArray, d) : (fArray[n + n2] == fArray[n + 1] ? (d - (double)fArray[n]) / (double)(fArray[n + n2 - 1] - fArray[n]) * BSplineUtils.splineBlend(n, n2 - 1, fArray, d) : (d - (double)fArray[n]) / (double)(fArray[n + n2 - 1] - fArray[n]) * BSplineUtils.splineBlend(n, n2 - 1, fArray, d) + ((double)fArray[n + n2] - d) / (double)(fArray[n + n2] - fArray[n + 1]) * BSplineUtils.splineBlend(n + 1, n2 - 1, fArray, d))));
        return d2;
    }

    public static void insertKnot(BSplineCurveData bSplineCurveData, float f, BSplineCurveData bSplineCurveData2) throws IllegalArgumentException {
        int n;
        if (f < bSplineCurveData.knots[0]) {
            throw new IllegalArgumentException("Inserted knot < knot[0]");
        }
        if (f > bSplineCurveData.knots[bSplineCurveData.numKnots - 1]) {
            throw new IllegalArgumentException("Inserted knot > last knot");
        }
        int n2 = -1;
        for (n = 1; n < bSplineCurveData.numKnots && n2 == -1; ++n) {
            if (!(f < bSplineCurveData.knots[n])) continue;
            n2 = n - 1;
        }
        n = bSplineCurveData.degree;
        int n3 = (n2 - n + 1) * 3;
        int n4 = n2 * 3;
        float[] fArray = bSplineCurveData.controlPoints;
        float[] fArray2 = bSplineCurveData.knots;
        int n5 = (bSplineCurveData.numControlPoints + 1) * 3;
        if (bSplineCurveData2.controlPoints == null || bSplineCurveData2.controlPoints.length < n5) {
            bSplineCurveData2.controlPoints = new float[n5];
        }
        n5 = bSplineCurveData.numKnots + 1;
        if (bSplineCurveData2.knots == null || bSplineCurveData2.knots.length < n5) {
            bSplineCurveData2.knots = new float[n5];
        }
        bSplineCurveData2.numControlPoints = bSplineCurveData.numControlPoints + 1;
        bSplineCurveData2.numKnots = n5;
        if (n3 != 0) {
            System.arraycopy(fArray, 0, bSplineCurveData2.controlPoints, 0, n3);
            System.arraycopy(fArray2, 0, bSplineCurveData2.knots, 0, n2 + 1);
        }
        System.arraycopy(fArray, n4, bSplineCurveData2.controlPoints, n4 + 3, (n2 - n + 1) * 3);
        System.arraycopy(fArray2, n2, bSplineCurveData2.knots, n2 + 1, bSplineCurveData2.numKnots - n2 - 1);
        bSplineCurveData2.knots[n2 + 1] = f;
        int n6 = n3;
        int n7 = n2 - n + 1 + (bSplineCurveData == bSplineCurveData2 ? 1 : 0);
        for (int i = n2 - n + 1; i <= n2; ++i) {
            float f2 = (f - fArray2[n7]) / (fArray2[n7 + n] - fArray2[n7]);
            bSplineCurveData2.controlPoints[n6++] = (1.0f - f2) * fArray[(n7 - 1) * 3] + f2 * fArray[n7 * 3];
            bSplineCurveData2.controlPoints[n6++] = (1.0f - f2) * fArray[(n7 - 1) * 3 + 1] + f2 * fArray[n7 * 3 + 1];
            bSplineCurveData2.controlPoints[n6++] = (1.0f - f2) * fArray[(n7 - 1) * 3 + 2] + f2 * fArray[n7 * 3 + 2];
            ++n7;
        }
        bSplineCurveData2.degree = bSplineCurveData.degree + 1;
    }

    public static void insertKnot(BSplineCurveData bSplineCurveData, float f, int n, BSplineCurveData bSplineCurveData2) throws IllegalArgumentException {
        BSplineUtils.insertKnot(bSplineCurveData, f, n, bSplineCurveData2, null);
    }

    public static void subdivide(BSplineCurveData bSplineCurveData, float f, BSplineCurveData bSplineCurveData2, BSplineCurveData bSplineCurveData3) throws IllegalArgumentException {
        int n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("subdividing with fraction <= 0");
        }
        if (f < bSplineCurveData.knots[0]) {
            throw new IllegalArgumentException("Subdivision with fraction < knot[0]");
        }
        if (f >= bSplineCurveData.knots[bSplineCurveData.numKnots - 1]) {
            throw new IllegalArgumentException("Subdivision with fraction >= last knot");
        }
        int n2 = BSplineUtils.getKnotMultiplicity(bSplineCurveData.knots, bSplineCurveData.numKnots, f);
        int[] nArray = new int[2];
        float[][] fArray = BSplineUtils.insertKnot(bSplineCurveData, f, bSplineCurveData.degree - n2, bSplineCurveData2, nArray);
        int n3 = nArray[0];
        int n4 = bSplineCurveData.degree;
        int n5 = bSplineCurveData.numControlPoints;
        bSplineCurveData2.degree = bSplineCurveData.degree;
        bSplineCurveData3.degree = bSplineCurveData.degree;
        if (bSplineCurveData2.knots == null || bSplineCurveData2.knots.length < n3 + n4 + 1) {
            bSplineCurveData2.knots = new float[n3 + 1];
        }
        if (bSplineCurveData3.knots == null || bSplineCurveData3.knots.length < n3 + 1) {
            bSplineCurveData3.knots = new float[n3 + 1];
        }
        int n6 = 0;
        for (n = 0; n < n3; ++n) {
            bSplineCurveData2.knots[n6++] = bSplineCurveData.knots[n];
        }
        for (n = 0; n < n4 + 1; ++n) {
            bSplineCurveData2.knots[n6++] = f;
        }
        bSplineCurveData2.numKnots = n3 + n4 + 1;
        n6 = 0;
        for (n = 0; n < n4 + 1; ++n) {
            bSplineCurveData3.knots[n6++] = f;
        }
        for (n = n3; n < bSplineCurveData.numKnots; ++n) {
            bSplineCurveData3.knots[n6++] = bSplineCurveData.knots[n];
        }
        bSplineCurveData3.numKnots = n6;
        if (bSplineCurveData2.controlPoints == null || bSplineCurveData2.controlPoints.length < (n3 - n2) * 3) {
            bSplineCurveData2.controlPoints = new float[(n3 - n2) * 3];
        }
        if (bSplineCurveData3.controlPoints == null || bSplineCurveData3.controlPoints.length < (n5 + n4 - n3 - 2 * n2) * 3) {
            bSplineCurveData3.controlPoints = new float[(n5 + n4 - n3 - 2 * n2) * 3];
        }
        n6 = 0;
        int n7 = 0;
        int n8 = nArray[1];
        for (n = 0; n < n3 - n4; ++n) {
            bSplineCurveData2.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
            bSplineCurveData2.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
            bSplineCurveData2.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
        }
        for (n = 0; n < n4 - n2; ++n) {
            bSplineCurveData2.controlPoints[n6++] = fArray[n3 - n4 + n + n8][n * 3];
            bSplineCurveData2.controlPoints[n6++] = fArray[n3 - n4 + n + n8][n * 3 + 1];
            bSplineCurveData2.controlPoints[n6++] = fArray[n3 - n4 + n + n8][n * 3 + 2];
        }
        bSplineCurveData2.numControlPoints = n3 - n2;
        n6 = 0;
        for (n = n4 - n2; n > 0; --n) {
            bSplineCurveData3.controlPoints[n6++] = fArray[n3 - n2 + n8][n * 3];
            bSplineCurveData3.controlPoints[n6++] = fArray[n3 - n2 + n8][n * 3 + 1];
            bSplineCurveData3.controlPoints[n6++] = fArray[n3 - n2 + n8][n * 3 + 2];
        }
        n7 = n3 - n2 * 3;
        for (n = n3 - n2; n < bSplineCurveData.numControlPoints; ++n) {
            bSplineCurveData3.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
            bSplineCurveData3.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
            bSplineCurveData3.controlPoints[n6++] = bSplineCurveData.controlPoints[n7++];
        }
        bSplineCurveData3.numControlPoints = n5 + n4 - n3 - 2 * n2;
    }

    private static float[][] insertKnot(BSplineCurveData bSplineCurveData, float f, int n, BSplineCurveData bSplineCurveData2, int[] nArray) throws IllegalArgumentException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (f < bSplineCurveData.knots[0]) {
            throw new IllegalArgumentException("Inserted knot < knot[0]");
        }
        if (f > bSplineCurveData.knots[bSplineCurveData.numKnots - 1]) {
            throw new IllegalArgumentException("Inserted knot > last knot");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Multiplicity <= 0");
        }
        int n7 = -1;
        int n8 = 0;
        for (n6 = 1; n6 < bSplineCurveData.numKnots && n7 == -1; ++n6) {
            if (f == bSplineCurveData.knots[n6]) {
                ++n8;
                continue;
            }
            if (!(f < bSplineCurveData.knots[n6])) continue;
            n7 = n6 - 1;
        }
        if (n8 != 0) {
            n7 = n7 - n8 + 1;
        }
        if (nArray != null) {
            nArray[0] = n7;
        }
        n6 = bSplineCurveData.degree;
        int n9 = n;
        int n10 = bSplineCurveData.numControlPoints - 1;
        int n11 = bSplineCurveData.numKnots - 1;
        if (n9 + n8 > n6) {
            throw new IllegalArgumentException("Cannot add more times than degree");
        }
        float[] fArray = bSplineCurveData.controlPoints;
        float[] fArray2 = bSplineCurveData.knots;
        float[][] fArray3 = new float[n6][(n9 + 1) * 3];
        int n12 = fArray3.length - 1;
        for (n5 = n7; n5 > n7 - n6; --n5) {
            fArray3[n12][0] = fArray[n5 * 3];
            fArray3[n12][1] = fArray[n5 * 3 + 1];
            fArray3[n12][2] = fArray[n5 * 3 + 2];
            --n12;
        }
        n5 = n7 - n6;
        for (n4 = 1; n4 <= n9; ++n4) {
            for (n3 = n7 - n6 + n4; n3 < n7 - n8; ++n3) {
                float f2 = (f - fArray2[n3]) / (fArray2[n3 + n6 - n4 + 1] - fArray2[n3]);
                fArray3[n3 - n5][n4 * 3] = (1.0f - f2) * fArray3[n3 - n5 - 1][(n4 - 1) * 3] + f2 * fArray3[n3 - n5][(n4 - 1) * 3];
                fArray3[n3 - n5][n4 * 3 + 1] = (1.0f - f2) * fArray3[n3 - n5 - 1][(n4 - 1) * 3 + 1] + f2 * fArray3[n3 - n5][(n4 - 1) * 3 + 1];
                fArray3[n3 - n5][n4 * 3 + 2] = (1.0f - f2) * fArray3[n3 - n5 - 1][(n4 - 1) * 3 + 2] + f2 * fArray3[n3 - n5][(n4 - 1) * 3 + 2];
            }
        }
        n4 = bSplineCurveData.numKnots + n;
        if (bSplineCurveData2.knots == null || bSplineCurveData2.knots.length < n4) {
            bSplineCurveData2.knots = new float[n4];
        }
        bSplineCurveData2.numKnots = n4;
        System.arraycopy(fArray2, 0, bSplineCurveData2.knots, 0, n7 + 1);
        System.arraycopy(fArray2, n7, bSplineCurveData2.knots, n7 + n9, bSplineCurveData2.numKnots - n7 - n9);
        for (n3 = n7 + 1; n3 < n7 + n9; ++n3) {
            bSplineCurveData2.knots[n3] = f;
        }
        n3 = n9 + n10;
        n4 = n3 * 3;
        if (bSplineCurveData2.controlPoints == null || bSplineCurveData2.controlPoints.length < n4) {
            bSplineCurveData2.controlPoints = new float[n4];
        }
        bSplineCurveData2.numControlPoints = n3;
        if (n7 - n6 + 1 > 0) {
            System.arraycopy(fArray, 0, bSplineCurveData2.controlPoints, 0, (n7 - n6 + 1) * 3);
        }
        int n13 = bSplineCurveData2.numControlPoints * 3;
        int n14 = n7 - n6 + 3;
        int n15 = 1;
        for (n2 = n7 - n6 + 1; n2 <= n7 - n6 + n9 && n14 < n13; ++n2) {
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n15 * 3];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n15 * 3 + 1];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n15 * 3 + 2];
            ++n15;
        }
        for (n2 = n7 - n6 + n9 + 1; n2 <= n7 - n8 && n14 < n13; ++n2) {
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n9 * 3];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n9 * 3 + 1];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n2 - n5][n9 * 3 + 2];
        }
        for (n2 = n9 - 1; n2 > 0 && n14 < n13; --n2) {
            bSplineCurveData2.controlPoints[n14++] = fArray3[n7 - n8 - n5][n2 * 3];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n7 - n8 - n5][n2 * 3 + 1];
            bSplineCurveData2.controlPoints[n14++] = fArray3[n7 - n8 - n5][n2 * 3 + 2];
        }
        if (n14 < n13) {
            n2 = n13 - 3 - (n7 - n8) * 3;
            System.arraycopy(fArray, (n7 - n8) * 3, bSplineCurveData2.controlPoints, n14 + 1, n2);
        }
        if (nArray != null) {
            nArray[1] = n5;
        }
        return fArray3;
    }
}

