#!/usr/bin/python3
# encoding=utf-8
#
# Copyright 2025 Simon McVittie <smcv@debian.org>
# SPDX-License-Identifier: GPL-2.0-or-later

import os
import sys
import unittest
from pathlib import (Path)

if 'GDP_UNINSTALLED' in os.environ:
    sys.path.insert(0, str(Path(__file__).resolve().parent.parent))
    sys.path.insert(0, str(Path(__file__).resolve().parent.parent / 'runtime'))
else:
    sys.path.insert(0, '/usr/share/game-data-packager')
    sys.path.insert(0, '/usr/share/games/game-data-packager')
    sys.path.insert(0, '/usr/share/game-data-packager-runtime')
    sys.path.insert(0, '/usr/share/games/game-data-packager-runtime')

from game_data_packager.game import load_games


class IntegrationTestCase(unittest.TestCase):
    def setUp(self) -> None:
        if 'GDP_BUILDDIR' in os.environ:
            self.builddir = os.environ['GDP_BUILDDIR']
        else:
            self.builddir = Path('out').resolve()

    def test_language_codes(
        self,
    ) -> None:
        from gdp_launcher import LanguageCodes

        games = load_games('*', datadir=self.builddir)

        for (g, game) in sorted(games.items()):
            for (p, package) in sorted(game.packages.items()):
                if package.lang is not None:
                    self.assertIn(
                        package.lang,
                        LanguageCodes.__members__,
                        f'{p} language {package.lang}',
                    )

    def tearDown(self) -> None:
        pass


if __name__ == '__main__':
    from gdp_test_common import main
    main()
