# Upgrading to 3.0

## Introduction

This document lists the steps necessary to upgrade from 2.x to 3.0.

The full list of changes can be found in the [Changelog](https://github.com/florimondmanca/djangorestframework-api-key/blob/master/CHANGELOG.md).

## Steps

### 1. Upgrade your Python to 3.8+

The 3.0 release drops support for Python 3.7, which has reached EOL in June 2023.

Before upgrading, make sure you are running on Python 3.8 or above.

### 2. Review usage of `.has_object_permission()` on DRF 3.14+ with custom API key models

An implementation of `.has_object_permission()` on `BaseHasAPIKey` that was redundant with `.has_permission()` has been dropped when using Django REST Framework 3.14.0 and above.

If you are using DRF 3.14+ and have custom API key models, you will want to review any implementation of `.has_object_permission()`. Calls to `super().has_object_permission()` will now return `True` (the DRF default) instead of re-validating the API key. This is the desirable thing to do, but you may need some adjustements if you relied on the previous behavior somehow until now.

### 3. Review upgrade of API key hashes following switch to SHA512

This release brings a notable performance improvement by changing the hashing algorithm for API keys.

Hashing API keys used to be done using Django's `PASSWORD_HASHERS`. These hashers are slow by design as they're meant to deal with low-entropy strings such as user passwords. As a result, they typically added 200ms or more on every single request. On the contrary, API keys are long, randomly generated strings of ASCII characters. This means they have a high entropy, so we can get away with hashing them with a simpler — and faster — algorithm.

Consequently, version 3.0 now uses SHA512 for hashing API keys.

Limited testing has shown API key verification should be at least 10x faster on typical CPUs — although greater improvements could be observed.

The hashes of existing API keys will be transparently updated the next time `.is_valid()` is called (i.e. the next time the API key is used).

There shouldn't be any action required on your side, but you may want to test things in a staging environment out of caution.
