# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.10.8, generator: @autorest/python@6.42.1)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class KnowledgeSourceParams(_serialization.Model):
    """KnowledgeSourceParams.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBlobKnowledgeSourceParams, IndexedOneLakeKnowledgeSourceParams,
    IndexedSharePointKnowledgeSourceParams, RemoteSharePointKnowledgeSourceParams,
    SearchIndexKnowledgeSourceParams, WebKnowledgeSourceParams

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "azureBlob": "AzureBlobKnowledgeSourceParams",
            "indexedOneLake": "IndexedOneLakeKnowledgeSourceParams",
            "indexedSharePoint": "IndexedSharePointKnowledgeSourceParams",
            "remoteSharePoint": "RemoteSharePointKnowledgeSourceParams",
            "searchIndex": "SearchIndexKnowledgeSourceParams",
            "web": "WebKnowledgeSourceParams",
        }
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        """
        super().__init__(**kwargs)
        self.knowledge_source_name = knowledge_source_name
        self.include_references = include_references
        self.include_reference_source_data = include_reference_source_data
        self.always_query_source = always_query_source
        self.reranker_threshold = reranker_threshold
        self.kind: Optional[str] = None


class AzureBlobKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a azure blob knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "azureBlob"


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.knowledgebases.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.search.documents.knowledgebases.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.ErrorDetail"]] = None
        self.additional_info: Optional[list["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.search.documents.knowledgebases.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.search.documents.knowledgebases.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class IndexedOneLakeKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a indexed OneLake knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "indexedOneLake"


class IndexedSharePointKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a indexed SharePoint knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "indexedSharePoint"


class KnowledgeBaseActivityRecord(_serialization.Model):
    """Base type for activity records.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseRetrievalActivityRecord, KnowledgeBaseAgenticReasoningActivityRecord,
    KnowledgeBaseModelAnswerSynthesisActivityRecord, KnowledgeBaseModelQueryPlanningActivityRecord

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
    }

    _subtype_map = {
        "type": {
            "KnowledgeBaseRetrievalActivityRecord": "KnowledgeBaseRetrievalActivityRecord",
            "agenticReasoning": "KnowledgeBaseAgenticReasoningActivityRecord",
            "modelAnswerSynthesis": "KnowledgeBaseModelAnswerSynthesisActivityRecord",
            "modelQueryPlanning": "KnowledgeBaseModelQueryPlanningActivityRecord",
        }
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.type: Optional[str] = None
        self.elapsed_ms = elapsed_ms
        self.error = error


class KnowledgeBaseAgenticReasoningActivityRecord(KnowledgeBaseActivityRecord):  # pylint: disable=name-too-long
    """Represents an agentic reasoning activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar reasoning_tokens: The number of input tokens for agentic reasoning.
    :vartype reasoning_tokens: int
    :ivar retrieval_reasoning_effort:
    :vartype retrieval_reasoning_effort:
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "reasoning_tokens": {"key": "reasoningTokens", "type": "int"},
        "retrieval_reasoning_effort": {"key": "retrievalReasoningEffort", "type": "KnowledgeRetrievalReasoningEffort"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        reasoning_tokens: Optional[int] = None,
        retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword reasoning_tokens: The number of input tokens for agentic reasoning.
        :paramtype reasoning_tokens: int
        :keyword retrieval_reasoning_effort:
        :paramtype retrieval_reasoning_effort:
         ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, error=error, **kwargs)
        self.type: str = "agenticReasoning"
        self.reasoning_tokens = reasoning_tokens
        self.retrieval_reasoning_effort = retrieval_reasoning_effort


class KnowledgeBaseAzureBlobActivityArguments(_serialization.Model):
    """Represents the arguments the azure blob retrieval activity was run with.

    :ivar search: The search string used to query blob contents.
    :vartype search: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
    }

    def __init__(self, *, search: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword search: The search string used to query blob contents.
        :paramtype search: str
        """
        super().__init__(**kwargs)
        self.search = search


class KnowledgeBaseRetrievalActivityRecord(KnowledgeBaseActivityRecord):
    """Represents a retrieval activity record.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseAzureBlobActivityRecord, KnowledgeBaseIndexedOneLakeActivityRecord,
    KnowledgeBaseIndexedSharePointActivityRecord, KnowledgeBaseRemoteSharePointActivityRecord,
    KnowledgeBaseSearchIndexActivityRecord, KnowledgeBaseWebActivityRecord

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
    }

    _subtype_map = {
        "type": {
            "azureBlob": "KnowledgeBaseAzureBlobActivityRecord",
            "indexedOneLake": "KnowledgeBaseIndexedOneLakeActivityRecord",
            "indexedSharePoint": "KnowledgeBaseIndexedSharePointActivityRecord",
            "remoteSharePoint": "KnowledgeBaseRemoteSharePointActivityRecord",
            "searchIndex": "KnowledgeBaseSearchIndexActivityRecord",
            "web": "KnowledgeBaseWebActivityRecord",
        }
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, error=error, **kwargs)
        self.type: str = "KnowledgeBaseRetrievalActivityRecord"
        self.knowledge_source_name = knowledge_source_name
        self.query_time = query_time
        self.count = count


class KnowledgeBaseAzureBlobActivityRecord(KnowledgeBaseRetrievalActivityRecord):
    """Represents a azure blob retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar azure_blob_arguments: The azure blob arguments for the retrieval activity.
    :vartype azure_blob_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseAzureBlobActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "azure_blob_arguments": {"key": "azureBlobArguments", "type": "KnowledgeBaseAzureBlobActivityArguments"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        azure_blob_arguments: Optional["_models.KnowledgeBaseAzureBlobActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword azure_blob_arguments: The azure blob arguments for the retrieval activity.
        :paramtype azure_blob_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseAzureBlobActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "azureBlob"
        self.azure_blob_arguments = azure_blob_arguments


class KnowledgeBaseReference(_serialization.Model):
    """Base type for references.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseAzureBlobReference, KnowledgeBaseIndexedOneLakeReference,
    KnowledgeBaseIndexedSharePointReference, KnowledgeBaseRemoteSharePointReference,
    KnowledgeBaseSearchIndexReference, KnowledgeBaseWebReference

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
    }

    _subtype_map = {
        "type": {
            "azureBlob": "KnowledgeBaseAzureBlobReference",
            "indexedOneLake": "KnowledgeBaseIndexedOneLakeReference",
            "indexedSharePoint": "KnowledgeBaseIndexedSharePointReference",
            "remoteSharePoint": "KnowledgeBaseRemoteSharePointReference",
            "searchIndex": "KnowledgeBaseSearchIndexReference",
            "web": "KnowledgeBaseWebReference",
        }
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.id = id
        self.activity_source = activity_source
        self.source_data = source_data
        self.reranker_score = reranker_score


class KnowledgeBaseAzureBlobReference(KnowledgeBaseReference):
    """Represents an Azure Blob Storage document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar blob_url: The blob URL for the reference.
    :vartype blob_url: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "blob_url": {"key": "blobUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        blob_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword blob_url: The blob URL for the reference.
        :paramtype blob_url: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "azureBlob"
        self.blob_url = blob_url


class KnowledgeBaseErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class KnowledgeBaseErrorDetail(_serialization.Model):
    """The error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[KnowledgeBaseErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[KnowledgeBaseErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[list["_models.KnowledgeBaseErrorDetail"]] = None
        self.additional_info: Optional[list["_models.KnowledgeBaseErrorAdditionalInfo"]] = None


class KnowledgeBaseIndexedOneLakeActivityArguments(_serialization.Model):  # pylint: disable=name-too-long
    """Represents the arguments the indexed OneLake retrieval activity was run with.

    :ivar search: The search string used to query indexed OneLake contents.
    :vartype search: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
    }

    def __init__(self, *, search: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword search: The search string used to query indexed OneLake contents.
        :paramtype search: str
        """
        super().__init__(**kwargs)
        self.search = search


class KnowledgeBaseIndexedOneLakeActivityRecord(KnowledgeBaseRetrievalActivityRecord):  # pylint: disable=name-too-long
    """Represents a indexed OneLake retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar indexed_one_lake_arguments: The indexed OneLake arguments for the retrieval activity.
    :vartype indexed_one_lake_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseIndexedOneLakeActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "indexed_one_lake_arguments": {
            "key": "indexedOneLakeArguments",
            "type": "KnowledgeBaseIndexedOneLakeActivityArguments",
        },
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        indexed_one_lake_arguments: Optional["_models.KnowledgeBaseIndexedOneLakeActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword indexed_one_lake_arguments: The indexed OneLake arguments for the retrieval activity.
        :paramtype indexed_one_lake_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseIndexedOneLakeActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "indexedOneLake"
        self.indexed_one_lake_arguments = indexed_one_lake_arguments


class KnowledgeBaseIndexedOneLakeReference(KnowledgeBaseReference):
    """Represents an Azure Blob Storage document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar doc_url: The document URL for the reference.
    :vartype doc_url: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "doc_url": {"key": "docUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword doc_url: The document URL for the reference.
        :paramtype doc_url: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "indexedOneLake"
        self.doc_url = doc_url


class KnowledgeBaseIndexedSharePointActivityArguments(_serialization.Model):  # pylint: disable=name-too-long
    """Represents the arguments the indexed SharePoint retrieval activity was run with.

    :ivar search: The search string used to query indexed SharePoint contents.
    :vartype search: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
    }

    def __init__(self, *, search: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword search: The search string used to query indexed SharePoint contents.
        :paramtype search: str
        """
        super().__init__(**kwargs)
        self.search = search


class KnowledgeBaseIndexedSharePointActivityRecord(
    KnowledgeBaseRetrievalActivityRecord
):  # pylint: disable=name-too-long
    """Represents a indexed SharePoint retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar indexed_share_point_arguments: The indexed SharePoint arguments for the retrieval
     activity.
    :vartype indexed_share_point_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseIndexedSharePointActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "indexed_share_point_arguments": {
            "key": "indexedSharePointArguments",
            "type": "KnowledgeBaseIndexedSharePointActivityArguments",
        },
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        indexed_share_point_arguments: Optional["_models.KnowledgeBaseIndexedSharePointActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword indexed_share_point_arguments: The indexed SharePoint arguments for the retrieval
         activity.
        :paramtype indexed_share_point_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseIndexedSharePointActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "indexedSharePoint"
        self.indexed_share_point_arguments = indexed_share_point_arguments


class KnowledgeBaseIndexedSharePointReference(KnowledgeBaseReference):
    """Represents an Azure Blob Storage document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar doc_url: The document URL for the reference.
    :vartype doc_url: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "doc_url": {"key": "docUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword doc_url: The document URL for the reference.
        :paramtype doc_url: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "indexedSharePoint"
        self.doc_url = doc_url


class KnowledgeBaseMessage(_serialization.Model):
    """The natural language message style object.

    All required parameters must be populated in order to send to server.

    :ivar role: The role of the tool response.
    :vartype role: str
    :ivar content: Required.
    :vartype content:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContent]
    """

    _validation = {
        "content": {"required": True},
    }

    _attribute_map = {
        "role": {"key": "role", "type": "str"},
        "content": {"key": "content", "type": "[KnowledgeBaseMessageContent]"},
    }

    def __init__(
        self, *, content: list["_models.KnowledgeBaseMessageContent"], role: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword role: The role of the tool response.
        :paramtype role: str
        :keyword content: Required.
        :paramtype content:
         list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContent]
        """
        super().__init__(**kwargs)
        self.role = role
        self.content = content


class KnowledgeBaseMessageContent(_serialization.Model):
    """Specifies the type of the message content.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeBaseMessageImageContent, KnowledgeBaseMessageTextContent

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContentType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"image": "KnowledgeBaseMessageImageContent", "text": "KnowledgeBaseMessageTextContent"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class KnowledgeBaseMessageImageContent(KnowledgeBaseMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContentType
    :ivar image: Required.
    :vartype image:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageImageContentImage
    """

    _validation = {
        "type": {"required": True},
        "image": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "image": {"key": "image", "type": "KnowledgeBaseMessageImageContentImage"},
    }

    def __init__(self, *, image: "_models.KnowledgeBaseMessageImageContentImage", **kwargs: Any) -> None:
        """
        :keyword image: Required.
        :paramtype image:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageImageContentImage
        """
        super().__init__(**kwargs)
        self.type: str = "image"
        self.image = image


class KnowledgeBaseMessageImageContentImage(_serialization.Model):
    """KnowledgeBaseMessageImageContentImage.

    All required parameters must be populated in order to send to server.

    :ivar url: The url of the image. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: The url of the image. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class KnowledgeBaseMessageTextContent(KnowledgeBaseMessageContent):
    """Text message type.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the message. Required. Known values are: "text" and "image".
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseMessageContentType
    :ivar text: Required.
    :vartype text: str
    """

    _validation = {
        "type": {"required": True},
        "text": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "text": {"key": "text", "type": "str"},
    }

    def __init__(self, *, text: str, **kwargs: Any) -> None:
        """
        :keyword text: Required.
        :paramtype text: str
        """
        super().__init__(**kwargs)
        self.type: str = "text"
        self.text = text


class KnowledgeBaseModelAnswerSynthesisActivityRecord(KnowledgeBaseActivityRecord):  # pylint: disable=name-too-long
    """Represents an LLM answer synthesis activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar input_tokens: The number of input tokens for the LLM answer synthesis activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM answer synthesis activity.
    :vartype output_tokens: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "output_tokens": {"key": "outputTokens", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword input_tokens: The number of input tokens for the LLM answer synthesis activity.
        :paramtype input_tokens: int
        :keyword output_tokens: The number of output tokens for the LLM answer synthesis activity.
        :paramtype output_tokens: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, error=error, **kwargs)
        self.type: str = "modelAnswerSynthesis"
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens


class KnowledgeBaseModelQueryPlanningActivityRecord(KnowledgeBaseActivityRecord):  # pylint: disable=name-too-long
    """Represents an LLM query planning activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar input_tokens: The number of input tokens for the LLM query planning activity.
    :vartype input_tokens: int
    :ivar output_tokens: The number of output tokens for the LLM query planning activity.
    :vartype output_tokens: int
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "input_tokens": {"key": "inputTokens", "type": "int"},
        "output_tokens": {"key": "outputTokens", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        input_tokens: Optional[int] = None,
        output_tokens: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword input_tokens: The number of input tokens for the LLM query planning activity.
        :paramtype input_tokens: int
        :keyword output_tokens: The number of output tokens for the LLM query planning activity.
        :paramtype output_tokens: int
        """
        super().__init__(id=id, elapsed_ms=elapsed_ms, error=error, **kwargs)
        self.type: str = "modelQueryPlanning"
        self.input_tokens = input_tokens
        self.output_tokens = output_tokens


class KnowledgeBaseRemoteSharePointActivityArguments(_serialization.Model):  # pylint: disable=name-too-long
    """Represents the arguments the remote SharePoint retrieval activity was run with.

    :ivar search: The search string used to query the remote SharePoint knowledge source.
    :vartype search: str
    :ivar filter_expression_add_on: The filter expression add-on for the retrieval activity.
    :vartype filter_expression_add_on: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
        "filter_expression_add_on": {"key": "filterExpressionAddOn", "type": "str"},
    }

    def __init__(
        self, *, search: Optional[str] = None, filter_expression_add_on: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword search: The search string used to query the remote SharePoint knowledge source.
        :paramtype search: str
        :keyword filter_expression_add_on: The filter expression add-on for the retrieval activity.
        :paramtype filter_expression_add_on: str
        """
        super().__init__(**kwargs)
        self.search = search
        self.filter_expression_add_on = filter_expression_add_on


class KnowledgeBaseRemoteSharePointActivityRecord(
    KnowledgeBaseRetrievalActivityRecord
):  # pylint: disable=name-too-long
    """Represents a remote SharePoint retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar remote_share_point_arguments: The remote SharePoint arguments for the retrieval activity.
    :vartype remote_share_point_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseRemoteSharePointActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "remote_share_point_arguments": {
            "key": "remoteSharePointArguments",
            "type": "KnowledgeBaseRemoteSharePointActivityArguments",
        },
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        remote_share_point_arguments: Optional["_models.KnowledgeBaseRemoteSharePointActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword remote_share_point_arguments: The remote SharePoint arguments for the retrieval
         activity.
        :paramtype remote_share_point_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseRemoteSharePointActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "remoteSharePoint"
        self.remote_share_point_arguments = remote_share_point_arguments


class KnowledgeBaseRemoteSharePointReference(KnowledgeBaseReference):
    """Represents a remote SharePoint document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar web_url: The url the reference data originated from.
    :vartype web_url: str
    :ivar search_sensitivity_label_info: Information about the sensitivity label applied to a
     SharePoint document.
    :vartype search_sensitivity_label_info:
     ~azure.search.documents.knowledgebases.models.SharePointSensitivityLabelInfo
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "web_url": {"key": "webUrl", "type": "str"},
        "search_sensitivity_label_info": {
            "key": "searchSensitivityLabelInfo",
            "type": "SharePointSensitivityLabelInfo",
        },
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        web_url: Optional[str] = None,
        search_sensitivity_label_info: Optional["_models.SharePointSensitivityLabelInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword web_url: The url the reference data originated from.
        :paramtype web_url: str
        :keyword search_sensitivity_label_info: Information about the sensitivity label applied to a
         SharePoint document.
        :paramtype search_sensitivity_label_info:
         ~azure.search.documents.knowledgebases.models.SharePointSensitivityLabelInfo
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "remoteSharePoint"
        self.web_url = web_url
        self.search_sensitivity_label_info = search_sensitivity_label_info


class KnowledgeBaseRetrievalRequest(_serialization.Model):
    """The input contract for the retrieval request.

    :ivar messages: A list of chat message style input.
    :vartype messages: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
    :ivar intents: A list of intended queries to execute without model query planning.
    :vartype intents: list[~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntent]
    :ivar max_runtime_in_seconds: The maximum runtime in seconds.
    :vartype max_runtime_in_seconds: int
    :ivar max_output_size: Limits the maximum size of the content in the output.
    :vartype max_output_size: int
    :ivar retrieval_reasoning_effort:
    :vartype retrieval_reasoning_effort:
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
    :ivar include_activity: Indicates retrieval results should include activity information.
    :vartype include_activity: bool
    :ivar output_mode: The output configuration for this retrieval. Known values are:
     "extractiveData" and "answerSynthesis".
    :vartype output_mode: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalOutputMode
    :ivar knowledge_source_params: A list of runtime parameters for the knowledge sources.
    :vartype knowledge_source_params:
     list[~azure.search.documents.knowledgebases.models.KnowledgeSourceParams]
    """

    _attribute_map = {
        "messages": {"key": "messages", "type": "[KnowledgeBaseMessage]"},
        "intents": {"key": "intents", "type": "[KnowledgeRetrievalIntent]"},
        "max_runtime_in_seconds": {"key": "maxRuntimeInSeconds", "type": "int"},
        "max_output_size": {"key": "maxOutputSize", "type": "int"},
        "retrieval_reasoning_effort": {"key": "retrievalReasoningEffort", "type": "KnowledgeRetrievalReasoningEffort"},
        "include_activity": {"key": "includeActivity", "type": "bool"},
        "output_mode": {"key": "outputMode", "type": "str"},
        "knowledge_source_params": {"key": "knowledgeSourceParams", "type": "[KnowledgeSourceParams]"},
    }

    def __init__(
        self,
        *,
        messages: Optional[list["_models.KnowledgeBaseMessage"]] = None,
        intents: Optional[list["_models.KnowledgeRetrievalIntent"]] = None,
        max_runtime_in_seconds: Optional[int] = None,
        max_output_size: Optional[int] = None,
        retrieval_reasoning_effort: Optional["_models.KnowledgeRetrievalReasoningEffort"] = None,
        include_activity: Optional[bool] = None,
        output_mode: Optional[Union[str, "_models.KnowledgeRetrievalOutputMode"]] = None,
        knowledge_source_params: Optional[list["_models.KnowledgeSourceParams"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword messages: A list of chat message style input.
        :paramtype messages: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
        :keyword intents: A list of intended queries to execute without model query planning.
        :paramtype intents:
         list[~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntent]
        :keyword max_runtime_in_seconds: The maximum runtime in seconds.
        :paramtype max_runtime_in_seconds: int
        :keyword max_output_size: Limits the maximum size of the content in the output.
        :paramtype max_output_size: int
        :keyword retrieval_reasoning_effort:
        :paramtype retrieval_reasoning_effort:
         ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffort
        :keyword include_activity: Indicates retrieval results should include activity information.
        :paramtype include_activity: bool
        :keyword output_mode: The output configuration for this retrieval. Known values are:
         "extractiveData" and "answerSynthesis".
        :paramtype output_mode: str or
         ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalOutputMode
        :keyword knowledge_source_params: A list of runtime parameters for the knowledge sources.
        :paramtype knowledge_source_params:
         list[~azure.search.documents.knowledgebases.models.KnowledgeSourceParams]
        """
        super().__init__(**kwargs)
        self.messages = messages
        self.intents = intents
        self.max_runtime_in_seconds = max_runtime_in_seconds
        self.max_output_size = max_output_size
        self.retrieval_reasoning_effort = retrieval_reasoning_effort
        self.include_activity = include_activity
        self.output_mode = output_mode
        self.knowledge_source_params = knowledge_source_params


class KnowledgeBaseRetrievalResponse(_serialization.Model):
    """The output contract for the retrieval response.

    :ivar response:
    :vartype response: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
    :ivar activity: The activity records for tracking progress and billing implications.
    :vartype activity:
     list[~azure.search.documents.knowledgebases.models.KnowledgeBaseActivityRecord]
    :ivar references: The references for the retrieval data used in the response.
    :vartype references: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseReference]
    """

    _attribute_map = {
        "response": {"key": "response", "type": "[KnowledgeBaseMessage]"},
        "activity": {"key": "activity", "type": "[KnowledgeBaseActivityRecord]"},
        "references": {"key": "references", "type": "[KnowledgeBaseReference]"},
    }

    def __init__(
        self,
        *,
        response: Optional[list["_models.KnowledgeBaseMessage"]] = None,
        activity: Optional[list["_models.KnowledgeBaseActivityRecord"]] = None,
        references: Optional[list["_models.KnowledgeBaseReference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword response:
        :paramtype response: list[~azure.search.documents.knowledgebases.models.KnowledgeBaseMessage]
        :keyword activity: The activity records for tracking progress and billing implications.
        :paramtype activity:
         list[~azure.search.documents.knowledgebases.models.KnowledgeBaseActivityRecord]
        :keyword references: The references for the retrieval data used in the response.
        :paramtype references:
         list[~azure.search.documents.knowledgebases.models.KnowledgeBaseReference]
        """
        super().__init__(**kwargs)
        self.response = response
        self.activity = activity
        self.references = references


class KnowledgeBaseSearchIndexActivityArguments(_serialization.Model):  # pylint: disable=name-too-long
    """Represents the arguments the search index retrieval activity was run with.

    :ivar search: The search string used to query the search index.
    :vartype search: str
    :ivar filter: The filter string.
    :vartype filter: str
    :ivar source_data_fields: What fields were selected for search.
    :vartype source_data_fields:
     list[~azure.search.documents.knowledgebases.models.SearchIndexFieldReference]
    :ivar search_fields: What fields were searched against.
    :vartype search_fields:
     list[~azure.search.documents.knowledgebases.models.SearchIndexFieldReference]
    :ivar semantic_configuration_name: What semantic configuration was used from the search index.
    :vartype semantic_configuration_name: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
        "filter": {"key": "filter", "type": "str"},
        "source_data_fields": {"key": "sourceDataFields", "type": "[SearchIndexFieldReference]"},
        "search_fields": {"key": "searchFields", "type": "[SearchIndexFieldReference]"},
        "semantic_configuration_name": {"key": "semanticConfigurationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        search: Optional[str] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        source_data_fields: Optional[list["_models.SearchIndexFieldReference"]] = None,
        search_fields: Optional[list["_models.SearchIndexFieldReference"]] = None,
        semantic_configuration_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword search: The search string used to query the search index.
        :paramtype search: str
        :keyword filter: The filter string.
        :paramtype filter: str
        :keyword source_data_fields: What fields were selected for search.
        :paramtype source_data_fields:
         list[~azure.search.documents.knowledgebases.models.SearchIndexFieldReference]
        :keyword search_fields: What fields were searched against.
        :paramtype search_fields:
         list[~azure.search.documents.knowledgebases.models.SearchIndexFieldReference]
        :keyword semantic_configuration_name: What semantic configuration was used from the search
         index.
        :paramtype semantic_configuration_name: str
        """
        super().__init__(**kwargs)
        self.search = search
        self.filter = filter
        self.source_data_fields = source_data_fields
        self.search_fields = search_fields
        self.semantic_configuration_name = semantic_configuration_name


class KnowledgeBaseSearchIndexActivityRecord(KnowledgeBaseRetrievalActivityRecord):
    """Represents a search index retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar search_index_arguments: The search index arguments for the retrieval activity.
    :vartype search_index_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseSearchIndexActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "search_index_arguments": {"key": "searchIndexArguments", "type": "KnowledgeBaseSearchIndexActivityArguments"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        search_index_arguments: Optional["_models.KnowledgeBaseSearchIndexActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword search_index_arguments: The search index arguments for the retrieval activity.
        :paramtype search_index_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseSearchIndexActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "searchIndex"
        self.search_index_arguments = search_index_arguments


class KnowledgeBaseSearchIndexReference(KnowledgeBaseReference):
    """Represents an Azure Search document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar doc_key: The document key for the reference.
    :vartype doc_key: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "doc_key": {"key": "docKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        doc_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword doc_key: The document key for the reference.
        :paramtype doc_key: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "searchIndex"
        self.doc_key = doc_key


class KnowledgeBaseWebActivityArguments(_serialization.Model):
    """Represents the arguments the web retrieval activity was run with.

    :ivar search: The search string used to query the web.
    :vartype search: str
    :ivar language: The language for the retrieval activity.
    :vartype language: str
    :ivar market: The market for the retrieval activity.
    :vartype market: str
    :ivar count: The number of web results returned.
    :vartype count: int
    :ivar freshness: The freshness for the retrieval activity.
    :vartype freshness: str
    """

    _attribute_map = {
        "search": {"key": "search", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "market": {"key": "market", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "freshness": {"key": "freshness", "type": "str"},
    }

    def __init__(
        self,
        *,
        search: Optional[str] = None,
        language: Optional[str] = None,
        market: Optional[str] = None,
        count: Optional[int] = None,
        freshness: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword search: The search string used to query the web.
        :paramtype search: str
        :keyword language: The language for the retrieval activity.
        :paramtype language: str
        :keyword market: The market for the retrieval activity.
        :paramtype market: str
        :keyword count: The number of web results returned.
        :paramtype count: int
        :keyword freshness: The freshness for the retrieval activity.
        :paramtype freshness: str
        """
        super().__init__(**kwargs)
        self.search = search
        self.language = language
        self.market = market
        self.count = count
        self.freshness = freshness


class KnowledgeBaseWebActivityRecord(KnowledgeBaseRetrievalActivityRecord):
    """Represents a web retrieval activity record.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the activity record. Required.
    :vartype id: int
    :ivar type: The type of the activity record. Required.
    :vartype type: str
    :ivar elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
    :vartype elapsed_ms: int
    :ivar error: The error detail explaining why the operation failed. This property is only
     included when the activity does not succeed.
    :vartype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
    :ivar knowledge_source_name: The knowledge source for the retrieval activity.
    :vartype knowledge_source_name: str
    :ivar query_time: The query time for this retrieval activity.
    :vartype query_time: ~datetime.datetime
    :ivar count: The count of documents retrieved that were sufficiently relevant to pass the
     reranker threshold.
    :vartype count: int
    :ivar web_arguments: The web arguments for the retrieval activity.
    :vartype web_arguments:
     ~azure.search.documents.knowledgebases.models.KnowledgeBaseWebActivityArguments
    """

    _validation = {
        "id": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "int"},
        "type": {"key": "type", "type": "str"},
        "elapsed_ms": {"key": "elapsedMs", "type": "int"},
        "error": {"key": "error", "type": "KnowledgeBaseErrorDetail"},
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "query_time": {"key": "queryTime", "type": "iso-8601"},
        "count": {"key": "count", "type": "int"},
        "web_arguments": {"key": "webArguments", "type": "KnowledgeBaseWebActivityArguments"},
    }

    def __init__(
        self,
        *,
        id: int,  # pylint: disable=redefined-builtin
        elapsed_ms: Optional[int] = None,
        error: Optional["_models.KnowledgeBaseErrorDetail"] = None,
        knowledge_source_name: Optional[str] = None,
        query_time: Optional[datetime.datetime] = None,
        count: Optional[int] = None,
        web_arguments: Optional["_models.KnowledgeBaseWebActivityArguments"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the activity record. Required.
        :paramtype id: int
        :keyword elapsed_ms: The elapsed time in milliseconds for the retrieval activity.
        :paramtype elapsed_ms: int
        :keyword error: The error detail explaining why the operation failed. This property is only
         included when the activity does not succeed.
        :paramtype error: ~azure.search.documents.knowledgebases.models.KnowledgeBaseErrorDetail
        :keyword knowledge_source_name: The knowledge source for the retrieval activity.
        :paramtype knowledge_source_name: str
        :keyword query_time: The query time for this retrieval activity.
        :paramtype query_time: ~datetime.datetime
        :keyword count: The count of documents retrieved that were sufficiently relevant to pass the
         reranker threshold.
        :paramtype count: int
        :keyword web_arguments: The web arguments for the retrieval activity.
        :paramtype web_arguments:
         ~azure.search.documents.knowledgebases.models.KnowledgeBaseWebActivityArguments
        """
        super().__init__(
            id=id,
            elapsed_ms=elapsed_ms,
            error=error,
            knowledge_source_name=knowledge_source_name,
            query_time=query_time,
            count=count,
            **kwargs
        )
        self.type: str = "web"
        self.web_arguments = web_arguments


class KnowledgeBaseWebReference(KnowledgeBaseReference):
    """Represents a web document reference.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the reference. Required.
    :vartype type: str
    :ivar id: The ID of the reference. Required.
    :vartype id: str
    :ivar activity_source: The source activity ID for the reference. Required.
    :vartype activity_source: int
    :ivar source_data: Dictionary of :code:`<any>`.
    :vartype source_data: dict[str, any]
    :ivar reranker_score: The reranker score for the document reference.
    :vartype reranker_score: float
    :ivar url: The url the reference data originated from.
    :vartype url: str
    :ivar title: The title of the web document.
    :vartype title: str
    """

    _validation = {
        "type": {"required": True},
        "id": {"required": True},
        "activity_source": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "activity_source": {"key": "activitySource", "type": "int"},
        "source_data": {"key": "sourceData", "type": "{object}"},
        "reranker_score": {"key": "rerankerScore", "type": "float"},
        "url": {"key": "url", "type": "str"},
        "title": {"key": "title", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        activity_source: int,
        source_data: Optional[dict[str, Any]] = None,
        reranker_score: Optional[float] = None,
        url: Optional[str] = None,
        title: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the reference. Required.
        :paramtype id: str
        :keyword activity_source: The source activity ID for the reference. Required.
        :paramtype activity_source: int
        :keyword source_data: Dictionary of :code:`<any>`.
        :paramtype source_data: dict[str, any]
        :keyword reranker_score: The reranker score for the document reference.
        :paramtype reranker_score: float
        :keyword url: The url the reference data originated from.
        :paramtype url: str
        :keyword title: The title of the web document.
        :paramtype title: str
        """
        super().__init__(
            id=id, activity_source=activity_source, source_data=source_data, reranker_score=reranker_score, **kwargs
        )
        self.type: str = "web"
        self.url = url
        self.title = title


class KnowledgeRetrievalIntent(_serialization.Model):
    """An intended query to execute without model query planning.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeRetrievalSemanticIntent

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the intent. Required. "semantic"
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntentType
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    _subtype_map = {"type": {"semantic": "KnowledgeRetrievalSemanticIntent"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None


class KnowledgeRetrievalReasoningEffort(_serialization.Model):
    """KnowledgeRetrievalReasoningEffort.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    KnowledgeRetrievalLowReasoningEffort, KnowledgeRetrievalMediumReasoningEffort,
    KnowledgeRetrievalMinimalReasoningEffort

    All required parameters must be populated in order to send to server.

    :ivar kind: The kind of reasoning effort. Required. Known values are: "minimal", "low", and
     "medium".
    :vartype kind: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffortKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "low": "KnowledgeRetrievalLowReasoningEffort",
            "medium": "KnowledgeRetrievalMediumReasoningEffort",
            "minimal": "KnowledgeRetrievalMinimalReasoningEffort",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None


class KnowledgeRetrievalLowReasoningEffort(KnowledgeRetrievalReasoningEffort):
    """Run knowledge retrieval with low reasoning effort.

    All required parameters must be populated in order to send to server.

    :ivar kind: The kind of reasoning effort. Required. Known values are: "minimal", "low", and
     "medium".
    :vartype kind: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffortKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: str = "low"


class KnowledgeRetrievalMediumReasoningEffort(KnowledgeRetrievalReasoningEffort):
    """Run knowledge retrieval with medium reasoning effort.

    All required parameters must be populated in order to send to server.

    :ivar kind: The kind of reasoning effort. Required. Known values are: "minimal", "low", and
     "medium".
    :vartype kind: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffortKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: str = "medium"


class KnowledgeRetrievalMinimalReasoningEffort(KnowledgeRetrievalReasoningEffort):
    """Run knowledge retrieval with minimal reasoning effort.

    All required parameters must be populated in order to send to server.

    :ivar kind: The kind of reasoning effort. Required. Known values are: "minimal", "low", and
     "medium".
    :vartype kind: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalReasoningEffortKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: str = "minimal"


class KnowledgeRetrievalSemanticIntent(KnowledgeRetrievalIntent):
    """KnowledgeRetrievalSemanticIntent.

    All required parameters must be populated in order to send to server.

    :ivar type: The type of the intent. Required. "semantic"
    :vartype type: str or
     ~azure.search.documents.knowledgebases.models.KnowledgeRetrievalIntentType
    :ivar search: The semantic query to execute. Required.
    :vartype search: str
    """

    _validation = {
        "type": {"required": True},
        "search": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "search": {"key": "search", "type": "str"},
    }

    def __init__(self, *, search: str, **kwargs: Any) -> None:
        """
        :keyword search: The semantic query to execute. Required.
        :paramtype search: str
        """
        super().__init__(**kwargs)
        self.type: str = "semantic"
        self.search = search


class RemoteSharePointKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a remote SharePoint knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    :ivar filter_expression_add_on: A filter condition applied to the SharePoint data source. It
     must be specified in the Keyword Query Language syntax. It will be combined as a conjunction
     with the filter expression specified in the knowledge source definition.
    :vartype filter_expression_add_on: str
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
        "filter_expression_add_on": {"key": "filterExpressionAddOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        filter_expression_add_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        :keyword filter_expression_add_on: A filter condition applied to the SharePoint data source. It
         must be specified in the Keyword Query Language syntax. It will be combined as a conjunction
         with the filter expression specified in the knowledge source definition.
        :paramtype filter_expression_add_on: str
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "remoteSharePoint"
        self.filter_expression_add_on = filter_expression_add_on


class RequestOptions(_serialization.Model):
    """Parameter group.

    :ivar x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
    :vartype x_ms_client_request_id: str
    """

    _attribute_map = {
        "x_ms_client_request_id": {"key": "x-ms-client-request-id", "type": "str"},
    }

    def __init__(self, *, x_ms_client_request_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword x_ms_client_request_id: The tracking ID sent with the request to help with debugging.
        :paramtype x_ms_client_request_id: str
        """
        super().__init__(**kwargs)
        self.x_ms_client_request_id = x_ms_client_request_id


class SearchIndexFieldReference(_serialization.Model):
    """SearchIndexFieldReference.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SearchIndexKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a search index knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    :ivar filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
    :vartype filter_add_on: str
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
        "filter_add_on": {"key": "filterAddOn", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        filter_add_on: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        :keyword filter_add_on: A filter condition applied to the index (e.g., 'State eq VA').
        :paramtype filter_add_on: str
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "searchIndex"
        self.filter_add_on = filter_add_on


class SharePointSensitivityLabelInfo(_serialization.Model):
    """Information about the sensitivity label applied to a SharePoint document.

    :ivar display_name: The display name for the sensitivity label.
    :vartype display_name: str
    :ivar sensitivity_label_id: The ID of the sensitivity label.
    :vartype sensitivity_label_id: str
    :ivar tooltip: The tooltip that should be displayed for the label in a UI.
    :vartype tooltip: str
    :ivar priority: The priority in which the sensitivity label is applied.
    :vartype priority: int
    :ivar color: The color that the UI should display for the label, if configured.
    :vartype color: str
    :ivar is_encrypted: Indicates whether the sensitivity label enforces encryption.
    :vartype is_encrypted: bool
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "sensitivity_label_id": {"key": "sensitivityLabelId", "type": "str"},
        "tooltip": {"key": "tooltip", "type": "str"},
        "priority": {"key": "priority", "type": "int"},
        "color": {"key": "color", "type": "str"},
        "is_encrypted": {"key": "isEncrypted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        sensitivity_label_id: Optional[str] = None,
        tooltip: Optional[str] = None,
        priority: Optional[int] = None,
        color: Optional[str] = None,
        is_encrypted: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: The display name for the sensitivity label.
        :paramtype display_name: str
        :keyword sensitivity_label_id: The ID of the sensitivity label.
        :paramtype sensitivity_label_id: str
        :keyword tooltip: The tooltip that should be displayed for the label in a UI.
        :paramtype tooltip: str
        :keyword priority: The priority in which the sensitivity label is applied.
        :paramtype priority: int
        :keyword color: The color that the UI should display for the label, if configured.
        :paramtype color: str
        :keyword is_encrypted: Indicates whether the sensitivity label enforces encryption.
        :paramtype is_encrypted: bool
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.sensitivity_label_id = sensitivity_label_id
        self.tooltip = tooltip
        self.priority = priority
        self.color = color
        self.is_encrypted = is_encrypted


class WebKnowledgeSourceParams(KnowledgeSourceParams):
    """Specifies runtime parameters for a web knowledge source.

    All required parameters must be populated in order to send to server.

    :ivar knowledge_source_name: The name of the index the params apply to. Required.
    :vartype knowledge_source_name: str
    :ivar include_references: Indicates whether references should be included for data retrieved
     from this source.
    :vartype include_references: bool
    :ivar include_reference_source_data: Indicates whether references should include the structured
     data obtained during retrieval in their payload.
    :vartype include_reference_source_data: bool
    :ivar always_query_source: Indicates that this knowledge source should bypass source selection
     and always be queried at retrieval time.
    :vartype always_query_source: bool
    :ivar reranker_threshold: The reranker threshold all retrieved documents must meet to be
     included in the response.
    :vartype reranker_threshold: float
    :ivar kind: The type of the knowledge source. Required. Known values are: "searchIndex",
     "azureBlob", "web", "remoteSharePoint", "indexedSharePoint", and "indexedOneLake".
    :vartype kind: str or ~azure.search.documents.knowledgebases.models.KnowledgeSourceKind
    :ivar language: The language of the web results.
    :vartype language: str
    :ivar market: The market of the web results.
    :vartype market: str
    :ivar count: The number of web results to return.
    :vartype count: int
    :ivar freshness: The freshness of web results.
    :vartype freshness: str
    """

    _validation = {
        "knowledge_source_name": {"required": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "knowledge_source_name": {"key": "knowledgeSourceName", "type": "str"},
        "include_references": {"key": "includeReferences", "type": "bool"},
        "include_reference_source_data": {"key": "includeReferenceSourceData", "type": "bool"},
        "always_query_source": {"key": "alwaysQuerySource", "type": "bool"},
        "reranker_threshold": {"key": "rerankerThreshold", "type": "float"},
        "kind": {"key": "kind", "type": "str"},
        "language": {"key": "language", "type": "str"},
        "market": {"key": "market", "type": "str"},
        "count": {"key": "count", "type": "int"},
        "freshness": {"key": "freshness", "type": "str"},
    }

    def __init__(
        self,
        *,
        knowledge_source_name: str,
        include_references: Optional[bool] = None,
        include_reference_source_data: Optional[bool] = None,
        always_query_source: Optional[bool] = None,
        reranker_threshold: Optional[float] = None,
        language: Optional[str] = None,
        market: Optional[str] = None,
        count: Optional[int] = None,
        freshness: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword knowledge_source_name: The name of the index the params apply to. Required.
        :paramtype knowledge_source_name: str
        :keyword include_references: Indicates whether references should be included for data retrieved
         from this source.
        :paramtype include_references: bool
        :keyword include_reference_source_data: Indicates whether references should include the
         structured data obtained during retrieval in their payload.
        :paramtype include_reference_source_data: bool
        :keyword always_query_source: Indicates that this knowledge source should bypass source
         selection and always be queried at retrieval time.
        :paramtype always_query_source: bool
        :keyword reranker_threshold: The reranker threshold all retrieved documents must meet to be
         included in the response.
        :paramtype reranker_threshold: float
        :keyword language: The language of the web results.
        :paramtype language: str
        :keyword market: The market of the web results.
        :paramtype market: str
        :keyword count: The number of web results to return.
        :paramtype count: int
        :keyword freshness: The freshness of web results.
        :paramtype freshness: str
        """
        super().__init__(
            knowledge_source_name=knowledge_source_name,
            include_references=include_references,
            include_reference_source_data=include_reference_source_data,
            always_query_source=always_query_source,
            reranker_threshold=reranker_threshold,
            **kwargs
        )
        self.kind: str = "web"
        self.language = language
        self.market = market
        self.count = count
        self.freshness = freshness
