# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storage.aio import StorageManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageManagementEncryptionScopesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_scopes_put(self, resource_group):
        response = await self.client.encryption_scopes.put(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            encryption_scope={
                "creationTime": "2020-02-20 00:00:00",
                "id": "str",
                "keyVaultProperties": {
                    "currentVersionedKeyIdentifier": "str",
                    "keyUri": "str",
                    "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                },
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "requireInfrastructureEncryption": bool,
                "source": "str",
                "state": "str",
                "type": "str",
            },
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_scopes_patch(self, resource_group):
        response = await self.client.encryption_scopes.patch(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            encryption_scope={
                "creationTime": "2020-02-20 00:00:00",
                "id": "str",
                "keyVaultProperties": {
                    "currentVersionedKeyIdentifier": "str",
                    "keyUri": "str",
                    "lastKeyRotationTimestamp": "2020-02-20 00:00:00",
                },
                "lastModifiedTime": "2020-02-20 00:00:00",
                "name": "str",
                "requireInfrastructureEncryption": bool,
                "source": "str",
                "state": "str",
                "type": "str",
            },
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_scopes_get(self, resource_group):
        response = await self.client.encryption_scopes.get(
            resource_group_name=resource_group.name,
            account_name="str",
            encryption_scope_name="str",
            api_version="2025-06-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_encryption_scopes_list(self, resource_group):
        response = self.client.encryption_scopes.list(
            resource_group_name=resource_group.name,
            account_name="str",
            api_version="2025-06-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
