% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-call.R
\name{distinct.dtplyr_step}
\alias{distinct.dtplyr_step}
\title{Subset distinct/unique rows}
\usage{
\method{distinct}{dtplyr_step}(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Optional variables to
use when determining uniqueness. If there are multiple rows for a given
combination of inputs, only the first row will be preserved. If omitted,
will use all variables in the data frame.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\description{
This is a method for the dplyr \code{\link[dplyr:distinct]{dplyr::distinct()}} generic. It is translated to
\code{\link[data.table:duplicated]{data.table::unique.data.table()}}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
df <- lazy_dt(data.frame(
  x = sample(10, 100, replace = TRUE),
  y = sample(10, 100, replace = TRUE)
))

df \%>\% distinct(x)
df \%>\% distinct(x, y)
df \%>\% distinct(x, .keep_all = TRUE)
}
