% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{msg_cat}
\alias{msg_cat}
\title{Generate a message with \code{cat()}}
\usage{
msg_cat(...)
}
\arguments{
\item{...}{Character strings of messages, which will be concatenated into one
string via \code{paste(c(...), collapse = '')}.}
}
\value{
Invisible \code{NULL}, with the side-effect of printing the message.
}
\description{
This function is similar to \code{\link[=message]{message()}}, and the difference is
that \code{msg_cat()} uses \code{\link[=cat]{cat()}} to write out the message,
which is sent to \code{\link[=stdout]{stdout()}} instead of \code{\link[=stderr]{stderr()}}. The
message can be suppressed by \code{\link[=suppressMessages]{suppressMessages()}}.
}
\note{
By default, a newline will not be appended to the message. If you need
a newline, you have to explicitly add it to the message (see
\sQuote{Examples}).
}
\examples{
{
    # a message without a newline at the end
    xfun::msg_cat("Hello world!")
    # add a newline at the end
    xfun::msg_cat(" This message appears right after the previous one.\n")
}
suppressMessages(xfun::msg_cat("Hello world!"))
}
\seealso{
This function was inspired by \code{rlang::inform()}.
}
