# Contributing to Sonivox

Thank you for considering contributing to Sonivox!

## Workflow

We do not allow merge requests into the `master` branch directly. Please follow these steps:

1. Fork (and clone) the repository. If you already had a fork from previous contributions, then [sync your fork](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/syncing-a-fork) from time to time.
2. Create a new branch from `devel` for your changes.
3. Open an issue describing the contributions you plan to make.
4. Make your changes and commit them with clear commit messages.
5. Open a pull request to merge your changes into the `devel` branch.

## Coding Standards

- Follow the existing coding style.
- Write clear and concise commit messages.
- Ensure your code passes all tests.

## Pull Requests

When opening a pull request, please:
- Describe the changes you've made.
- [Link to the issue](https://docs.github.com/en/get-started/writing-on-github/working-with-advanced-formatting/using-keywords-in-issues-and-pull-requests#linking-a-pull-request-to-an-issue) describing your contributions.
- Ensure your code follows the contribution guidelines.
