/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel;

import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import rene.util.xml.XmlReader;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagPI;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.zirkel.ZirkelApplet;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;
import rene.zirkel.tools.AnimatorTool;
import rene.zirkel.tools.ObjectTracker;
import rene.zirkel.tools.Tracker;

public class DemoRunner
implements Runnable,
MouseListener {
    ZirkelCanvas ZC;
    ZirkelApplet ZA;
    boolean Stopped = false;
    boolean Continue = false;
    boolean Hold = false;
    int delay = 10;
    Label L;
    XmlTree Tree;
    AnimatorTool A;

    public DemoRunner(ZirkelCanvas zirkelCanvas, ZirkelApplet zirkelApplet, String string, Label label) {
        this.ZC = zirkelCanvas;
        this.ZA = zirkelApplet;
        this.L = label;
        try {
            URL uRL = string.toUpperCase().startsWith("HTTP") ? new URL(string) : new URL(this.ZA.getCodeBase(), string);
            InputStream inputStream = uRL.openStream();
            XmlReader xmlReader = new XmlReader();
            xmlReader.init(inputStream);
            XmlTree xmlTree = xmlReader.scan();
            Enumeration enumeration = xmlTree.getContent();
            while (enumeration.hasMoreElements()) {
                xmlTree = (XmlTree)enumeration.nextElement();
                if (xmlTree.getTag() instanceof XmlTagPI) continue;
                if (!xmlTree.getTag().name().equals("Demo")) {
                    throw new ConstructionException("Demo tag not found");
                }
                XmlTag xmlTag = xmlTree.getTag();
                if (!xmlTag.hasParam("delay")) break;
                try {
                    this.delay = Integer.parseInt(xmlTag.getValue("delay"));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            this.Tree = xmlTree;
            enumeration = xmlTree.getContent();
            if (!enumeration.hasMoreElements()) {
                return;
            }
            while (enumeration.hasMoreElements()) {
                xmlTree = (XmlTree)enumeration.nextElement();
                if (xmlTree.getTag().name().equals("File")) continue;
                throw new ConstructionException("Illegal tag " + xmlTree.getTag().name());
            }
            inputStream.close();
        }
        catch (ConstructionException constructionException) {
            label.setText(constructionException.toString());
        }
        catch (Exception exception) {
            label.setText("Error loading " + string);
        }
        zirkelCanvas.addMouseListener(this);
        new Thread(this).start();
    }

    public void run() {
        Enumeration enumeration = this.Tree.getContent();
        this.ZC.setFrozen(true);
        while (true) {
            this.Continue = false;
            int n = this.delay;
            if (enumeration.hasMoreElements()) {
                try {
                    XmlTree xmlTree = (XmlTree)enumeration.nextElement();
                    XmlTag xmlTag = xmlTree.getTag();
                    String string = xmlTag.getValue("name");
                    URL uRL = string.toUpperCase().startsWith("HTTP") ? new URL(string) : new URL(this.ZA.getCodeBase(), string);
                    InputStream inputStream = uRL.openStream();
                    this.ZC.clearMacros();
                    this.ZC.load(inputStream);
                    inputStream.close();
                    this.ZC.recompute();
                    if (xmlTag.hasParam("delay")) {
                        try {
                            this.delay = Integer.parseInt(xmlTag.getValue("delay"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Enumeration enumeration2 = xmlTree.getContent();
                    while (enumeration2.hasMoreElements()) {
                        xmlTree = (XmlTree)enumeration2.nextElement();
                        if (!(xmlTree.getTag() instanceof XmlTagText)) continue;
                        this.L.setText(((XmlTagText)xmlTree.getTag()).getContent());
                    }
                    this.startZC();
                }
                catch (Exception exception) {
                    this.L.setText("Error loading file!");
                }
                try {
                    for (int i = 0; i < this.delay * 2 || this.Hold; ++i) {
                        Thread.sleep(500L);
                        if (i == 0) {
                            this.ZC.setFrozen(false);
                            this.ZC.repaint();
                        }
                        if (this.Stopped) {
                            return;
                        }
                        if (!this.Continue) continue;
                        this.Hold = false;
                        break;
                    }
                    this.ZC.setFrozen(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.delay = n;
                continue;
            }
            enumeration = this.Tree.getContent();
        }
    }

    public void startZC() {
        block17: {
            Construction construction = this.ZC.getConstruction();
            this.ZC.setInteractive(false);
            if (construction.TrackP != null) {
                try {
                    ConstructionObject constructionObject;
                    ConstructionObject constructionObject2 = construction.find(construction.TrackP);
                    if (!(constructionObject2 instanceof PointObject) && !(constructionObject2 instanceof PrimitiveLineObject)) {
                        throw new ConstructionException("");
                    }
                    ConstructionObject[] constructionObjectArray = new ConstructionObject[construction.TrackPO.size()];
                    for (int i = 0; i < constructionObjectArray.length; ++i) {
                        constructionObject = construction.find((String)construction.TrackPO.elementAt(i));
                        if (constructionObject == null || !(constructionObject instanceof PointObject) && !(constructionObject instanceof PrimitiveLineObject) && !(constructionObject instanceof PointObject)) {
                            throw new ConstructionException("");
                        }
                        constructionObjectArray[i] = constructionObject;
                    }
                    PointObject pointObject = (PointObject)construction.find(construction.TrackPM);
                    if (construction.TrackO != null) {
                        constructionObject = construction.find(construction.TrackO);
                        if (constructionObject2 == null || pointObject == null || constructionObject == null) {
                            throw new ConstructionException("");
                        }
                        ObjectTracker objectTracker = new ObjectTracker(constructionObject2, pointObject, constructionObject, this.ZC, construction.Animate, construction.Paint, constructionObjectArray);
                        if (construction.Animate) {
                            objectTracker.Interactive = false;
                        }
                        objectTracker.setOmit(construction.Omit);
                        this.ZC.setTool(objectTracker);
                        this.ZC.allowRightMouse(false);
                        this.ZC.validate();
                        this.ZC.repaint();
                        break block17;
                    }
                    if (constructionObject2 == null) {
                        throw new ConstructionException("");
                    }
                    this.ZC.setTool(new Tracker(constructionObject2, constructionObjectArray));
                    if (pointObject != null) {
                        pointObject.setSelected(true);
                    }
                    this.ZC.validate();
                    this.ZC.repaint();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (construction.AnimateP != null) {
                try {
                    PointObject pointObject = (PointObject)construction.find(construction.AnimateP);
                    if (pointObject == null || !pointObject.moveable()) {
                        throw new ConstructionException("");
                    }
                    Enumeration enumeration = construction.AnimateV.elements();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        ConstructionObject constructionObject = construction.find(string);
                        if (constructionObject != null && (constructionObject instanceof SegmentObject || constructionObject instanceof PrimitiveCircleObject || constructionObject instanceof PointObject)) continue;
                        throw new ConstructionException("");
                    }
                    this.A = new AnimatorTool(pointObject, construction.AnimateV, this.ZC, construction.AnimateNegative, construction.AnimateOriginal, construction.AnimateDelay);
                    this.ZC.setTool(this.A);
                    this.ZC.allowRightMouse(false);
                    this.A.setInteractive(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.ZC.repaint();
    }

    public void stop() {
        this.Stopped = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isMetaDown()) {
            this.Hold = true;
        } else {
            this.Continue = true;
        }
    }
}

