/*** The ICMD Table ***/

/* IMPORTANT: This file must be in a fixed format, as it is both included in */
/* src/vm/jit/jit.c, and parsed by src/vm/jit/verify/generate.pl!            */
/*                                                                           */
/* The comments at the start of the line and inside the braces are           */
/* significant. If you want to add a comment to an ICMD, do that after the   */
/* comma, or brace, at the end of the line.                                  */
/*                                                                           */
/* The format is as follows (slashes reversed for obvious reasons):          */
/*                                                                           */
/* \*#*\ { N( name )  data-flow, control-flow, flags \* stage (action) *\ }  */
/*                                                                           */
/*  ^^^                                                                      */
/* opcode                                                                    */
/*                                                                           */
/* where                                                                     */
/*     opcode...........is the opcode number (decimal)                       */
/*     name.............is the quoted name without the ICMD_ prefix          */
/*     data-flow........is one of the DF_ constants (see jit.h)              */
/*     control-flow.....is one of the CF_ constants (see jit.h)              */
/*     flags............is 0 or a |-combination of                           */
/*                          PEI........may throw an exception                */
/*                          CALLS......needs saved registers (calls out)     */
/*                          *_CALLS....see jit.h for architecture specific   */
/*                                     constants to put here                 */
/*                                                                           */
/*     stage............is either empty, or one of                           */
/*                          --         ICMD is not used anywhere after parse */
/*                          -S         ICMD is eliminated by stack_analyse   */
/*                          S+         ICMD is introduced by stack_analyse   */
/*                                                                           */
/*     action...........is the stack action of the ICMD in the notation      */
/*                      instack--outstack, TOS being rightmost.              */
/*                                                                           */
/*                      Valid type characters are                            */
/*                          I, L, F, D, and A      the basic types           */
/*                          1                      a category 1 type         */
/*                          2                      a category 2 type         */
/*                          .                      variable number of slots  */
/*                                                                           */
/*                      Whitespace is not allowed within the action.         */
/*                                                                           */
/*                      Some ICMDs may have several variants. In this case   */
/*                      the action is build by joining the individual        */
/*                      actions of the variants with |.                      */
/*                                                                           */
/*                                                                           */
/* CAUTION: Do not use preprocessor directives in this file! They will       */
/*          confuse the generator.                                           */
/*                                                                           */


/*  0*/ {N("NOP            ") DF_0_TO_0 , CF_NORMAL, 0              /*    (--)                 */},
/*  1*/ {N("ACONST         ") DF_0_TO_1 , CF_NORMAL, PEI            /*    (--A)                */},
/*  2*/ {N("CHECKNULL      ") DF_1_TO_1 , CF_NORMAL, PEI            /*    (A--A)               */},
/*  3*/ {N("ICONST         ") DF_0_TO_1 , CF_NORMAL, 0              /*    (--I)                */},
/*  4*/ {N("UNDEF4         ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*  5*/ {N("IDIVPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/*  6*/ {N("LDIVPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/*  7*/ {N("UNDEF7         ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*  8*/ {N("UNDEF8         ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*  9*/ {N("LCONST         ") DF_0_TO_1 , CF_NORMAL, 0              /*    (--L)                */},
/* 10*/ {N("LCMPCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--I)               */},
/* 11*/ {N("FCONST         ") DF_0_TO_1 , CF_NORMAL, 0              /*    (--F)                */},
/* 12*/ {N("UNDEF12        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 13*/ {N("UNDEF13        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 14*/ {N("DCONST         ") DF_0_TO_1 , CF_NORMAL, 0              /*    (--D)                */},
/* 15*/ {N("COPY           ") DF_COPY   , CF_NORMAL, 0              /* S+ (1--1)               */},
/* 16*/ {N("MOVE           ") DF_MOVE   , CF_NORMAL, 0              /* S+ (1--1)               */},
/* 17*/ {N("UNDEF17        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 18*/ {N("UNDEF18        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 19*/ {N("UNDEF19        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 20*/ {N("UNDEF20        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 21*/ {N("ILOAD          ") DF_LOAD   , CF_NORMAL, 0              /*    (--I)                */},
/* 22*/ {N("LLOAD          ") DF_LOAD   , CF_NORMAL, 0              /*    (--L)                */},
/* 23*/ {N("FLOAD          ") DF_LOAD   , CF_NORMAL, 0              /*    (--F)                */},
/* 24*/ {N("DLOAD          ") DF_LOAD   , CF_NORMAL, 0              /*    (--D)                */},
/* 25*/ {N("ALOAD          ") DF_LOAD   , CF_NORMAL, 0              /*    (--A)                */},
/* 26*/ {N("IADDCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 27*/ {N("ISUBCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 28*/ {N("IMULCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 29*/ {N("IANDCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 30*/ {N("IORCONST       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 31*/ {N("IXORCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 32*/ {N("ISHLCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 33*/ {N("ISHRCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 34*/ {N("IUSHRCONST     ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 35*/ {N("IREMPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/* 36*/ {N("LADDCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 37*/ {N("LSUBCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 38*/ {N("LMULCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 39*/ {N("LANDCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 40*/ {N("LORCONST       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 41*/ {N("LXORCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 42*/ {N("LSHLCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 43*/ {N("LSHRCONST      ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 44*/ {N("LUSHRCONST     ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 45*/ {N("LREMPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/* 46*/ {N("IALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--I)              */},
/* 47*/ {N("LALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--L)              */},
/* 48*/ {N("FALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--F)              */},
/* 49*/ {N("DALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--D)              */},
/* 50*/ {N("AALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--A)              */},
/* 51*/ {N("BALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--I)              */},
/* 52*/ {N("CALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--I)              */},
/* 53*/ {N("SALOAD         ") DF_2_TO_1 , CF_NORMAL, PEI            /*    (AI--I)              */},
/* 54*/ {N("ISTORE         ") DF_STORE  , CF_NORMAL, 0              /*    (I--)                */},
/* 55*/ {N("LSTORE         ") DF_STORE  , CF_NORMAL, 0              /*    (L--)                */},
/* 56*/ {N("FSTORE         ") DF_STORE  , CF_NORMAL, 0              /*    (F--)                */},
/* 57*/ {N("DSTORE         ") DF_STORE  , CF_NORMAL, 0              /*    (D--)                */},
/* 58*/ {N("ASTORE         ") DF_STORE  , CF_NORMAL, 0              /*    (A--|R--)            */},
/* 59*/ {N("IF_LEQ         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 60*/ {N("IF_LNE         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 61*/ {N("IF_LLT         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 62*/ {N("IF_LGE         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 63*/ {N("IF_LGT         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 64*/ {N("IF_LLE         ") DF_1_TO_0 , CF_IF    , 0              /* S+ (L--)                */},
/* 65*/ {N("IF_LCMPEQ      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 66*/ {N("IF_LCMPNE      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 67*/ {N("IF_LCMPLT      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 68*/ {N("IF_LCMPGE      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 69*/ {N("IF_LCMPGT      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 70*/ {N("IF_LCMPLE      ") DF_2_TO_0 , CF_IF    , 0              /* S+ (LL--)               */},
/* 71*/ {N("UNDEF71        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 72*/ {N("UNDEF72        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 73*/ {N("UNDEF73        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 74*/ {N("UNDEF74        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 75*/ {N("UNDEF75        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 76*/ {N("UNDEF76        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 77*/ {N("UNDEF77        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 78*/ {N("UNDEF78        ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/* 79*/ {N("IASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AII--)              */},
/* 80*/ {N("LASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AIL--)              */},
/* 81*/ {N("FASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AIF--)              */},
/* 82*/ {N("DASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AID--)              */},
/* 83*/ {N("AASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI|CALLS      /*    (AIA--)              */},
/* 84*/ {N("BASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AII--)              */},
/* 85*/ {N("CASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AII--)              */},
/* 86*/ {N("SASTORE        ") DF_3_TO_0 , CF_NORMAL, PEI            /*    (AII--)              */},
/* 87*/ {N("POP            ") DF_POP    , CF_NORMAL, 0              /*    (1--)                */},
/* 88*/ {N("POP2           ") DF_POP2   , CF_NORMAL, 0              /*    (11--|2--)           */},
/* 89*/ {N("DUP            ") DF_DUP    , CF_NORMAL, 0              /* -S (1--11)              */},
/* 90*/ {N("DUP_X1         ") DF_DUP_X1 , CF_NORMAL, 0              /* -S (11--111)            */},
/* 91*/ {N("DUP_X2         ") DF_DUP_X2 , CF_NORMAL, 0              /* -S (111--1111|21--121)  */},
/* 92*/ {N("DUP2           ") DF_DUP2   , CF_NORMAL, 0              /* -S (11--1111|2--22)     */},
/* 93*/ {N("DUP2_X1        ") DF_DUP2_X1, CF_NORMAL, 0              /* -S (111--11111|12--212) */},
/* 94*/ {N("DUP2_X2        ") DF_DUP2_X2, CF_NORMAL, 0              /* -S (1111--111111|112--2112|22--222|211--11211) */},
/* 95*/ {N("SWAP           ") DF_SWAP   , CF_NORMAL, 0              /* -S (11--11)             */},
/* 96*/ {N("IADD           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/* 97*/ {N("LADD           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/* 98*/ {N("FADD           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--F)              */},
/* 99*/ {N("DADD           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--D)              */},
/*100*/ {N("ISUB           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*101*/ {N("LSUB           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/*102*/ {N("FSUB           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--F)              */},
/*103*/ {N("DSUB           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--D)              */},
/*104*/ {N("IMUL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*105*/ {N("LMUL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/*106*/ {N("FMUL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--F)              */},
/*107*/ {N("DMUL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--D)              */},
/*108*/ {N("IDIV           ") DF_2_TO_1 , CF_NORMAL, PEI|IDIV_CALLS /*    (II--I)              */},
/*109*/ {N("LDIV           ") DF_2_TO_1 , CF_NORMAL, PEI|LDIV_CALLS /*    (LL--L)              */},
/*110*/ {N("FDIV           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--F)              */},
/*111*/ {N("DDIV           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--D)              */},
/*112*/ {N("IREM           ") DF_2_TO_1 , CF_NORMAL, PEI|IDIV_CALLS /*    (II--I)              */},
/*113*/ {N("LREM           ") DF_2_TO_1 , CF_NORMAL, PEI|LDIV_CALLS /*    (LL--L)              */},
/*114*/ {N("FREM           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--F)              */},
/*115*/ {N("DREM           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--D)              */},
/*116*/ {N("INEG           ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--I)               */},
/*117*/ {N("LNEG           ") DF_1_TO_1 , CF_NORMAL, 0              /*    (L--L)               */},
/*118*/ {N("FNEG           ") DF_1_TO_1 , CF_NORMAL, 0              /*    (F--F)               */},
/*119*/ {N("DNEG           ") DF_1_TO_1 , CF_NORMAL, 0              /*    (D--D)               */},
/*120*/ {N("ISHL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*121*/ {N("LSHL           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LI--L)              */},
/*122*/ {N("ISHR           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*123*/ {N("LSHR           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LI--L)              */},
/*124*/ {N("IUSHR          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*125*/ {N("LUSHR          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LI--L)              */},
/*126*/ {N("IAND           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*127*/ {N("LAND           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/*128*/ {N("IOR            ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*129*/ {N("LOR            ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/*130*/ {N("IXOR           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (II--I)              */},
/*131*/ {N("LXOR           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--L)              */},
/*132*/ {N("IINC           ") DF_IINC   , CF_NORMAL, 0              /*    (--)                 */},
/*133*/ {N("I2L            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--L)               */},
/*134*/ {N("I2F            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--F)               */},
/*135*/ {N("I2D            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--D)               */},
/*136*/ {N("L2I            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (L--I)               */},
/*137*/ {N("L2F            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (L--F)               */},
/*138*/ {N("L2D            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (L--D)               */},
/*139*/ {N("F2I            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (F--I)               */},
/*140*/ {N("F2L            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (F--L)               */},
/*141*/ {N("F2D            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (F--D)               */},
/*142*/ {N("D2I            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (D--I)               */},
/*143*/ {N("D2L            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (D--L)               */},
/*144*/ {N("D2F            ") DF_1_TO_1 , CF_NORMAL, 0              /*    (D--F)               */},
/*145*/ {N("INT2BYTE       ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--I)               */},
/*146*/ {N("INT2CHAR       ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--I)               */},
/*147*/ {N("INT2SHORT      ") DF_1_TO_1 , CF_NORMAL, 0              /*    (I--I)               */},
/*148*/ {N("LCMP           ") DF_2_TO_1 , CF_NORMAL, 0              /*    (LL--I)              */},
/*149*/ {N("FCMPL          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--I)              */},
/*150*/ {N("FCMPG          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (FF--I)              */},
/*151*/ {N("DCMPL          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--I)              */},
/*152*/ {N("DCMPG          ") DF_2_TO_1 , CF_NORMAL, 0              /*    (DD--I)              */},
/*153*/ {N("IFEQ           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*154*/ {N("IFNE           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*155*/ {N("IFLT           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*156*/ {N("IFGE           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*157*/ {N("IFGT           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*158*/ {N("IFLE           ") DF_1_TO_0 , CF_IF    , 0              /*    (I--)                */},
/*159*/ {N("IF_ICMPEQ      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*160*/ {N("IF_ICMPNE      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*161*/ {N("IF_ICMPLT      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*162*/ {N("IF_ICMPGE      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*163*/ {N("IF_ICMPGT      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*164*/ {N("IF_ICMPLE      ") DF_2_TO_0 , CF_IF    , 0              /*    (II--)               */},
/*165*/ {N("IF_ACMPEQ      ") DF_2_TO_0 , CF_IF    , 0              /*    (AA--)               */},
/*166*/ {N("IF_ACMPNE      ") DF_2_TO_0 , CF_IF    , 0              /*    (AA--)               */},
/*167*/ {N("GOTO           ") DF_0_TO_0 , CF_GOTO  , 0              /*    (--)                 */},
/*168*/ {N("JSR            ") DF_0_TO_1 , CF_JSR   , 0              /*    (--R)                */},
/*169*/ {N("RET            ") DF_0_TO_0 , CF_RET   , 0              /*    (--)                 */},
/*170*/ {N("TABLESWITCH    ") DF_1_TO_0 , CF_TABLE , 0              /*    (I--)                */},
/*171*/ {N("LOOKUPSWITCH   ") DF_1_TO_0 , CF_LOOKUP, 0              /*    (I--)                */},
/*172*/ {N("IRETURN        ") DF_1_TO_0 , CF_END   , 0              /*    (I--)                */},
/*173*/ {N("LRETURN        ") DF_1_TO_0 , CF_END   , 0              /*    (L--)                */},
/*174*/ {N("FRETURN        ") DF_1_TO_0 , CF_END   , 0              /*    (F--)                */},
/*175*/ {N("DRETURN        ") DF_1_TO_0 , CF_END   , 0              /*    (D--)                */},
/*176*/ {N("ARETURN        ") DF_1_TO_0 , CF_END   , PEI            /*    (A--)                */},
/*177*/ {N("RETURN         ") DF_0_TO_0 , CF_END   , 0              /*    (--)                 */},
/*178*/ {N("GETSTATIC      ") DF_0_TO_1 , CF_NORMAL, PEI            /*    (--1|--2)            */},
/*179*/ {N("PUTSTATIC      ") DF_1_TO_0 , CF_NORMAL, PEI            /*    (1--|2--)            */},
/*180*/ {N("GETFIELD       ") DF_1_TO_1 , CF_NORMAL, PEI            /*    (A--1|A--2)          */},
/*181*/ {N("PUTFIELD       ") DF_2_TO_0 , CF_NORMAL, PEI            /*    (A1--|A2--)          */},
/*182*/ {N("INVOKEVIRTUAL  ") DF_INVOKE , CF_NORMAL, PEI|CALLS      /*    (.--1|.--2|.--)      */},
/*183*/ {N("INVOKESPECIAL  ") DF_INVOKE , CF_NORMAL, PEI|CALLS      /*    (.--1|.--2|.--)      */},
/*184*/ {N("INVOKESTATIC   ") DF_INVOKE , CF_NORMAL, PEI|CALLS      /*    (.--1|.--2|.--)      */},
/*185*/ {N("INVOKEINTERFACE") DF_INVOKE , CF_NORMAL, PEI|CALLS      /*    (.--1|.--2|.--)      */},
/*186*/ {N("UNDEF186       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*187*/ {N("NEW            ") DF_0_TO_1 , CF_NORMAL, PEI            /* -- (--A)                */},
/*188*/ {N("NEWARRAY       ") DF_0_TO_1 , CF_NORMAL, PEI            /* -- (--A)                */},
/*189*/ {N("ANEWARRAY      ") DF_0_TO_1 , CF_NORMAL, PEI            /* -- (--A)                */},
/*190*/ {N("ARRAYLENGTH    ") DF_1_TO_1 , CF_NORMAL, PEI            /*    (A--I)               */},
/*191*/ {N("ATHROW         ") DF_1_TO_0 , CF_END   , PEI            /*    (A--)                */},
/*192*/ {N("CHECKCAST      ") DF_1_TO_1 , CF_NORMAL, PEI|CALLS      /*    (A--A)               */},
/*193*/ {N("INSTANCEOF     ") DF_1_TO_1 , CF_NORMAL, PEI|CALLS      /*    (A--I)               */},
/*194*/ {N("MONITORENTER   ") DF_1_TO_0 , CF_NORMAL, PEI|CALLS      /* -- (A--)                */},
/*195*/ {N("MONITOREXIT    ") DF_1_TO_0 , CF_NORMAL, PEI|CALLS      /* -- (A--)                */},
/*196*/ {N("UNDEF196       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*197*/ {N("MULTIANEWARRAY ") DF_N_TO_1 , CF_NORMAL, PEI|CALLS      /*    (.--A)               */},
/*198*/ {N("IFNULL         ") DF_1_TO_0 , CF_IF    , 0              /*    (A--)                */},
/*199*/ {N("IFNONNULL      ") DF_1_TO_0 , CF_IF    , 0              /*    (A--)                */},
/*200*/ {N("UNDEF200       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*201*/ {N("UNDEF201       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*202*/ {N("BREAKPOINT     ") DF_0_TO_0 , CF_NORMAL, 0              /*    (--)                 */},
/*203*/ {N("UNDEF203       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*204*/ {N("IASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*205*/ {N("LASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*206*/ {N("FASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*207*/ {N("DASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*208*/ {N("AASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*209*/ {N("BASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*210*/ {N("CASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*211*/ {N("SASTORECONST   ") DF_2_TO_0 , CF_NORMAL, PEI            /* S+ (AI--)               */},
/*212*/ {N("PUTSTATICCONST ") DF_0_TO_0 , CF_NORMAL, PEI            /* S+ (--)                 */},
/*213*/ {N("PUTFIELDCONST  ") DF_1_TO_0 , CF_NORMAL, PEI            /* S+ (A--)                */},
/*214*/ {N("IMULPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (I--I)               */},
/*215*/ {N("LMULPOW2       ") DF_1_TO_1 , CF_NORMAL, 0              /* S+ (L--L)               */},
/*216*/ {N("IF_FCMPEQ      ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*217*/ {N("IF_FCMPNE      ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*218*/ {N("IF_FCMPL_LT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*219*/ {N("IF_FCMPL_GE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*220*/ {N("IF_FCMPL_GT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*221*/ {N("IF_FCMPL_LE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*222*/ {N("IF_FCMPG_LT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*223*/ {N("IF_FCMPG_GE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*224*/ {N("IF_FCMPG_GT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*225*/ {N("IF_FCMPG_LE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*226*/ {N("IF_DCMPEQ      ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*227*/ {N("IF_DCMPNE      ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*228*/ {N("IF_DCMPL_LT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*229*/ {N("IF_DCMPL_GE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*230*/ {N("IF_DCMPL_GT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*231*/ {N("IF_DCMPL_LE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*232*/ {N("IF_DCMPG_LT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*233*/ {N("IF_DCMPG_GE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*234*/ {N("IF_DCMPG_GT    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*235*/ {N("IF_DCMPG_LE    ") DF_0_TO_0 , CF_IF    , 0              /* -- ()                   */},
/*236*/ {N("UNDEF236       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*237*/ {N("UNDEF237       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*238*/ {N("UNDEF238       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*239*/ {N("UNDEF239       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*240*/ {N("UNDEF240       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*241*/ {N("UNDEF241       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*242*/ {N("UNDEF242       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*243*/ {N("UNDEF243       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*244*/ {N("UNDEF244       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*245*/ {N("UNDEF245       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*246*/ {N("UNDEF246       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*247*/ {N("UNDEF247       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*248*/ {N("UNDEF248       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*249*/ {N("GETEXCEPTION   ") DF_0_TO_1 , CF_NORMAL, 0              /* -- ()                   */},
/*250*/ {N("PHI            ") DF_N_TO_1 , CF_NORMAL, 0              /* -- ()                   */},
/*251*/ {N("INLINE_START   ") DF_0_TO_0 , CF_NORMAL, 0              /* S+ (--)                 */},
/*252*/ {N("INLINE_END     ") DF_0_TO_0 , CF_NORMAL, 0              /* S+ (--)                 */},
/*253*/ {N("INLINE_BODY    ") DF_0_TO_0 , CF_NORMAL, 0              /* S+ (--)                 */},
/*254*/ {N("UNDEF254       ") DF_0_TO_0 , CF_NORMAL, 0              /* -- ()                   */},
/*255*/ {N("BUILTIN        ") DF_BUILTIN, CF_NORMAL, PEI|CALLS      /*    (.--1|.--2|.--)      */}

