/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.genotyper;

import htsjdk.variant.variantcontext.Allele;
import org.broadinstitute.gatk.utils.MathUtils;

public final class MostLikelyAllele {
    public static final double INFORMATIVE_LIKELIHOOD_THRESHOLD = 0.2;
    final Allele mostLikely;
    final Allele secondLikely;
    final double log10LikelihoodOfMostLikely;
    final double log10LikelihoodOfSecondBest;

    public MostLikelyAllele(Allele mostLikely, Allele secondMostLikely, double log10LikelihoodOfMostLikely, double log10LikelihoodOfSecondBest) {
        if (mostLikely == null) {
            throw new IllegalArgumentException("mostLikely allele cannot be null");
        }
        if (log10LikelihoodOfMostLikely != Double.NEGATIVE_INFINITY && !MathUtils.goodLog10Probability(log10LikelihoodOfMostLikely)) {
            throw new IllegalArgumentException("log10LikelihoodOfMostLikely must be either -Infinity or a good log10 prob but got " + log10LikelihoodOfMostLikely);
        }
        if (log10LikelihoodOfSecondBest != Double.NEGATIVE_INFINITY && !MathUtils.goodLog10Probability(log10LikelihoodOfSecondBest)) {
            throw new IllegalArgumentException("log10LikelihoodOfSecondBest must be either -Infinity or a good log10 prob but got " + log10LikelihoodOfSecondBest);
        }
        if (log10LikelihoodOfMostLikely < log10LikelihoodOfSecondBest) {
            throw new IllegalArgumentException("log10LikelihoodOfMostLikely must be <= log10LikelihoodOfSecondBest but got " + log10LikelihoodOfMostLikely + " vs 2nd " + log10LikelihoodOfSecondBest);
        }
        this.mostLikely = mostLikely;
        this.secondLikely = secondMostLikely;
        this.log10LikelihoodOfMostLikely = log10LikelihoodOfMostLikely;
        this.log10LikelihoodOfSecondBest = log10LikelihoodOfSecondBest;
    }

    public Allele getMostLikelyAllele() {
        return this.mostLikely;
    }

    public Allele getSecondMostLikelyAllele() {
        return this.secondLikely;
    }

    public double getLog10LikelihoodOfMostLikely() {
        return this.log10LikelihoodOfMostLikely;
    }

    public double getLog10LikelihoodOfSecondBest() {
        return this.log10LikelihoodOfSecondBest;
    }

    public boolean isInformative() {
        return this.isInformative(0.2);
    }

    public boolean isInformative(double log10ThresholdForInformative) {
        return this.getLog10LikelihoodOfMostLikely() - this.getLog10LikelihoodOfSecondBest() > log10ThresholdForInformative;
    }

    public Allele getAlleleIfInformative() {
        return this.getAlleleIfInformative(0.2);
    }

    public Allele getAlleleIfInformative(double log10ThresholdForInformative) {
        return this.isInformative(log10ThresholdForInformative) ? this.getMostLikelyAllele() : Allele.NO_CALL;
    }
}

