/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.identifier;

import edu.cornell.med.icb.identifier.PropertyMappable;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.lang.MutableString;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedIdentifier
extends Object2IntOpenHashMap<MutableString>
implements PropertyMappable {
    private static final long serialVersionUID = -1829319805452451069L;
    private static final int UNDEFINED_VALUE = -1;
    private int runningIndex;
    private static final String ID2_INDEX_KEY = "id2Index";
    private static final String RUNNING_INDEX_KEY = "runningIndex";

    public IndexedIdentifier(int estimatedSize) {
        super(estimatedSize);
        this.defaultReturnValue(-1);
    }

    public IndexedIdentifier() {
        this.defaultReturnValue(-1);
    }

    public IndexedIdentifier(Map<String, Properties> propertyMap) {
        this();
        this.fromPropertyMap(propertyMap);
    }

    public int registerIdentifier(MutableString id) {
        int index = this.getInt(id);
        if (index == -1) {
            index = this.runningIndex++;
            this.put(id, index);
        }
        return index;
    }

    @Override
    public Object clone() {
        IndexedIdentifier clone = (IndexedIdentifier)super.clone();
        clone.runningIndex = this.runningIndex;
        return clone;
    }

    @Override
    public Map<String, Properties> toPropertyMap() {
        HashMap<String, Properties> propertyMap = new HashMap<String, Properties>();
        Properties id2IndexProperties = new Properties();
        for (Map.Entry entry : this.entrySet()) {
            id2IndexProperties.setProperty(((MutableString)entry.getKey()).toString(), ((Integer)entry.getValue()).toString());
        }
        propertyMap.put(ID2_INDEX_KEY, id2IndexProperties);
        Properties runningIndexProperties = new Properties();
        runningIndexProperties.put(RUNNING_INDEX_KEY, Integer.toString(this.runningIndex));
        propertyMap.put(RUNNING_INDEX_KEY, runningIndexProperties);
        return propertyMap;
    }

    @Override
    public void fromPropertyMap(Map<String, Properties> propertyMap) {
        Properties runningIndexProperties;
        if (propertyMap == null) {
            throw new IllegalArgumentException("Property map cannot be null");
        }
        this.clear();
        Properties id2IndexProperties = propertyMap.get(ID2_INDEX_KEY);
        if (id2IndexProperties != null) {
            for (Map.Entry<Object, Object> entry : id2IndexProperties.entrySet()) {
                this.put(new MutableString(entry.getKey().toString()), NumberUtils.toInt(entry.getValue().toString()));
            }
        }
        this.runningIndex = (runningIndexProperties = propertyMap.get(RUNNING_INDEX_KEY)) != null ? NumberUtils.toInt(runningIndexProperties.getProperty(RUNNING_INDEX_KEY)) : 0;
    }
}

