#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# Psychonauts
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251015.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='psychonauts'
GAME_NAME='Psychonauts'

ARCHIVE_BASE_0_NAME='gog_psychonauts_2.0.0.4.sh'
ARCHIVE_BASE_0_MD5='7fc85f71494ff5d37940e9971c0b0c55'
ARCHIVE_BASE_0_SIZE='5200000'
ARCHIVE_BASE_0_VERSION='1.04-gog2.0.0.4'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/psychonauts'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
Psychonauts
DisplaySettings.ini'
CONTENT_GAME_L10N_FR_FILES='
WorkResource/Localization/French
WorkResource/Sounds/French'
CONTENT_GAME_L10N_DE_FILES='
WorkResource/Localization/German
WorkResource/Sounds/German'
## Because of the Sounds/*voice.isb pattern matching Sounds/*/*voice.isb,
## the English localisation package must be prepared last.
CONTENT_GAME_L10N_EN_FILES='
WorkResource/Localization/English
WorkResource/Sounds/*voice.isb'
CONTENT_GAME_DATA_FILES='
WorkResource/cutscenes
WorkResource/Fonts
WorkResource/PCLevelPackFiles
WorkResource/PixelShaders
WorkResource/SAVEDGAMES
WorkResource/Scripts
WorkResource/Textures
WorkResource/VertexShaders
WorkResource/Localization/Nonsense
WorkResource/Localization/localstrings.str
WorkResource/Sounds/cagpfx_night.isb
WorkResource/Sounds/*fx.isb
WorkResource/Sounds/*fxmem.isb
WorkResource/Sounds/*music.isb
WorkResource/Sounds/*.icb
icon.bmp
PsychonautsData2.pkg
psychonauts.png'
CONTENT_DOC_L10N_EN_RELATIVE_PATH='Documents/Readmes'
CONTENT_DOC_L10N_EN_FILES='
ReadMe.txt'
CONTENT_DOC_L10N_FR_RELATIVE_PATH='Documents/Readmes'
CONTENT_DOC_L10N_FR_FILES='
LisezMoi.txt'
CONTENT_DOC_L10N_DE_RELATIVE_PATH='Documents/Readmes'
CONTENT_DOC_L10N_DE_FILES='
LiesMich.txt'
CONTENT_DOC_DATA_PATH='data/noarch/docs'
CONTENT_DOC_DATA_FILES='
Psychonauts Manual Win.pdf'

APP_MAIN_EXE='Psychonauts'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_PNG APP_MAIN_ICON_BMP'
APP_MAIN_ICON_PNG='psychonauts.png'
APP_MAIN_ICON_BMP='icon.bmp'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_FR
PKG_L10N_DE
PKG_L10N_EN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libSDL-1.2.so.0
libstdc++.so.6'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_DE_ID="${PKG_L10N_ID}-de"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_FR_DESCRIPTION='French localisation'
PKG_L10N_DE_DESCRIPTION='German localisation'
PKG_L10N_EN_DESCRIPTION='English localisation'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrade from pre-20211124.2 packages
PKG_DATA_PROVIDES='
psychonauts-sounds'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Create localisation setting file.

cat > "$(package_path 'PKG_L10N_FR')$(path_game_data)/Psychonauts.ini" << EOF
language french
EOF
cat > "$(package_path 'PKG_L10N_DE')$(path_game_data)/Psychonauts.ini" << EOF
language german
EOF
cat > "$(package_path 'PKG_L10N_EN')$(path_game_data)/Psychonauts.ini" << EOF
language english
EOF

# Write launchers.

launchers_generation

# Build packages.

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_fr='française'
		lang_de='allemande'
		lang_en='anglaise'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_fr='French'
		lang_de='German'
		lang_en='English'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_FR'
printf "$lang_string" "$lang_de"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_DE'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_BIN' 'PKG_DATA' 'PKG_L10N_EN'

# Clean up.

working_directory_cleanup

exit 0
