!{\src2tex{textfont=tt}}
!!****f* ABINIT/readdat
!! NAME
!! readdat
!! 
!! FUNCTION
!! Eventually read data from an additional file (if it exists)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  un_log= Unit number for log file (comments)
!!
!! OUTPUT
!!  pawopt
!!   %iortho=Option governing the re-orthogonalization of Phi, tPhi and tProj
!!   %ishapenum=Option governing the writing of shape functions
!!   %ivhtnzc=Option governing the computation of vH(tnZC)
!!   %rcompfact=Radius for compensation charge (-1 if rcomp=rcut)
!!  pawrso
!!   %ecut_rso=Real Space Optimization parameter: plane wave cutoff = 1/2 Gmax**2
!!   %gfact_rso=Real Space Optimization parameter: Gamma/Gmax ratio
!!   %userso=TRUE if REAL Space Optimization is required
!!   %werror_rso=Real Space Optimization parameter: max. error W_l allowed
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!
!! SOURCE

 subroutine readdat(datfile,pawopt,pawrso,un_log)

 use defs_basis
 use defs_pawps

 implicit none


!Arguments ---------------------------------------------
 integer :: un_log
 character*(fnlen) :: datfile
!Theses types are defined in defs_pawps
 type(pawopt_type)   :: pawopt
 type(pawrso_type)   :: pawrso

!Local variables ---------------------------------------
 integer :: ios
 logical :: ex
 character*(fnlen) :: line

! *********************************************************************

!Default values for options
 pawopt%iortho= 1
 pawopt%ivhtnzc=1
 pawopt%rcompfact=1.d0

!Default values for RSO
 pawrso%ecut=-1.d0
 pawrso%gfact=-1.d0
 pawrso%werror=-1.d0

 inquire(file=trim(datfile),iostat=ios,exist=ex)
 if ((ios/=0).or.(.not.ex)) then
  write(un_log,'(/,3a))') '> USpp->Abinit translator: file ',&
&                         trim(datfile),' does not exists.'
 else
  
  write(un_log,'(/,3a))') '> USpp->Abinit translator: reading ',&
&                         trim(datfile),'...'

  open(10,file=trim(datfile),form='formatted')
10 read(10,'(a)',err=20,end=20) line
   if (line(1:1)/="#".and.line(1:1)/="!") then

    if (line(1:10)=="OPT_ORTHO="    ) read(unit=line(11:fnlen),fmt=*) pawopt%iortho
    if (line(1:11)=="OPT_VHTNZC="   ) read(unit=line(12:fnlen),fmt=*) pawopt%ivhtnzc
    if (line(1:10)=="RCOMPFACT="    ) read(unit=line(11:fnlen),fmt=*) pawopt%rcompfact
    if (line(1:9 )=="SHAPENUM="     ) read(unit=line(10:fnlen),fmt=*) pawopt%ishapenum
    if (line(1:9 )=="ECUT_RSO="     ) read(unit=line(10:fnlen),fmt=*) pawrso%ecut
    if (line(1:14)=="GAMMAFACT_RSO=") read(unit=line(15:fnlen),fmt=*) pawrso%gfact
    if (line(1:11)=="WERROR_RSO="   ) read(unit=line(12:fnlen),fmt=*) pawrso%werror
   endif
   goto 10
20 continue
  close(10)
 endif

 if ((pawrso%ecut<zero).or.(pawrso%gfact<zero) &
&.or.(pawrso%werror<zero)) then
  pawrso%userso=.false.
  write(un_log,'(2(/,a))') '> USpp->Abinit translator COMMENT:',&
&                         '   No Real Space optimization will be done.'
 else
  pawrso%userso=.true.
 endif

 end subroutine readdat

!!***
