//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Fit/FitWorkerLauncher.h
//! @brief     Implements class FitWorkerLauncher
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_FIT_FITWORKERLAUNCHER_H
#define BORNAGAIN_GUI_VIEW_FIT_FITWORKERLAUNCHER_H

#include <QDateTime>
#include <QObject>
#include <atomic>
#include <memory>

class FitObjectiveBuilder;

class FitWorkerLauncher : public QObject {
    Q_OBJECT

public:
    FitWorkerLauncher(QObject* parent);

    void runFitting(std::shared_ptr<FitObjectiveBuilder> suite);

    const QDateTime& fitStart() const;
    const QDateTime& fitEnd() const;

public slots:
    void interruptFitting();

signals:
    void fittingStarted();
    void fittingFinished();
    void fittingError(const QString& message);

    void intern_interruptFittingWorker(QPrivateSignal);

private slots:
    void intern_workerFinished();

    void intern_workerStarted();

    void intern_error(const QString& mesg);

private:
    std::atomic<bool> m_is_fit_running;
    QDateTime m_fit_start;
    QDateTime m_fit_end;
};

#endif // BORNAGAIN_GUI_VIEW_FIT_FITWORKERLAUNCHER_H
