//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/MultiLayerWithRoughnessBuilder.cpp
//! @brief     Implement class MultiLayerWithRoughnessBuilder.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "Sample/StandardSamples/MultiLayerWithRoughnessBuilder.h"
#include "Sample/Interface/LayerRoughness.h"
#include "Sample/Material/MaterialFactoryFuncs.h"
#include "Sample/Multilayer/Layer.h"
#include "Sample/Multilayer/MultiLayer.h"

MultiLayer* ExemplarySamples::createMultiLayerWithRoughness()
{
    const double thicknessA(2.5);
    const double thicknessB(5.0);
    const double sigma(1.0);
    const double hurst(0.3);
    const double lateralCorrLength(5.0);
    const double crossCorrLength(10.0);

    Material vacuum_material = RefractiveMaterial("Vacuum", 0., 0.);
    Material substrate_material = RefractiveMaterial("Substrate", 15e-6, 0.0);
    Material part_a_material = RefractiveMaterial("PartA", 5e-6, 0.0);
    Material part_b_material = RefractiveMaterial("PartB", 10e-6, 0.0);

    Layer vacuum_layer(vacuum_material, 0);
    Layer partA_layer(part_a_material, thicknessA);
    Layer partB_layer(part_b_material, thicknessB);
    Layer substrate_layer(substrate_material, 0);

    LayerRoughness roughness(sigma, hurst, lateralCorrLength);

    auto* sample = new MultiLayer();
    sample->addLayer(vacuum_layer);
    for (int i = 0; i < 5; ++i) {
        sample->addLayerWithTopRoughness(partA_layer, roughness);
        sample->addLayerWithTopRoughness(partB_layer, roughness);
    }
    sample->addLayerWithTopRoughness(substrate_layer, roughness);
    sample->setCrossCorrLength(crossCorrLength);
    return sample;
}
