# -*- coding: utf-8; mode: python; indent-tabs-mode: t; tab-width:4 -*-
class KalmanFilter(object):
	'''
	Credits:http://scottlobdell.me/2014/08/kalman-filtering-python-reading-sensor-input/
	'''
	def __init__(self, process_variance, estimated_measurement_variance):
		self.process_variance = process_variance
		self.estimated_measurement_variance = estimated_measurement_variance
		self.posteri_estimate = 0.0
		self.posteri_error_estimate = 1.0

	def input_latest_noisy_measurement(self, measurement):
		priori_estimate = self.posteri_estimate
		priori_error_estimate = self.posteri_error_estimate + self.process_variance

		blending_factor = priori_error_estimate / (priori_error_estimate + self.estimated_measurement_variance)
		self.posteri_estimate = priori_estimate + blending_factor * (measurement - priori_estimate)
		self.posteri_error_estimate = (1 - blending_factor) * priori_error_estimate

	def get_latest_estimated_measurement(self):
		return self.posteri_estimate

