from .base import DeviceBase
from .control_common import interlock_keys, triggers_keys


class IMGFELCamera(DeviceBase):
    control_keys = [
        ('Logger/file/maxBackupIndex', 'u4', ()),
        ('Logger/file/maxFileSize', 'u4', ()),
        ('Logger/file/mode', 'u4', ()),
        ('acqFrameCount', 'u4', ()),
        ('autoGain', 'u1', ()),
        ('bin/X', 'i4', ()),
        ('bin/Y', 'i4', ()),
        ('exposureTime', 'f8', ()),
        ('flip/X', 'u1', ()),
        ('flip/Y', 'u1', ()),
        ('frameRate', 'f8', ()),
        ('frameTransmissionDelay', 'u4', ()),
        ('gain', 'f8', ()),
        ('imageDepth', 'i4', ()),
        ('interPacketDelay', 'u4', ()),
        ('latencyTime', 'f8', ()),
        ('nbFrames', 'i4', ()),
        ('packetSize', 'u4', ()),
        ('pollingInterval', 'i4', ()),
        ('roi/Height', 'i4', ()),
        ('roi/Width', 'i4', ()),
        ('roi/X', 'i4', ()),
        ('roi/Y', 'i4', ()),
        ('rotation', 'i4', ()),
        ('sensorSize/height', 'i4', ()),
        ('sensorSize/width', 'i4', ()),
        ('simulateCamera', 'u1', ()),
        ('socketBufferSize', 'u4', ()),
        ('temperature', 'f8', ()),
        ('writeFile', 'u1', ()),
    ]

    # Technically, only the part before the / is the output channel.
    # But there is a structure associated with the part one level after that,
    # and we don't know what else to call it.
    output_channels = ('daqOutput/data',)

    instrument_keys = [
        ('image/bitsPerPixel', 'i4', ()),
        ('image/dimTypes', 'i4', (2,)),
        ('image/dims', 'u8', (2,)),
        ('image/encoding', 'i4', ()),
        ('image/pixels', 'u2', (1944, 2592)),
        ('image/roiOffsets', 'u8', (2,)),
    ]


class IMGFELMotor(DeviceBase):
    control_keys = [
        ('ABackEMF', 'u2', ()),
        ('ACoilResistance', 'u2', ()),
        ('ADynOffsFactor', 'f4', ()),
        ('ADynOffsetType', 'u1', ()),
        ('AFunctionInput1', 'u1', ()),
        ('AFunctionInput2', 'u1', ()),
        ('AIntCounter7041', 'u1', ()),
        ('AMotorFullStep', 'u2', ()),
        ('AOffsetDynamic', 'f4', ()),
        ('AOverrun', 'f4', ()),
        ('aMax', 'i2', ()),
        ('acceleration', 'f4', ()),
        ('actualPosition', 'f4', ()),
        ('backlash', 'f4', ()),
        ('busy', 'u1', ()),
        ('calibrateTarget', 'f4', ()),
        ('checkLimitConsistency', 'u1', ()),
        ('controllerVoltage', 'f4', ()),
        ('deadband', 'f4', ()),
        ('encodeStep', 'f4', ()),
        ('epsilon', 'f4', ()),
        ('extEncoderEnabled', 'u1', ()),
        ('force', 'u1', ()),
        ('gear', 'f4', ()),
        ('hardwareErrorDescriptor', 'u4', ()),
        ('hardwareStatusBitField', 'u4', ()),
        ('homeNoLimit', 'u1', ()),
        ('homeUp', 'u1', ()),
        ('invLogicLim1', 'u1', ()),
        ('invLogicLim2', 'u1', ()),
        ('isCCWLimit', 'u1', ()),
        ('isCWLimit', 'u1', ()),
        ('isIdleOpenLoop', 'u1', ()),
        ('isInternalCounter', 'u1', ()),
        ('isInvertLimits', 'u1', ()),
        ('isLimitless', 'u1', ()),
        ('isOnTarget', 'u1', ()),
        ('isSWLimitHigh', 'u1', ()),
        ('isSWLimitLow', 'u1', ()),
        ('isSlave', 'u1', ()),
        ('limitPosH', 'f4', ()),
        ('limitPosL', 'f4', ()),
        ('masterSlaveCorrelation', 'f4', ()),
        ('maxCurrent', 'u2', ()),
        ('maxUpdateFrequency', 'f4', ()),
        ('modus', 'u1', ()),
        ('motorDriverVoltage', 'f4', ()),
        ('offset', 'f4', ()),
        ('pConst', 'f4', ()),
        ('plcCycleAveraging', 'u1', ()),
        ('pollInterval', 'f4', ()),
        ('reducedCurrent', 'u2', ()),
        ('saveLimitPosition', 'u1', ()),
        ('softDeviceId', 'u4', ()),
        ('stepCounterPosition', 'f4', ()),
        ('stepLength', 'f4', ()),
        ('syncEncoder', 'u1', ()),
        ('targetPosition', 'f4', ()),
        ('targetVelocity', 'i2', ()),
        ('terminal', 'u4', ()),
        ('terminalTemperature', 'u1', ()),
        ('vMax', 'i2', ()),
        ('vMin', 'i2', ()),
        ('velocity', 'f4', ()),
    ] + interlock_keys + triggers_keys
