# Fenrir

A modern, modular, flexible and fast console screen reader.
It should run on any operating system. If you want to help, or write drivers to make it work on other systems, just let me know. 
This software is licensed under the LGPL v3.

**Current maintainer:** Storm Dragon  
**Previous developer:** Chrys

## Key Features

- **Multiple Interface Support**: Works in Linux TTY, and terminal emulators
- **Flexible Driver System**: Modular architecture with multiple drivers for speech, sound, input, and screen
- **Review Mode**: Navigate and review screen content without moving the edit cursor
- **Table Navigation**: Advanced table mode with column headers, cell-by-cell navigation, and boundary feedback
- **Progress Bar Monitoring**: Automatic detection and audio feedback for progress indicators with ascending tones
- **Multiple Clipboard Support**: Manage multiple clipboard entries
- **Configurable Key Bindings**: Desktop and laptop keyboard layouts
- **Sound Icons**: Audio feedback for various events
- **Spell Checking**: Built-in spell checker with word management
- **Language Support**: Multiple speech synthesis languages and voices
- **Bookmark System**: Quick access to specific screen areas
- **Auto-announcement**: Automatic reading of incoming text and time announcements
- **Tutorial Mode**: Built-in help system for learning keyboard shortcuts


## OS Requirements

- Linux (ptyDriver, vcsaDriver, evdevDriver) - Primary platform with full support
- macOS (ptyDriver) - Limited support
- BSD (ptyDriver) - Limited support  
- Windows (ptyDriver) - Limited support


## Core Requirements

- Python 3 >= 3.9 (recommended 3.13+)
- Screen, input, speech, sound driver dependencies (see "Features, Drivers, Extras" section)
- For full functionality on Linux: evdev, speech-dispatcher, sox


## Features, Drivers, Extras, Dependencies

### Input Drivers:
1. **evdevDriver** - Linux evdev input driver (recommended for Linux)
   - python-evdev >=0.6.3 (This is commonly referred to as python3-evdev by your distribution)
   - python-pyudev
   - loaded uinput kernel module
   - ReadWrite permission:
     - /dev/input
     - /dev/uinput
2. **ptyDriver** - Terminal emulation input driver (cross-platform)
   - python-pyte
3. **atspiDriver** - AT-SPI input driver for desktop environments
   - python-pyatspi2

### Remote Drivers:
1. **unixDriver** - Unix socket remote control (default)
   - socat (for command-line interaction)
2. **tcpDriver** - TCP socket remote control (localhost only)
   - netcat or telnet (for command-line interaction)


### Screen Drivers:

1. **vcsaDriver** - Linux VCSA devices driver (recommended for Linux TTY)
   - python-dbus
   - Read permission to the following files and services:
     - /sys/devices/virtual/tty/tty0/active
     - /dev/tty[1-64]
     - /dev/vcsa[1-64]
     - read logind DBUS
2. **ptyDriver** - Terminal emulation driver (cross-platform)
   - python-pyte
  

### Speech Drivers:

1. **speechdDriver** - Speech-dispatcher driver (recommended)
   - Speech-dispatcher
   - python-speechd
2. **genericDriver** - Generic subprocess speech driver
   - espeak or espeak-ng (or any TTS command)
3. **debugDriver** - Debug speech driver for testing
   - No dependencies


### Sound Drivers:

1. **genericDriver** (default) - Generic subprocess sound driver
   - Sox with opus support (recommended)
2. **gstreamerDriver** - GStreamer sound driver
   - gstreamer >=1.0
   - GLib
3. **debugDriver** - Debug sound driver for testing
   - No dependencies


## Extras:

1. spellchecker
  - python-pyenchant
  - aspell-YourLanguageCode (example aspell-en for us English)
2. Unix daemon (also needed for Systemd):
  - python-daemonize
3. Modify system volume:
  - pyalsaaudio (needs libasound2's headers).


## installation

If there is a package for your distrobution of choice, please let us know so we can add it here.

- Archlinux: PKGBUILD in AUR
  - fenrir: stable release
  - fenrir-git: Bleeding edge release
- Manual:
  - install "espeak" and "sox" with your package manager
  - sudo pip install -r requirements.txt 
  - run install.sh or uninstall.sh as root
- You can also just run it from Git without installing:
Requires root privileges

    cd src/
    sudo ./fenrir

Settings are located in:
- **After installation**: `/etc/fenrir/settings/settings.conf`
- **Development**: `config/settings/settings.conf`

By default Fenrir uses:
- **Sound driver**: genericDriver (via sox)
- **Speech driver**: speechdDriver (via speech-dispatcher) 
- **Input driver**: evdevDriver (Linux) or ptyDriver (other platforms)
- **Screen driver**: vcsaDriver (Linux TTY) or ptyDriver (terminal emulation)

## Getting Started

### Basic Usage

1. **Start Fenrir**:
   ```bash
   sudo systemctl start fenrir  # If installed as service
   # OR
   sudo fenrir                  # Run directly
   ```

2. **Basic Navigation**:
   - **Fenrir Key**: By default `Insert`, `Keypad Insert`, or `Meta/Super` key
   - **Tutorial Mode**: `Fenrir + H` to learn all commands interactively
   - **Quit Fenrir**: `Fenrir + Q`

3. **Essential Commands**:
   - `Ctrl` - Stop speech (shut up)
   - `Fenrir + Keypad 5` - Read current screen
   - `Keypad 8` - Read current line
   - `Keypad 5` - Read current word
   - `Keypad 2` - Read current character
   - `Fenrir + T` - Announce time
   - `Fenrir + S` - Spell check current word
   - `Fenrir + Keypad *` - Toggle table mode / highlight tracking

### Keyboard Layouts

Fenrir supports two main keyboard layouts:

- **Desktop Layout**: Uses numeric keypad for navigation (recommended for desktop users)
- **Laptop Layout**: Alternative bindings for keyboards without numeric keypad

Configure in `/etc/fenrir/settings/settings.conf`:
```ini
[keyboard]
keyboardLayout=desktop  # or 'laptop'
```

### First Time Setup

1. **Enable Fenrir at boot**:
   ```bash
   sudo systemctl enable fenrir
   ```

2. **Configure audio** (if needed):
   - For PulseAudio: Run configure_pulse.sh script (see below)
   - For PipeWire: Run configure_pipewire.sh script (see below)

3. **Test speech**:
   ```bash
   # Test speech-dispatcher directly
   sudo spd-say "Hello World"
   ```

## Remote Control

Fenrir includes a powerful remote control system that allows external applications and scripts to control Fenrir through Unix sockets or TCP connections. This is particularly useful for automation, integration with other applications, or providing alternative control methods.

### Configuration

Enable remote control in `/etc/fenrir/settings/settings.conf`:

```ini
[remote]
enable=True
driver=unixDriver              # or tcpDriver
port=22447                     # for TCP driver
socketFile=                    # custom socket path (optional)
enableSettingsRemote=True      # allow settings changes
enableCommandRemote=True       # allow command execution
```

### Remote Drivers

1. **unixDriver** (recommended): Uses Unix domain sockets
   - Socket location: `/tmp/fenrirscreenreader-deamon.sock` (TTY mode) or `/tmp/fenrirscreenreader-<pid>.sock`
   - More secure, local-only access
   - Works with `socat`

2. **tcpDriver**: Uses TCP sockets on localhost
   - Default port: 22447
   - Works with `netcat`, `telnet`, or any TCP client
   - Local connections only (127.0.0.1)

### Using socat with Unix Sockets

The `socat` command provides the easiest way to send commands to Fenrir:

#### Basic Speech Control
```bash
# Interrupt current speech
echo "command interrupt" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Speak custom text
echo "command say Hello, this is a test message" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Temporarily disable speech (until next keystroke)
echo "command tempdisablespeech" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

#### Settings Control
```bash
# Enable highlight tracking mode
echo "setting set focus#highlight=True" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Change speech parameters
echo "setting set speech#rate=0.8" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set speech#pitch=0.6" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set speech#volume=0.9" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Change punctuation level (none/some/most/all)
echo "setting set general#punctuationLevel=all" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set general#punctuationLevel=none" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Voice and TTS engine control
echo "setting set speech#voice=en-us+f3" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set speech#module=espeak-ng" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Disable sound temporarily
echo "setting set sound#enabled=False" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set sound#volume=0.5" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Keyboard and input settings
echo "setting set keyboard#charEchoMode=1" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting set keyboard#wordEcho=True" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Screen control (ignore specific TTYs)
echo "setting set screen#ignoreScreen=1,2,3" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Multiple settings at once
echo "setting set speech#rate=0.8;sound#volume=0.7;general#punctuationLevel=most" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Reset all settings to defaults
echo "setting reset" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Save current settings
echo "setting save" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
echo "setting saveas /tmp/my-fenrir-settings.conf" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

#### Clipboard Operations
```bash
# Place text into clipboard
echo "command clipboard This text will be copied to clipboard" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Export clipboard to file
echo "command exportclipboard" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

#### Window Management
```bash
# Define a window area (x1 y1 x2 y2)
echo "command window 0 0 80 24" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Reset window to full screen
echo "command resetwindow" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

#### VMenu Control
```bash
# Set virtual menu context
echo "command vmenu nano/file" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Reset virtual menu
echo "command resetvmenu" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

#### Application Control
```bash
# Quit Fenrir
echo "command quitapplication" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock
```

### Using TCP Driver

If using the TCP driver, replace socat commands with netcat:

```bash
# Using netcat
echo "command say Hello from TCP" | nc localhost 22447

# Using telnet
echo "command interrupt" | telnet localhost 22447
```

### Remote Command Reference

#### Command Format
```
command <action> [parameters]
setting <action> [parameters]
```

#### Available Commands

**Speech Commands:**
- `command say <text>` - Speak the specified text
- `command interrupt` - Stop current speech
- `command tempdisablespeech` - Disable speech until next key press

**Clipboard Commands:**
- `command clipboard <text>` - Add text to clipboard
- `command exportclipboard` - Export clipboard to file

**Window Commands:**
- `command window <x1> <y1> <x2> <y2>` - Define window area
- `command resetwindow` - Reset to full screen

**VMenu Commands:**
- `command vmenu <menu_path>` - Set vmenu context
- `command resetvmenu` - Reset vmenu

**Application Commands:**
- `command quitapplication` - Quit Fenrir

#### Available Settings

**Settings Commands:**
- `setting set <section>#<key>=<value>` - Set configuration value
- `setting reset` - Reset all settings to defaults
- `setting save [path]` - Save current settings
- `setting saveas <path>` - Save settings to specific file

**Common Settings:**

*Speech Settings:*
- `speech#enabled=True/False` - Enable/disable speech
- `speech#rate=0.1-1.0` - Speech rate (speed)
- `speech#pitch=0.1-1.0` - Speech pitch (tone)
- `speech#volume=0.1-1.0` - Speech volume
- `speech#voice=voice_name` - Voice selection (e.g., "en-us+f3")
- `speech#module=module_name` - TTS module (e.g., "espeak-ng")
- `speech#driver=driver_name` - Speech driver (speechdDriver/genericDriver)
- `speech#autoReadIncoming=True/False` - Auto-read new text

*Sound Settings:*
- `sound#enabled=True/False` - Enable/disable sound
- `sound#volume=0.1-1.0` - Sound volume
- `sound#driver=driver_name` - Sound driver (genericDriver/gstreamerDriver)
- `sound#theme=theme_name` - Sound theme

*General Settings:*
- `general#punctuationLevel=none/some/most/all` - Punctuation verbosity
- `general#debugLevel=0-3` - Debug level
- `general#emoticons=True/False` - Enable emoticon replacement
- `general#autoSpellCheck=True/False` - Automatic spell checking

*Focus Settings:*
- `focus#cursor=True/False` - Follow text cursor
- `focus#highlight=True/False` - Follow text highlighting

*Keyboard Settings:*
- `keyboard#charEchoMode=0-2` - Character echo (0=none, 1=always, 2=capslock only)
- `keyboard#wordEcho=True/False` - Echo complete words
- `keyboard#charDeleteEcho=True/False` - Echo deleted characters
- `keyboard#interruptOnKeyPress=True/False` - Interrupt speech on key press

*Screen Settings:*
- `screen#ignoreScreen=1,2,3` - TTY screens to ignore
- `screen#autodetectIgnoreScreen=True/False` - Auto-detect screens to ignore
- `screen#screenUpdateDelay=float` - Screen update delay

*Time Settings:*
- `time#enabled=True/False` - Enable time announcements
- `time#presentTime=True/False` - Announce time
- `time#presentDate=True/False` - Announce date changes
- `time#delaySec=seconds` - Announcement interval
- `time#onMinutes=00,30` - Specific minutes to announce

## Table Navigation

Fenrir includes advanced table navigation capabilities for working with tabular data in terminal applications, CSV files, and formatted text output.

### Entering Table Mode

Table mode is activated through the **toggle_highlight_tracking** command, which cycles through three focus modes:

1. **Highlight tracking mode** (default) - Follows text highlighting
2. **Cursor tracking mode** - Follows text cursor movement
3. **Table mode** - Enables table navigation

**Key bindings:**
- **Desktop layout**: `Fenrir + Keypad *` (asterisk)
- **Laptop layout**: `Fenrir + Y`

Press the key combination repeatedly to cycle through modes until you hear "table mode enabled".

### Table Navigation Commands

#### Column Navigation (Desktop Layout)
- **Next column**: `Keypad 6` - Move to next table column
- **Previous column**: `Keypad 4` - Move to previous table column
- **First column**: `Fenrir + Keypad 4` - Jump to first column of current row
- **Last column**: `Fenrir + Keypad 6` - Jump to last column of current row

#### Column Navigation (Laptop Layout)
- **Next column**: `Fenrir + L` - Move to next table column
- **Previous column**: `Fenrir + J` - Move to previous table column
- **First column**: `Fenrir + Shift + J` - Jump to first column of current row
- **Last column**: `Fenrir + Shift + L` - Jump to last column of current row

#### Cell Character Navigation
- **First character in cell**: `Fenrir + Keypad 1` (desktop) or `Fenrir + Ctrl + J` (laptop)
- **Last character in cell**: `Fenrir + Keypad 3` (desktop) or `Fenrir + Ctrl + L` (laptop)

### Setting Column Headers

For better navigation experience, you can set column headers:

1. **Navigate to header row**: Use normal navigation to reach the row containing column headers
2. **Set headers**: Press `Fenrir + X` to mark the current line as the header row
3. **Navigation feedback**: Column headers will be announced along with cell content

### Table Detection

Fenrir automatically detects table structures using multiple strategies:
- **Delimited text**: CSV, pipe-separated (`|`), semicolon-separated (`;`), tab-separated
- **Aligned columns**: Space-aligned columns (2+ spaces between columns)
- **Flexible parsing**: Handles various table formats commonly found in terminal applications

### Table Mode Features

- **Cell-by-cell navigation**: Navigate through table cells with precise positioning
- **Column header support**: Set and announce column headers for better context
- **Boundary feedback**: Audio cues when reaching start/end of rows
- **Empty cell handling**: Blank cells are announced as "blank"
- **Independent tracking**: Table position is maintained independently of cursor movement

### Speech Output in Table Mode

When navigating in table mode, Fenrir announces:
- **Cell content** followed by **column header/name**
- **Boundary notifications**: "end of line", "start of line"
- **Position indicators**: "first character in cell [column name]"

### Example Usage

```bash
# Working with CSV data
cat data.csv
Name,Age,City
Alice,30,New York
Bob,25,Los Angeles

# 1. Press Fenrir + Keypad * until "table mode enabled"
# 2. Navigate to "Name,Age,City" line
# 3. Press Fenrir + X to set headers
# 4. Use Keypad 4/6 to navigate between columns
# 5. Each cell will be announced with its column header
```

## Progress Bar Monitoring

Fenrir provides intelligent progress bar detection and audio feedback for various progress indicators commonly found in terminal applications.

### Enabling Progress Monitoring

**Command**: `progress_bar_monitor` (no default key binding - assign manually)

To enable progress monitoring:
1. Add a key binding in your keyboard layout file
2. Or use the remote control system: `echo "command progress_bar_monitor" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock`

### Progress Detection Patterns

Fenrir automatically detects various progress indicator formats:

#### 1. Percentage Progress
```
Download: 45%
Processing: 67.5%
Installing: 100%
```

#### 2. Fraction Progress
```
Files: 15/100
Progress: 3 of 10
Step 7/15
```

#### 3. Progress Bars
```
[####      ] 40%
[====>     ] 50%
[**********] 100%
```

#### 4. Activity Indicators
```
Loading...
Processing...
Working...
Installing...
Downloading...
Compiling...
Building...
```

### Audio Feedback

#### Progress Tones
- **Ascending tones**: 400Hz to 1200Hz frequency range
- **Percentage mapping**: 0% = 400Hz, 100% = 1200Hz
- **Smooth progression**: Frequency increases proportionally with progress

#### Activity Indicators
- **Steady beep**: 800Hz tone every 2 seconds for ongoing activity
- **Non-intrusive**: Beeps don't interrupt speech or other audio

### Progress Monitoring Features

- **Automatic detection**: No manual configuration required
- **Multiple format support**: Handles various progress indicator styles
- **Prompt awareness**: Automatically pauses when command prompts are detected
- **Non-blocking**: Progress tones don't interrupt speech or other functionality
- **Configurable**: Can be enabled/disabled as needed

### Usage Examples

```bash
# Enable progress monitoring
echo "command progress_bar_monitor" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock

# Common scenarios where progress monitoring is useful:
wget https://example.com/large-file.zip    # Download progress
tar -xvf archive.tar.gz                    # Extraction progress
make -j4                                   # Compilation progress
pacman -S package                          # Package installation
rsync -av source/ destination/             # File synchronization
```

### Customization

Progress monitoring can be configured through settings:
- **Default enabled**: Set `progressMonitoring=True` in sound section
- **Sound integration**: Works with all sound drivers (sox, gstreamer)
- **Remote control**: Enable/disable through remote commands

### Scripting Examples

#### Bash Script for Speech Notifications
```bash
#!/bin/bash
# notify_fenrir.sh - Send notifications to Fenrir

SOCKET="/tmp/fenrirscreenreader-deamon.sock"

fenrir_say() {
    echo "command say $1" | socat - UNIX-CLIENT:$SOCKET
}

fenrir_interrupt() {
    echo "command interrupt" | socat - UNIX-CLIENT:$SOCKET
}

# Usage examples
fenrir_say "Build completed successfully"
fenrir_interrupt
```

#### Python Integration
```python
#!/usr/bin/env python3
import socket
import os

def send_fenrir_command(command):
    """Send command to Fenrir via Unix socket"""
    socket_path = "/tmp/fenrirscreenreader-deamon.sock"
    if os.path.exists(socket_path):
        sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        try:
            sock.connect(socket_path)
            sock.send(command.encode('utf-8'))
        finally:
            sock.close()

# Examples
send_fenrir_command("command say Processing complete")
send_fenrir_command("setting set speech#rate=0.9")
```

### Security Considerations

- Unix sockets are accessible only to the user running Fenrir
- TCP driver binds only to localhost (127.0.0.1)
- Socket file permissions are set to write-only (0o222)
- Commands are processed with Fenrir's privileges
- Settings changes can be disabled via `enableSettingsRemote=False`
- Command execution can be disabled via `enableCommandRemote=False`

### Troubleshooting

**Socket not found:**
- Verify Fenrir is running: `ps aux | grep fenrir`
- Check socket location: `/tmp/fenrirscreenreader-*`
- Ensure remote driver is enabled in settings

**Commands not working:**
- Verify `enableCommandRemote=True` in settings
- Check Fenrir debug logs: `/var/log/fenrir.log`
- Test with simple command: `echo "command interrupt" | socat - UNIX-CLIENT:/tmp/fenrirscreenreader-deamon.sock`

## Configure pulseaudio

Pulseaudio by default only plays sound for the user its currently running for. As fenrir is running as root, your local user does not hear the sound and speech produced by fenrir.
for this fenrir provides a script to configure pulseaudio to stream the sound played as root to your local user. This is not a issue of fenrir but this is how pulseaudio works.

just run the configuration script twice (once as user, once as root):

    /usr/share/fenrirscreenreader/tools/configure_pulse.sh
    sudo /usr/share/fenrirscreenreader/tools/configure_pulse.sh

The script is also located in the tools directory in git


## Configure pipewire

Pipewire by default only plays sound for the user its currently running for. As fenrir is running as root, your local user does not hear the sound and speech produced by fenrir.
for this fenrir provides a script to configure pipewire to stream the sound played as root to your local user. This is not a issue of fenrir but this is how pipewire works.

just run the configuration script twice (once as user, once as root):

    /usr/share/fenrirscreenreader/tools/configure_pipewire.sh
    sudo /usr/share/fenrirscreenreader/tools/configure_pipewire.sh

The script is also located in the tools directory in git

## Command Line Options

Fenrir supports several command-line options for different use cases:

```
fenrir [OPTIONS]
```

### Options:
- `-h, --help` - Show help message and exit
- `-v, --version` - Show version information and exit
- `-f, --foreground` - Run in foreground (don't daemonize)
- `-s, --setting SETTING-FILE` - Path to custom settings file
- `-o, --options SECTION#SETTING=VALUE;..` - Override settings file options
- `-d, --debug` - Enable debug mode
- `-p, --print` - Print debug messages to screen
- `-e, --emulated-pty` - Use PTY emulation with escape sequences for input (enables desktop/X/Wayland usage)
- `-E, --emulated-evdev` - Use PTY emulation with evdev for input (single instance)
- `-F, --force-all-screens` - Force Fenrir to respond on all screens, ignoring ignoreScreen setting
- `-i, -I, --ignore-screen SCREEN` - Ignore specific screen(s). Can be used multiple times. Combines with existing ignore settings.

### Examples:
```bash
# Run in foreground with debug output
sudo fenrir -f -d

# Use PTY emulation for desktop use
sudo fenrir -e

# Override settings via command line
sudo fenrir -o "speech#rate=0.8;sound#volume=0.5"

# Force Fenrir to work on all screens (ignore ignoreScreen setting)
sudo fenrir -F

# Ignore specific screens
sudo fenrir --ignore-screen 1
sudo fenrir -i 1 -i 2    # Ignore screens 1 and 2
```

## Localization
Translation files are located in the `locale/` directory. To install translations:

```bash
# Copy translation file to system location
sudo cp locale/your_language/LC_MESSAGES/fenrir.mo /usr/share/locale/your_language/LC_MESSAGES/fenrir.mo
```

Available languages:
- German (de)
- Spanish (es) 
- Polish (pl)
- Portuguese (pt)
- Russian (ru)

## Documentation and Support

- **Email list**: [stormux+subscribe@groups.io](mailto:stormux+subscribe@groups.io?subject=subscribe) with the subject subscribe
- **Fenrir Wiki**: [https://git.stormux.org/storm/fenrir/wiki](https://git.stormux.org/storm/fenrir/wiki)
- **IRC**: irc.stormux.org #stormux
- **Issues**: Report bugs and feature requests on the project repository
